PROGRAM WtrConf;

{$A+,B-,F-,I+,P-,Q-,R-,S-,V+,X+}
{$M 16384,0,655360}

{ WaterGate Configuratie Programma }

{ History:

RvdW 20-02-93 Deze file afgesplitst in meerder units.
     21-05-93 Problem Finders menu optie toegevoegd.
     06-06-93 GroupDesc uitgebreid met OriginAka en de edit routines hiervoor
              flink overhoop gehaald.
     07-06-93 .TDB Header controle toegevoegd.
     01-11-93 KeysLine wordt nu correct geset
}

{$IFNDEF WTRCONF} #### Check your conditional defines! ### {$ENDIF}

{$IFNDEF OS2}
{$IFOPT G+}       #### Compile met 286 OFF graag!      ### {$ENDIF}
{$ENDIF}

USES Ramon,
     Database,
     AreaBase,
     UserBase,
     Globals,
     Err_Func,
     Fido,
    {CfgExport,}
     ListSrv,
     Cfg,
     CfgEdit,
     Import,
     Dos,
     Tdb,
     Copyrigh,
     CheckCfg;

CONST DesktopProgramName = 'WaterGate Configuration'{$IFDEF OS2}+'/2'{$ENDIF};

{=== Group Descriptions Database Manipulation Routines ====================}

VAR OriginAkaDesc : STRING[MaxLenFidoAddrString];
    GroupData     : GroupDescRecord;

{--------------------------------------------------------------------------}
{ EditGroupDescOriginAka                                                   }
{                                                                          }
{ Met deze routine kan een andere origin aka voor deze group               }
{ uitgekozen worden.                                                       }
{                                                                          }
PROCEDURE EditGroupDescOriginAka; FAR;

VAR Keuze : WORD;
    Line  : STRING[50];
    Lp    : 1..MaxAkas;

BEGIN
     ListDefine (39,10,35,14,Default,'Origin AKAs',1403);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR Lp:=1 TO MaxAkas DO
     BEGIN
          Line:=Fido2Str (Config.NodeNrs[Lp]);
          IF (Line <> '0') THEN
             ListAddItem (Line,Lp,Convert);
     END;

     ListSetCursorOnItem (GroupData.OriginAka);

     IF (ListItemCount = 0) THEN
        ListAddItem (Line,1,Bottom);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        WITH GroupData DO
        BEGIN
             OriginAka:=Keuze;
             OriginAkaDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[OriginAka]));
        END;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditSingleGroup                                                          }
{                                                                          }
PROCEDURE EditSingleGroup (GroupNr : GroupDescBaseRecordNrType);

CONST Yb = 6;
      Xl = MaxLenFidoAddrString+23;
      Xb = 40-(Xl DIV 2);
      Yl = 6;

VAR Quit : BOOLEAN;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;
     ReadGroupDescRecord (GroupNr,GroupData);

     WITH GroupData DO
     BEGIN
          GroupDesc:=AddUpWithSpaces (MaxLenGroupDesc,GroupDesc);
          OriginAkaDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[OriginAka]));
     END;

     WriteXY (Xb+2,Yb+1,'Group');
     WriteXY (Xb+21,Yb+1,BuildSingleGroupDesc (GroupNr));

     WriteXY (Xb+2,Yb+2,'Description ');
     FieldAutoDefineLongOne (Xb+21,Yb+2,48,@GroupData.GroupDesc,RepChar (MaxLenGroupDesc,'$'));
     FieldSetHelp (0,1401);

     WriteXY (Xb+2,Yb+3,'Default Origin Aka');
     FieldAutoDefineList (Xb+21,Yb+3,@OriginAkaDesc,EditGroupDescOriginAka);
     FieldSetHelp (0,1402);

     WriteXY (Xb+2,Yb+4,'Read-only group');
     FieldAutoDefineToggles (Xb+21,Yb+4,GroupData.ReadOnly,'no|yes',0);
     FieldSetHelp (0,1404);

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key = kEsc) THEN
           BEGIN
                WriteGroupDescRecord (GroupNr,GroupData);
                Quit:=TRUE;
           END;
     UNTIL Quit;

     WindowPop; { edit window }
END;


{--------------------------------------------------------------------------}
{ MoveAllUsersGroupAccess                                                  }
{                                                                          }
{
{                                                                          }
PROCEDURE MoveAllUsersGroupAccess (OldGroupNr,NewGroupNr : GroupDescBaseRecordNrType);

VAR UserLp  : UserBaseRecordNrType;
    UserRec : UserBaseRecord;

BEGIN
     Message ('Moving user access from group '+
              BuildSingleGroupDesc (OldGroupNr)+' to group '+BuildSingleGroupDesc (NewGroupNr));

     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserRec);

          { if part of old group }
          IF TestIfInGroup (UserRec.Groups,OldGroupNr) THEN
          BEGIN
               { remove old group }
               DeleteGroupFromGroupList (UserRec.Groups,OldGroupNr);

               { add new group }
               AddGroupToGroupList (UserRec.Groups,NewGroupNr);

               { write back to disk }
               WriteUserBaseRecord (UserLp,UserRec);
          END;
     END; { for }

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ MoveAllAreasGroupAccess                                                  }
{                                                                          }
{
{                                                                          }
PROCEDURE MoveAllAreasGroupAccess (OldGroupNr,NewGroupNr : GroupDescBaseRecordNrType);

VAR AreaLp  : AreaBaseRecordNrType;
    AreaRec : AreaBaseRecord;

BEGIN
     Message ('Moving area access from group '+
              BuildSingleGroupDesc (OldGroupNr)+' to group '+BuildSingleGroupDesc (NewGroupNr));

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaRec);

          { if part of old group }
          IF TestIfInGroup (AreaRec.IsInGroups,OldGroupNr) THEN
          BEGIN
               { remove old group }
               DeleteGroupFromGroupList (AreaRec.IsInGroups,OldGroupNr);

               { add new group }
               AddGroupToGroupList (AreaRec.IsInGroups,NewGroupNr);

               { write back to disk }
               WriteAreaBaseRecord (AreaLp,AreaRec);
          END;
     END; { for }

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ MoveSingleGroup                                                          }
{                                                                          }
{ Met deze routine kan een groep naar een nieuwe locatie verhuisd worden.  }
{ Alle verwijzingen worden ook veranderd.                                  }
{                                                                          }
FUNCTION MoveSingleGroup (GroupNr : GroupDescBaseRecordNrType) : GroupDescBaseRecordNrType;

VAR Lp         : 1..MaxGroups;
    NewGroupNr : GroupDescBaseRecordNrType;
    MoveUsers,
    MoveAreas  : BOOLEAN;

BEGIN
     MoveSingleGroup:=GroupNr; { no move }

     ListDefine (Video.Cols-3,3,Video.Cols-10,Video.Rows-4,TopRight,
                 'Select a new position for group '+BuildSingleGroupDesc (GroupNr),1406);

     FOR Lp:=1 TO MaxGroups DO
         IF (Lp <> GroupNr) THEN
         BEGIN
              ReadGroupDescRecord (Lp,GroupData);
              ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
         END;

     NewGroupNr:=ListSelect (NoTag,[]);

     IF (Key = kEsc) THEN
     BEGIN
          ListErase;
          Exit;
     END;

     MenuDefine (15,10,'The old group definition will be overwritten!');
     MenuSetHelp (1407);
     MenuAddItem ('That''s OK, continue');
     MenuAddItem ('Abort!');
     MenuShow;
     MenuSelect;
     MenuErase;

     IF (Key IN [kEsc,mOpt02]) THEN
     BEGIN
          ListErase;
          Exit;
     END;

     MenuDefine (20,10,'Move access for users as well?');
     MenuSetHelp (1408);
     MenuAddItem ('Yes, move user access');
     MenuAddItem ('Skip');
     MenuAddItem ('Abort entire move');
     MenuShow;
     MenuSelect;
     MenuErase;

     CASE Key OF
          mOpt01:
              MoveUsers:=TRUE;

          mOpt02:
              MoveUsers:=FALSE;

          kEsc,
          mOpt03 :
              BEGIN
                   ListErase;
                   Exit;
              END;

     END; { case }

     MenuDefine (21,10,'Move areas access as well?');
     MenuSetHelp (1409);
     MenuAddItem ('Yes, move areas');
     MenuAddItem ('Skip');
     MenuAddItem ('Abort entire move');
     MenuShow;
     MenuSelect;
     MenuErase;

     CASE Key OF
          mOpt01:
              MoveAreas:=TRUE;

          mOpt02:
              MoveAreas:=FALSE;

          kEsc,
          mOpt03 :
              BEGIN
                   ListErase;
                   Exit;
              END;

     END; { case }

     { move group }
     ReadGroupDescRecord (GroupNr,GroupData);
     WriteGroupDescRecord (NewGroupNr,GroupData);

     { move user access }
     IF MoveUsers THEN
        MoveAllUsersGroupAccess (GroupNr,NewGroupNr);

     { move area access }
     IF MoveAreas THEN
        MoveAllAreasGroupAccess (GroupNr,NewGroupNr);

     { erase old group description }
     WITH GroupData DO
     BEGIN
          GroupDesc:=AddUpWithSpaces (MaxLenGroupDesc,'<no description>');
          OriginAka:=1;
          ReadOnly:=FALSE;
     END; { with }

     WriteGroupDescRecord (GroupNr,GroupData);

     ListErase;
     MoveSingleGroup:=NewGroupNr;
END;


{--------------------------------------------------------------------------}
{ EditGroupDescriptions                                                    }
{                                                                          }
{ Met deze routine kunnen de omschrijvingen van de groupen worden inge-    }
{ voerd en aangepast.                                                      }
{                                                                          }
PROCEDURE EditGroupDescriptions;

VAR Lp    : GroupNrType;
    New,
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,Video.Cols-10{70},Video.Rows-4{21},Default,'Group descriptions list',1400);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END;

     Quit:=FALSE;
     REPEAT
           ListNoTagKeysLine:=' ^F1 Help  ^Esc Return  ^'#24#25' Select  ^Enter Edit  ^F2 Move';

           Keuze:=ListSelect (NoTag,[kF2]);

           ListNoTagKeysLine:=ORG_ListNoTagKeysLine;

           CASE Key OF
                kF2 :
                    BEGIN
                         { move group to new area }
                         New:=MoveSingleGroup (Keuze);

                         IF (New <> Keuze) THEN
                         BEGIN
                              ReadGroupDescRecord (Keuze,GroupData);
                              ListSetItemTekst (Keuze,BuildGroupDesc (Keuze,GroupData));

                              ReadGroupDescRecord (New,GroupData);
                              ListSetItemTekst (New,BuildGroupDesc (New,GroupData));

                              ListSetCursorOnItem (New);
                         END;
                    END;

                kRet :
                    BEGIN
                         EditSingleGroup (Keuze);
                         ListSetItemTekst (Keuze,BuildGroupDesc (Keuze,GroupData));
                    END;

                kEsc :
                    Quit:=TRUE;

           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ TellAboutMessage                                                         }
{                                                                          }
{ Deze routine geeft de 'About' message op het scherm en wacht daarna op   }
{ een toetsdruk.                                                           }
{                                                                          }
PROCEDURE TellAboutMessage;

CONST Xb = 22;
      Yl = 14;

VAR Yb : XYType;
    Xl : XYType;

BEGIN
     Yb:=(Video.Rows DIV 2)-(Yl DIV 2);
     Xl:=19+Length (FullProgramVersion);
     IF (Xl < 35) THEN Xl:=35;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDrawC (cMessage,Single,Xb,Yb,Xl,Yl);

     WriteXYC (Xb+2,Yb+1,cMessage,DesktopProgramName);
     WriteXY (Xb+2,Yb+2,'Version number '+FullProgramVersion);
     WriteXY (Xb+2,Yb+3,'Compiled at '+CompileDateAndTime);
     WriteXY (Xb+2,Yb+5,'Authors: Ramon van der Winkel');
     WriteXY (Xb+2,Yb+6,'         Martijn Dijksterhuis');
     WriteXY (Xb+2,Yb+7,'         Michel van der Laan');
     WriteXY (Xb+2,Yb+9,'Support: support@wsd.wline.se');
     WriteXY (Xb+2,Yb+10,Repchar (Xl-4,''));

     {$IFDEF OS2}
     WriteXY (Xb+2,Yb+11,'Mode        : OS/2 PM VIO');
     {$ELSE}
     {$IFDEF DPMI}
     WriteXY (Xb+2,Yb+11,'Mode        : DPMI');
     {$ELSE}
     {$IFDEF USEOVR}
     WriteXY (Xb+2,Yb+11,'Mode        : Overlay');
     {$ELSE}
     WriteXY (Xb+2,Yb+11,'Mode        : Normal');
     {$ENDIF (USEOVR)}
     {$ENDIF (DPMI)}
     {$ENDIF (OS2)}

     WriteXY (Xb+2,Yb+12,'Free memory : '+Longint2String (MemAvail DIV 1024)+'Kb');

     PushKeysLine;
     WriteKeysLine (' Press any key to continue...');
     ReadKey;
     PopKeysLine;
     WindowPop;
END;


PROCEDURE ShowHelp;
BEGIN
     WriteLn ('Starting the program without any command line parameters will give a desktop');
     WriteLn ('with menu from which you can choose any of the options shown below.');
     WriteLn;
     WriteLn ('Usage: WTRCONF'+
              {$IFDEF OS2}
              '2'+
              {$ENDIF}
              ' [command]');
     WriteLn;
     WriteLn (' ?                           Show this information.');
     WriteLn;
     WriteLn (' EXPORT_SQUISH [<filename>]  Exports to SQUISH.CFG in the current directory');
     WriteLn ('                              or to <filename> if you define one.');
     WriteLn;
     WriteLn (' EXPORT_AREAS [<filename>]   Exports to AREAS.BBS in the current directory');
     WriteLn ('                              or to <filename> if you define one.');
     WriteLn;
     WriteLn (' IGNORE_SYSTEMDIR            Ignore system directory in WTRCFG.TDB and load');
     WriteLn ('                              the databases from current directory instead.');
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

VAR Quit      : BOOLEAN;
    Param,
    Tmp       : STRING;
    LetterTel,
    ParamTel  : BYTE;
    Error     : BOOLEAN;
    Dir       : DirStr;
    Name      : NameStr;
    Ext       : ExtStr;
    P         : BYTE;
    Yb        : XYType;

LABEL Einde;

BEGIN
     WriteLn (DesktopProgramName+' v'+FullProgramVersion);
     WriteLn (CopyrightLine);
     WriteLn;

     {$IFNDEF OS2}
     {$IFOPT G+}
     { check for PC/AT or higher }
     IF (Test8086 = 0) THEN
     BEGIN
          WriteLn (DesktopProgramName+' requires a PC/AT (286) or higher to run');
          Halt (1);
     END;
     {$ENDIF}
     {$ENDIF}

     Param:=UpCaseString (ParamStr (1));
     IF (Param = '?') OR (Param = 'HELP') OR (Param = '-H') OR (Param = '-?') THEN
     BEGIN
          ShowHelp;
          Exit;
     END;

     SetupEmptyConfig;

     Error:=FALSE;
     IF (NOT ReadConfigFile) THEN
        Error:=TRUE
     ELSE BEGIN
          IF (Param = 'IGNORE_SYSTEMDIR') THEN
             Config.SystemDir:='';

          IF (NOT OpenDatabases) THEN
             Error:=TRUE;
     END;

     IF Error THEN
     BEGIN
          CloseDatabases;
          WriteLn;
          WriteLn (' Unable to open/create configuration files');
          WriteLn;
          Halt (1);
     END;

     IF (ParamCount > 0) THEN
     BEGIN
          IF (Param = 'EXPORT_SQUISH') THEN
          BEGIN
               IF (ParamStr(2) = '') THEN ExportSquishConfig ('SQUISH.CFG')
                                     ELSE ExportSquishConfig (ParamStr(2));
               GOTO Einde;
          END;

          IF (Param = 'EXPORT_AREAS') THEN
          BEGIN
               IF (ParamStr(2) = '') THEN ExportAreasBBS ('AREAS.BBS')
                                     ELSE ExportAreasBBS (ParamStr(2));
               GOTO Einde;
          END;

          IF (Param <> 'IGNORE_SYSTEMDIR') THEN
          BEGIN
               WriteLn ('Unknown commandline option "'+Param+'" found.');
               Exit;
          END;
     END;

     AssignHelpFile (Config.SystemDir+'WTRGATE.HLP');
     ListServerTabelInit;

     DesktopCopyright:='WSD';
     OpenDesktop (DesktopProgramName,FullProgramVersion);
     WriteKeysLine (' ^F1 Help  ^Esc Return ');

     IF (Config.SystemDir <> '') AND (Config.SystemDir+ConfigFilename <> FExpand (FoundConfigPath)) THEN
     BEGIN
          Yb:=Video.Rows-8;
          WindowPush (3,Yb,80,7);
          BoxDraw (Double,3,Yb,75,7);

          WriteXY (5,Yb,' Database files in use ');

          SetColor (cBoxData);
          WriteXY (5,Yb+1,FExpand (FoundConfigPath));
          WriteXY (5,Yb+2,FExpand (TdbGetFilename (AreaBaseTdbNr)));
          WriteXY (5,Yb+3,FExpand (TdbGetFilename (UserBaseTdbNr)));
          WriteXY (5,Yb+4,FExpand (TdbGetFilename (SubscriptBaseTdbNr)));
          WriteXY (5,Yb+5,FExpand (TdbGetFilename (ListServerTdbNr)));

          FSplit (FExpand (FoundConfigPath),Dir,Name,Ext);
          Tmp:='WARNING: System directory is '+Config.SystemDir+
               ', while WTRCFG.TDB was loaded from '+Dir+'. You might need IGNORE_SYSTEMDIR.';

          P:=71; { max lengte eerste regel }
          WHILE (Tmp[P] <> ' ') DO
                Dec (P);

          Error2Lines (Copy (Tmp,1,P-1),Copy (Tmp,P+1,255));

          WindowPop;
     END;

     {$IFDEF Alfa}  ShowCopyRight; {$ENDIF}
     {$IFDEF Beta}  ShowCopyRight; {$ENDIF}
     {$IFDEF Gamma} ShowCopyRight; {$ENDIF}

     MenuDefine (27,255,'Main Menu');
     MenuAddItem ('System configuration');
     MenuAddItem ('Area definitions');
     MenuAddItem ('User definitions');
     MenuAddItem ('Link definitions');
     MenuAddItem ('Mailing list definitions');
     MenuAddItem ('Group descriptions');
     MenuAddItem ('Import/export menu');
    {MenuAddItem ('Config Integrity Check');}
     MenuAddItem ('About WtrConf');
     MenuAddItem ('Exit program');
     MenuSetHelp (1);
     MenuShow;

     Quit:=FALSE;
     REPEAT
           CASE MenuSelect OF
                mOpt01 : EditSystemConfig;
                mOpt02 : AreaConfigs;
                mOpt03 : EditSystems (FALSE);
                mOpt04 : EditSystems (TRUE{links});
                mOpt05 : EditListServer;
                mOpt06 : EditGroupDescriptions;
                mOpt07 : ImportExportMenu;
               {mOpt08 : CheckConfig;}
                mOpt08 : TellAboutMessage;
                mOpt09 : Quit:=TRUE;

                kEsc   : BEGIN
                              MenuDefine (Video.Cols-20,Video.Rows-9,'Quit?');
                              MenuAddItem ('Yes');
                              MenuAddItem ('No');
                              MenuShow;

                              IF (MenuSelect = mOpt01) THEN
                                 Quit:=TRUE;

                              MenuErase;
                         END;
           END; { case }
     UNTIL Quit;

     MenuErase;

     CloseDesktop;

Einde:
     CloseDatabases;

     WriteLn ('Ending ',DesktopProgramName,' v',FullProgramVersion);
END.

