UNIT RamonX;

{ Rob: Since its a hell to convert the entire Ramon unit, I've taken }
{      out the function that WtrStat uses and put them here.         }

INTERFACE

TYPE ByteString    = STRING[3];
     WordString    = STRING[5];
     LongintString = STRING[11];
     RealString    = STRING[20];

FUNCTION Byte2String (Getal : BYTE) : ByteString;
FUNCTION Word2String (Getal : WORD) : WordString;
FUNCTION Longint2String (Getal : LONGINT) : LongintString;
FUNCTION Real2String (Getal : REAL; SumDigits,Decimals : BYTE) : RealString;
FUNCTION RepChar (Aantal : BYTE; Teken : CHAR) : STRING;
FUNCTION AddUpWithSpaces (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION AddUpWithPreSpaces (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION AddUpWithPre0s (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION DeleteBackSpaces (Tekst : STRING) : STRING;
FUNCTION DeleteFrontSpaces (Tekst : STRING) : STRING;
FUNCTION UpdateCRC32 (InitCRC : LONGINT; VAR InBuf; InLen : WORD) : LONGINT;


IMPLEMENTATION

{--------------------------------------------------------------------------}
{ Byte2String                                                              }
{                                                                          }
{ Zet de opgegeven BYTE om in een decimale representatie. Geen voorloop    }
{ spaties of nullen.                                                       }
{                                                                          }
FUNCTION Byte2String (Getal : BYTE) : ByteString;

VAR Temp : ByteString;

BEGIN
     Str (Getal,Temp);
     Byte2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Word2String                                                              }
{                                                                          }
{ Zet de opgegeven WORD in een decimale representatie. Geen voorloop       }
{ nullen of spaties.                                                       }
{                                                                          }
FUNCTION Word2String (Getal : WORD) : WordString;

VAR Temp : WordString;

BEGIN
     Str (Getal,Temp);
     Word2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Longint2String                                                           }
{                                                                          }
{ Zet de opgegeven LONGINT in een decimale representatie. Geen voorloop    }
{ nullen of spaties.                                                       }
{                                                                          }
FUNCTION Longint2String (Getal : LONGINT) : LongintString;

VAR Temp : LongintString;

BEGIN
     Str (Getal,Temp);
     Longint2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Real2String                                                              }
{                                                                          }
{ Deze routine zet een getal om in een real getal om in een string met een }
{ opgegeven aantal getallen voor en na de punt.                            }
{                                                                          }
FUNCTION Real2String (Getal : REAL; SumDigits,Decimals : BYTE) : RealString;

VAR Result : RealString;

BEGIN
     Str (Getal:SumDigits:Decimals,Result);
     Real2String:=Result;
END;


{--------------------------------------------------------------------------}
{ RepChar                                                                  }
{                                                                          }
{ Geeft een string terug met als inhoud het opgegeven Teken, net zo vaak   }
{ als opgegeven was in Aantal.                                             }
{                                                                          }
FUNCTION RepChar (Aantal : BYTE; Teken : CHAR) : STRING;

VAR Temp : STRING;

BEGIN
     FillChar (Temp[1],Aantal,Teken);
     Temp[0]:=Chr (Aantal);

     RepChar:=Temp;
END;


{--------------------------------------------------------------------------}
{ AddUpWithSpaces                                                          }
{                                                                          }
{ Vul de opgegeven tekst aan met spaties tot de lengte Len.                }
{                                                                          }
FUNCTION AddUpWithSpaces (Len : BYTE; Tekst : STRING) : STRING;
BEGIN
     IF (Length (Tekst) > Len) THEN
        AddUpWithSpaces:=Copy (Tekst,1,Len)
     ELSE
         AddUpWithSpaces:=Tekst+RepChar (Len-Length (Tekst),' ');
END;


{--------------------------------------------------------------------------}
{ AddUpWithPreSpaces                                                       }
{                                                                          }
{ Deze routine vult de opgegeven string aan tot de gewenste lengte door    }
{ voorloop spaties voor de tekst te zetten.                                }
{                                                                          }
FUNCTION AddUpWithPreSpaces (Len : BYTE; Tekst : STRING) : STRING;
BEGIN
     IF (Length (Tekst) < Len) THEN
        Tekst:=RepChar (Len-Length (Tekst),' ')+Tekst;

     AddUpWithPreSpaces:=Tekst;
END;


{--------------------------------------------------------------------------}
{ AddUpWithPre0s                                                           }
{                                                                          }
{ Deze routine vult de opgegeven string aan tot de gewenste lengte door    }
{ voorloop nullen voor de tekst te zetten.                                 }
{                                                                          }
FUNCTION AddUpWithPre0s (Len : BYTE; Tekst : STRING) : STRING;
BEGIN
     IF (Length (Tekst) < Len) THEN
        Tekst:=RepChar (Len-Length (Tekst),'0')+Tekst;

     AddUpWithPre0s:=Tekst;
END;


{--------------------------------------------------------------------------}
{ DeleteBackSpaces                                                         }
{                                                                          }
{ Deze routine haalt alle spaties aan het einde van de opgegeven tekst weg }
{ totdat de string leeg is of er een niet-spatie teken aan het eind staat. }
{                                                                          }
FUNCTION DeleteBackSpaces (Tekst : STRING) : STRING;

VAR P : BYTE;

BEGIN
     IF (Tekst <> '') THEN
     BEGIN
          ASM
             LEA SI,Tekst   { SS:SI wijst nu naar de opslag ruimte van Tekst }

             MOV CL,SS:[SI] { lengte byte ophalen }
             XOR CH,CH      { lengte zit nu in CX voor de loop }

             MOV AH,CL      { aantal tekens te behouden in AH }

             ADD SI,CX      { ga naar het einde van de string }

             STD            { set the direction flag to go in reverse direction }
      @Loop: SEGSS LODSB    { haal een teken vd string op }
             CMP AL,' '     { is het een spatie? }
             JNZ @Einde     { nee, einde van alle spaties bereikt }
             DEC AH         { 1 teken minder behouden straks }
             LOOP @Loop     { volgende teken bekijken }

     @Einde: MOV P,AH       { aantal tekens te behouden opslaan in P }
          END;

          DeleteBackSpaces:=Copy (Tekst,1,P);
          Exit;
     END;

     DeleteBackSpaces:=Tekst;
END;


{--------------------------------------------------------------------------}
{ DeleteFrontSpaces                                                        }
{                                                                          }
{ Deze routine haalt de spaties aan het begin van een string weg en geeft  }
{ de rest terug.                                                           }
{                                                                          }
FUNCTION DeleteFrontSpaces (Tekst : STRING) : STRING;

VAR P : BYTE;

BEGIN
     IF (Tekst <> '') THEN
     BEGIN
          ASM
             LEA SI,Tekst

             CLD
             SEGSS LODSB    { lengte byte ophalen }
             MOV CL,AL      { lengte naar CX voor LOOP }
             XOR CH,CH

             XOR AH,AH      { aantal spaties geteld: 0 }
       @More:
             SEGSS LODSB    { teken ophalen }
             CMP AL,' '     { is het een spatie? }
             JNZ @Einde     { nee, klaar met tellen }
             INC AH         { 1 spatie meer geteld }
             LOOP @More     { verder zoeken tot einde string }

     @Einde: MOV P,AH       { aantal gevonden spaties opslaan in P }
          END;

          IF (P <> 0) THEN
          BEGIN
               DeleteFrontSpaces:=Copy (Tekst,P+1,255);
               Exit;
          END;
     END;

     DeleteFrontSpaces:=Tekst;
END;


{ deze tabel kost 1Kb in het globale datasegment. Dat moet dan maar    }
{ totdat er een routine is die de tabel tijdens run-time kan genereren }
CONST CRC32Tab : ARRAY[0..255] OF LONGINT = (
{ tabel overgenomen uit crc_32.c van de snip1292.arj archive }
$00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f,
$e963a535, $9e6495a3, $0edb8832, $79dcb8a4, $e0d5e91e, $97d2d988,
$09b64c2b, $7eb17cbd, $e7b82d07, $90bf1d91, $1db71064, $6ab020f2,
$f3b97148, $84be41de, $1adad47d, $6ddde4eb, $f4d4b551, $83d385c7,
$136c9856, $646ba8c0, $fd62f97a, $8a65c9ec, $14015c4f, $63066cd9,
$fa0f3d63, $8d080df5, $3b6e20c8, $4c69105e, $d56041e4, $a2677172,
$3c03e4d1, $4b04d447, $d20d85fd, $a50ab56b, $35b5a8fa, $42b2986c,
$dbbbc9d6, $acbcf940, $32d86ce3, $45df5c75, $dcd60dcf, $abd13d59,
$26d930ac, $51de003a, $c8d75180, $bfd06116, $21b4f4b5, $56b3c423,
$cfba9599, $b8bda50f, $2802b89e, $5f058808, $c60cd9b2, $b10be924,
$2f6f7c87, $58684c11, $c1611dab, $b6662d3d, $76dc4190, $01db7106,
$98d220bc, $efd5102a, $71b18589, $06b6b51f, $9fbfe4a5, $e8b8d433,
$7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb, $086d3d2d,
$91646c97, $e6635c01, $6b6b51f4, $1c6c6162, $856530d8, $f262004e,
$6c0695ed, $1b01a57b, $8208f4c1, $f50fc457, $65b0d9c6, $12b7e950,
$8bbeb8ea, $fcb9887c, $62dd1ddf, $15da2d49, $8cd37cf3, $fbd44c65,
$4db26158, $3ab551ce, $a3bc0074, $d4bb30e2, $4adfa541, $3dd895d7,
$a4d1c46d, $d3d6f4fb, $4369e96a, $346ed9fc, $ad678846, $da60b8d0,
$44042d73, $33031de5, $aa0a4c5f, $dd0d7cc9, $5005713c, $270241aa,
$be0b1010, $c90c2086, $5768b525, $206f85b3, $b966d409, $ce61e49f,
$5edef90e, $29d9c998, $b0d09822, $c7d7a8b4, $59b33d17, $2eb40d81,
$b7bd5c3b, $c0ba6cad, $edb88320, $9abfb3b6, $03b6e20c, $74b1d29a,
$ead54739, $9dd277af, $04db2615, $73dc1683, $e3630b12, $94643b84,
$0d6d6a3e, $7a6a5aa8, $e40ecf0b, $9309ff9d, $0a00ae27, $7d079eb1,
$f00f9344, $8708a3d2, $1e01f268, $6906c2fe, $f762575d, $806567cb,
$196c3671, $6e6b06e7, $fed41b76, $89d32be0, $10da7a5a, $67dd4acc,
$f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5, $d6d6a3e8, $a1d1937e,
$38d8c2c4, $4fdff252, $d1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
$d80d2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55,
$316e8eef, $4669be79, $cb61b38c, $bc66831a, $256fd2a0, $5268e236,
$cc0c7795, $bb0b4703, $220216b9, $5505262f, $c5ba3bbe, $b2bd0b28,
$2bb45a92, $5cb36a04, $c2d7ffa7, $b5d0cf31, $2cd99e8b, $5bdeae1d,
$9b64c2b0, $ec63f226, $756aa39c, $026d930a, $9c0906a9, $eb0e363f,
$72076785, $05005713, $95bf4a82, $e2b87a14, $7bb12bae, $0cb61b38,
$92d28e9b, $e5d5be0d, $7cdcefb7, $0bdbdf21, $86d3d2d4, $f1d4e242,
$68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777,
$88085ae6, $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69,
$616bffd3, $166ccf45, $a00ae278, $d70dd2ee, $4e048354, $3903b3c2,
$a7672661, $d06016f7, $4969474d, $3e6e77db, $aed16a4a, $d9d65adc,
$40df0b66, $37d83bf0, $a9bcae53, $debb9ec5, $47b2cf7f, $30b5ffe9,
$bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605, $cdd70693,
$54de5729, $23d967bf, $b3667a2e, $c4614ab8, $5d681b02, $2a6f2b94,
$b40bbe37, $c30c8ea1, $5a05df1b, $2d02ef8d
);


{--------------------------------------------------------------------------}
{ UpdateCRC32                                                              }
{                                                                          }
{ Deze routine loopt het opgegeven InBuf door voor InLen tekens en past de }
{ opgegeven InitCRC aan de hand van het CRC32 polynoom aan.                }
{                                                                          }
FUNCTION UpdateCRC32 (InitCRC : LONGINT; VAR InBuf; InLen : WORD) : LONGINT; ASSEMBLER;
ASM
   PUSH DS

   { adres van het buffer ophalen naar DS:SI }
   LDS SI,InBuf

   { haal de initiele CRC waarde op in DX:AX }
   MOV AX,Word (InitCRC)
   MOV DX,Word (InitCRC+2)

   { tabel staat nu op DS:CRC32Tab, kan ook ergens anders heen  }
   { een pointer naar de tabel moet dan simpel hier neergezet   }
   { worden. Bij een dynamische tabel moet een routine gemaakt  }
   { worden die de tabel genereerd. Een pointer naar de tabel   }
   { wordt dan in een globale variabele opgeslagen. Met de      }
   { instructie LES DI,[Pointer] kan deze dan opgehaald worden. }
   POP ES
   PUSH ES
   MOV DI,OFFSET CRC32Tab

   { haal de lengte van het buffer op }
   MOV CX,InLen
   OR CX,CX       { length = 0? }
   JZ @Einde      { ja, dan niets te doen hier }

   CLD

@DoBufLp:
   XOR BH,BH   { BH = 0 }
   MOV BL,AL   { BL = AL = LSB van CRC32 }
   LODSB       { haal een teken uit de string op van DS:SI naar AL }
   XOR BL,AL   { XOR het teken met het LSB van de CRC32 }

   { schuif het hele CRC 8 bits door naar beneden }
   MOV AL,AH
   MOV AH,DL
   MOV DL,DH
   XOR DH,DH

   SHL BX,1       { *4, want iedere entry in de tabel is een LONGINT }
   SHL BX,1       { BX was 0..255 }

   XOR AX,ES:[BX+DI]
   XOR DX,ES:[BX+DI+2]

   LOOP @DoBufLp { meer tekens uit het buffer verwerken }

@Einde:
   POP DS

   { resultaat in DX:AX is het de teruggegeven LONGINT }
END;


END.
