{ OVERALL.INC: OverAll Routines }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{--------------------------------------------------------------------------}
{ WriteKeysLine                                                            }
{                                                                          }
{ Deze routine drukt op de onderste scherm regel de mogelijke toetsen af.  }
{ Een woord dat vooraf wordt gegaan door ^ is de omschrijving van de toets }
{ en wordt in de kleur KeyName gezet. De rest komt in KeyDescr.            }
{                                                                          }
PROCEDURE WriteKeysLine (Line : STRING);

VAR Lp : BYTE;

BEGIN
     RGotoXY (1,Video.Rows);
     SetColor (cKeyDescr); { voor geval geen spatie aan begin regel }

     FOR Lp:=1 TO Length (Line) DO
     BEGIN
          IF (Line[Lp] = '^') THEN
             SetColor (cKeyName)
          ELSE
              IF (Line[Lp] = '~') THEN
                 SetColor (cKeyDescr)
              ELSE
                  IF (Line[Lp] = '`') THEN
                     SetColor (cKeyBlink)
                  ELSE BEGIN
                       IF (Line[Lp] = ' ') THEN SetColor (cKeyDescr);

                       RWrite (Line[Lp]);
                  END;
     END; { for }

     SetColor (cKeyDescr); { RWI 960402: rest niet in fel (blink) in Win'95 }
     RWrite (RepChar (Video.Cols-RWhereX+1,' '));
END;


{--------------------------------------------------------------------------}
{ PushKeysLine                                                             }
{                                                                          }
{ Deze routine slaat de huidige Keys Line op de stack op door een          }
{ WindowPush in het betreffende gebied uit te voeren.                      }
{                                                                          }
PROCEDURE PushKeysLine;
BEGIN
     WindowPush (1,Video.Rows,Video.Cols,1);
END;


{--------------------------------------------------------------------------}
{ PopKeysLine                                                              }
{                                                                          }
{ Deze routine haalt de laatste opgeslagen Keys regel terug. Dit gebeurt   }
{ door een simpele WindowPop die net zo goed in het hoofdprogramma         }
{ opgenomen had kunnen worden. Maar er moet ook met de muis rekening       }
{ gehouden worden.                                                         }
{                                                                          }
PROCEDURE PopKeysLine;
BEGIN
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ Message                                                                  }
{                                                                          }
{ Deze routine drukt de opgegeven tekst in een window af in de cMessage    }
{ kleur. Er wordt niet op een toetsdruk gewacht.                           }
{                                                                          }
PROCEDURE Message (Tekst : STRING);

CONST LY = 5;

VAR XB,YB,LX : BYTE;

BEGIN
     LX:=Length (Tekst)+6;
     {IF (LX < 30) THEN LX:=30;}
     YB:=1+(Video.Rows-LY) DIV 2;
     XB:=1+(Video.Cols-LX) DIV 2;

     WindowPush (XB,YB,LX,LY);
     BoxDrawC (cMessage,Single,XB,YB,LX,LY);
     WriteXY (XB+3,YB+2,Tekst);

     MessageXB:=XB+3;
     MessageYB:=YB+2;
END;


{--------------------------------------------------------------------------}
{ Error                                                                    }
{                                                                          }
{ Deze routine drukt de foutmelding in het midden van het midden van het   }
{ scherm af met daaronder een opmerking om op Escape te drukken om door te }
{ gaan.                                                                    }
{                                                                          }
PROCEDURE Error (Tekst : STRING);

CONST LY = 8;

VAR XB,YB,LX : BYTE;
    OldColor : ColorSet;

BEGIN
     OldColor:=GetColor;

     LX:=Length (Tekst)+6;
     IF (LX < 30) THEN LX:=30;
     YB:=1+(Video.Rows-LY) DIV 2;
     XB:=1+(Video.Cols-LX) DIV 2;

     WindowPush (XB,YB,LX,LY);
     BoxDrawC (cError,Single,XB,YB,LX,LY);
     SetColor (cError);
     WriteXY (XB+3,YB+2,Tekst);
     WriteXY (XB+3,YB+5,'Press Escape to continue');

     PushKeysLine;
     WriteKeysLine (' ^Esc Continue');
     REPEAT
     UNTIL (ReadKey = kEsc);
     PopKeysLine;
     WindowPop;

     SetColor (OldColor);
END;


{--------------------------------------------------------------------------}
{ Error2Lines                                                              }
{                                                                          }
{ Deze routine drukt de foutmelding van twee regels af in het midden van   }
{ het scherm af met daaronder een opmerking om op Escape te drukken om     }
{ door te gaan.                                                            }
{                                                                          }
PROCEDURE Error2Lines (Tekst1,Tekst2 : STRING);

CONST LY = 8;

VAR XB,YB,LX : BYTE;
    OldColor : ColorSet;

BEGIN
     OldColor:=GetColor;

     IF (Length (Tekst1) > Length (Tekst2)) THEN
        LX:=Length (Tekst1)+6
     ELSE
         LX:=Length (Tekst2)+6;

     IF (LX < 30) THEN LX:=30;
     YB:=(Video.Rows-LY) DIV 2;
     XB:=1+(Video.Cols-LX) DIV 2;

     WindowPush (XB,YB,LX,LY);
     BoxDrawC (cError,Single,XB,YB,LX,LY);
     SetColor (cError);
     WriteXY (XB+3,YB+2,Tekst1);
     WriteXY (XB+3,YB+3,Tekst2);
     WriteXY (XB+3,YB+5,'Press Escape to continue');

     PushKeysLine;
     WriteKeysLine (' ^Esc Continue');
     REPEAT
     UNTIL (ReadKey = kEsc);
     PopKeysLine;
     WindowPop;

     SetColor (OldColor);
END;


