{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT FlexCfg;

{$i platform.inc}

{ Flexible Configuration Unit }

{ This unit administrates several types and storage of their records }
{ in one flex-tdb file, via the FlexTdb unit, instead of in a static }
{ record size database via the normal Tdb unit.                      }

INTERFACE

USES Database;

{ MapRecord contains a search string, where to expect that search string }
{ and how to act when that string has been found.                        }

CONST mltNetmail  = $01;
      mltEchomail = $02;
      mltEmail    = $04;
      mltNews     = $08;

      mltRFC      = mltEmail OR mltNews;
      mltFTN      = mltNetmail OR mltEchomail;
      mltAll      = mltRFC OR mltFTN;

      mioInbound  = $01;
      mioOutbound = $02;
      mioBoth     = mioInbound OR mioOutbound;

(*
TYPE MapLimitMsgType = (mltNot,        { disabled }
                        mltAllMsgs,    { all messages }
                        mltAllPrivate, { private messages only (net/email) }
                        mltAllPublic,  { public messages only (echo/news)  }
                        mltNetmail,    { FTN netmail only }
                        mltEchomail,   { FTN echomail only }
                        mltEmail,      { RFC email only }
                        mltNews);      { RFC news only }
*)

TYPE MapSearchWhereType = (mwtAll,      { header, body, footer }
                           mwtBody,     { in the body of the message }
                           mwtHeader,   { in the header of the message }
                           mwtFrom,     { sender addresses (from) only }
                           mwtTo,       { recipient addresses (to) only }
                           mwtSubject); { subject field only }

TYPE MapActionType = (matMove,          { 0 move to an area }
                      matCopy,          { 1 copy to an area }
                      matDelete,        { 2 delete, the hard way }
                      matForward,       { 3 forward to a user }
                      matCC,            { 4 send copy to a user }
                      matBounce,        { 5 bounce to sender }
                      matBounceAddr,    { 6 bounce to other address }
                      matToFile,        { 7 redirect to file }
                      matSave,          { 8 save to directory on disk }
                      matNone);         { 9 no action }

TYPE MapAddressType = (madFTN,
                       madRFC,
                       madRemoteGW);

TYPE FilterRecord = RECORD
                          Limit    : BYTE; { bitwise combination of mlt* }
                          InOut    : BYTE; { bitwise combi of mio* }
                          Where    : MapSearchWhereType;
                          Search   : STRING[80];
                          Action   : MapActionType;
                          Note     : BOOLEAN; { move/copy/fwd note at top }

                          { cannot use variant record because action can     }
                          { be changed and don't want crap to show in fields }

                          { Forward, CC, BounceAddr }
                          { combination of the three can be used for remote gw }
                          AddrType : MapAddressType;
                          ToName   : STRING[MaxLenUserName];
                          ToAKA    : FidoAddrType;
                          ToEmail  : STRING[MaxLenDomain];

                          { instead, the editor show fill in the required   }
                          { fields and gray the rest. At the end, depending }
                          { on the type, this argument is filled with the   }
                          { contents of one of the fields.                  }

                          { Save: Path }
                          { Bounce/BounceAddr: Reason }
                          { Move/Copy : Area }
                          Argument : STRING[80];
                    END;

CONST MaxLenComprPrgDescr = 79;

TYPE FtnArchivers = RECORD
                          {ARC,ARJ,LZH,PAK,ZIP,ZOO,RAR,OP1}
                          Archive   : ARRAY[fctARC..fctOP1] OF STRING[MaxLenComprPrgDescr];

                          { OP1 niet gebruikt in Unarchive }
                          Unarchive : ARRAY[fctARC..fctGUS] OF STRING[MaxLenComprPrgDescr];
                    END;

TYPE AreaListType = (lstAREASBBS,lstNAMES);

TYPE AreafixForwardRecord = RECORD
                                  UplinkAddress : FidoAddrType; { System to send requests to }
                                  Unconditional : BOOLEAN;      { Always forward messages?   }
                                  AreaListPath  : STRING[50];   { Path to file with names    }
                                  AreaList      : AreaListType; { AREAS.BBS or normal list?  }
                                  AreaManager   : STRING[10];   { Name of 'Areafix'          }
                                  Password      : STRING[10];   { Password to use for uplink }
                                  Group         : BYTE;         { Group to work              }
                                  AddPlus       : BOOLEAN;      { Add a '+' before the name? }
                                  ExportAKA     : BYTE;         { 1..MaxSystemAkas }
                            END;

TYPE NewsfixForwardRecord  = RECORD
                                   UUCPName     : STRING[MaxLenUUCPName]; { UUCP Name of the forward system }
                                   AreaListPath : STRING[49];             { to search in this file for area names }
                                   Group        : BYTE; { RWI 960211 }
                             END;

CONST MaxLenMailingListName        = 30;
      MaxLenMailingListDescription = 40;

TYPE ListAddrType = (laLower,laHigher);

TYPE MailingListRecord = RECORD
                               ListID          : WORD; { unique for each list }

                               { definition }
                               Name            : STRING[MaxLenMailingListName];
                               Description     : STRING[MaxLenMailingListDescription];
                               WelcomeFile     : FilePathStr;
                               FooterFile      : FilePathStr;

                               { options }
                               PrivateList     : BOOLEAN;
                               OnlyKnown       : BOOLEAN;
                               Passive         : BOOLEAN;
                               NameInSubject   : BOOLEAN;

                               { FTN configuration }
                               AKA             : BYTE; { 0=Auto??, 1..MaxAKAs }

                               { RFC configuration }
                               MLAddress       : ListAddrType;
                               HomeDomain      : BYTE; { 1..MaxSystemDomains }

                               { access control }
                               DefaultAccess   : ListAccessType;
                               ConfirmInterval : BYTE; { days }
{##not supported!}             AdminPassword   : STRING[8];

                               { link to area }
                               AreaName        : STRING[MaxLenAreaName];
                               AreaToList      : BOOLEAN;
                               ListToArea      : BOOLEAN;

                               { Mailing list counter (PRE35) }
                               UseMessageCounter:BOOLEAN;
                               MessageCounter  : LONGINT;
                         END;

{ record types found in the flex database }

CONST FLEX_DOS_ARCHIVERS     = $0001;
      FLEX_OS2_ARCHIVERS     = $0002;
      FLEX_AFIX_FORWARD_OLD1 = $0003;   { without ExportAKA }
      FLEX_NFIX_FORWARD      = $0004;
      FLEX_AFIX_FORWARD      = $0005;

      FLEX_FILTER_OLD1       = $0100;   { without InOut }
      FLEX_FILTER            = $0101;

      FLEX_MAILINGLIST_OLD1  = $0200;
      FLEX_MAILINGLIST       = $0201;

      {
      FLEX_TUNNEL_FROM       = $0000;
      }

FUNCTION  Flex_Init : BOOLEAN;
PROCEDURE Flex_Done;

FUNCTION  Flex_DosArchivers_Read (VAR Archivers : FTNArchivers) : LONGINT;
PROCEDURE Flex_DosArchivers_Write (VAR Archivers : FTNArchivers; Pos : LONGINT);

FUNCTION  Flex_OS2Archivers_Read (VAR Archivers : FTNArchivers) : LONGINT;
PROCEDURE Flex_OS2Archivers_Write (VAR Archivers : FTNArchivers; Pos : LONGINT);

PROCEDURE Flex_AreaFixFwd_New (VAR Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
FUNCTION  Flex_AreaFixFwd_ReadFirst (VAR FwdRec : AreafixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
FUNCTION  Flex_AreaFixFwd_ReadNext (VAR FwdRec : AreafixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
PROCEDURE Flex_AreaFixFwd_Read (Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
PROCEDURE Flex_AreaFixFwd_Write (Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
PROCEDURE Flex_AreaFixFwd_Erase (Pos : LONGINT);

PROCEDURE Flex_NewNewsFixFwd (VAR Pos : LONGINT; VAR FwdRec : NewsfixForwardRecord);
FUNCTION  Flex_ReadNewsFixFwd_First (VAR FwdRec : NewsfixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
FUNCTION  Flex_ReadNewsFixFwd_Next (VAR FwdRec : NewsfixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
PROCEDURE Flex_ReadNewsFixFwd (Pos : LONGINT; VAR FwdRec : NewsfixForwardRecord);
PROCEDURE Flex_WriteNewsFixFwd (Pos : LONGINT; VAR FwdRec : NewsfixForwardRecord);
PROCEDURE Flex_EraseNewsFixFwd (Pos : LONGINT);

PROCEDURE Flex_Filter_New (VAR Pos : LONGINT; VAR Filter : FilterRecord);
FUNCTION  Flex_Filter_ReadFirst (VAR Filter : FilterRecord; VAR Pos : LONGINT) : BOOLEAN;
FUNCTION  Flex_Filter_ReadNext (VAR Filter : FilterRecord; VAR Pos : LONGINT) : BOOLEAN;
PROCEDURE Flex_Filter_Read (Pos : LONGINT; VAR Filter : FilterRecord);
PROCEDURE Flex_Filter_Write (Pos : LONGINT; VAR Filter : FilterRecord);
PROCEDURE Flex_Filter_Erase (Pos : LONGINT);

PROCEDURE Flex_MailingList_New (VAR Pos : LONGINT; VAR ListRec : MailingListRecord);
FUNCTION  Flex_MailingList_ReadFirst (VAR ListRec : MailingListRecord; VAR Pos : LONGINT) : BOOLEAN;
FUNCTION  Flex_MailingList_ReadNext (VAR ListRec : MailingListRecord; VAR Pos : LONGINT) : BOOLEAN;
PROCEDURE Flex_MailingList_Read (Pos : LONGINT; VAR ListRec : MailingListRecord);
PROCEDURE Flex_MailingList_Write (Pos : LONGINT; VAR ListRec : MailingListRecord);
PROCEDURE Flex_MailingList_Erase (Pos : LONGINT);


IMPLEMENTATION

USES FlexTdb;

{--------------------------------------------------------------------------}
{ Flex_Init                                                                }
{                                                                          }
{ This routine initializes the flex data structures by opening the flex    }
{ database via the FlexTdb unit and caching whatever required for the      }
{ program under compilation.                                               }
{ Returns FALSE on error, TRUE on success.                                 }
{                                                                          }
FUNCTION Flex_Init : BOOLEAN;
BEGIN
     Flex_Init:=FlexTdb_Open;
END;


{--------------------------------------------------------------------------}
{ Flex_Done                                                                }
{                                                                          }
{ This routine releases any memory in use by this unit and closes the flex }
{ database.                                                                }
{                                                                          }
PROCEDURE Flex_Done;
BEGIN
     FlexTdb_Close;
END;


{==========================================================================}
{#                      DOS ARCHIVERS                                      }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_DosArchivers_Read                                                   }
{                                                                          }
FUNCTION Flex_DosArchivers_Read (VAR Archivers : FTNArchivers) : LONGINT;

VAR ReadPos : LONGINT;

BEGIN
     IF (NOT FlexTdb_ReadFirst (FLEX_DOS_ARCHIVERS,Archivers,SizeOf (FtnArchivers),ReadPos)) THEN
     BEGIN
          ReadPos:=-1;

          { init with defaults }
          FillChar (Archivers,SizeOf (FtnArchivers),0);

          Archivers.Archive[fctARC]:='pkpak -oct a';
          Archivers.Archive[fctARJ]:='arj a -e';
          Archivers.Archive[fctLZH]:='lha a /m';
          Archivers.Archive[fctPAK]:='pka a';
          Archivers.Archive[fctZIP]:='zip -a';
          Archivers.Archive[fctZOO]:='zoo -add';
          Archivers.Archive[fctRAR]:='rar a';
          Archivers.Archive[fctOP1]:='';

          Archivers.Unarchive[fctARC]:='pkunpak /r';
          Archivers.Unarchive[fctARJ]:='arj e -n';
          Archivers.Unarchive[fctLZH]:='lha e';
          Archivers.Unarchive[fctPAK]:='pak e /wn';
          Archivers.Unarchive[fctZIP]:='pkunzip -o';
          Archivers.Unarchive[fctZOO]:='zoo -extract';
          Archivers.Unarchive[fctRAR]:='rar e';
          Archivers.Unarchive[fctOP1]:=''; { unused }
          Archivers.Unarchive[fctGUS]:='';
     END;

     Flex_DosArchivers_Read:=ReadPos;
END;


{--------------------------------------------------------------------------}
{ Flex_DosArchivers_Write                                                  }
{                                                                          }
PROCEDURE Flex_DosArchivers_Write (VAR Archivers : FTNArchivers; Pos : LONGINT);
BEGIN
     FlexTdb_Write (FLEX_DOS_ARCHIVERS,SizeOf (FtnArchivers),Pos,Archivers);
END;


{==========================================================================}
{#                      OS2 ARCHIVERS                                      }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_OS2Archivers_Read                                                   }
{                                                                          }
FUNCTION Flex_OS2Archivers_Read (VAR Archivers : FTNArchivers) : LONGINT;

VAR ReadPos : LONGINT;

BEGIN
     IF (NOT FlexTdb_ReadFirst (FLEX_OS2_ARCHIVERS,Archivers,SizeOf (FtnArchivers),ReadPos)) THEN
     BEGIN
          ReadPos:=-1;

          { init with defaults }
          FillChar (Archivers,SizeOf (FtnArchivers),0);

          Archivers.Archive[fctARC]:='pkpak -oct a';
          Archivers.Archive[fctARJ]:='arj a -e';
          Archivers.Archive[fctLZH]:='lha a /m';
          Archivers.Archive[fctPAK]:='pka a';
          Archivers.Archive[fctZIP]:='zip -a';
          Archivers.Archive[fctZOO]:='zoo -add';
          Archivers.Archive[fctRAR]:='rar a';
          Archivers.Archive[fctOP1]:='';

          Archivers.Unarchive[fctARC]:='pkunpak /r';
          Archivers.Unarchive[fctARJ]:='arj e -n';
          Archivers.Unarchive[fctLZH]:='lha e';
          Archivers.Unarchive[fctPAK]:='pak e /wn';
          Archivers.Unarchive[fctZIP]:='pkunzip -o';
          Archivers.Unarchive[fctZOO]:='zoo -extract';
          Archivers.Unarchive[fctRAR]:='rar e';
          Archivers.Unarchive[fctOP1]:=''; { unused }
          Archivers.Unarchive[fctGUS]:='';
     END;

     Flex_OS2Archivers_Read:=ReadPos;
END;


{--------------------------------------------------------------------------}
{ Flex_OS2Archivers_Write                                                  }
{                                                                          }
PROCEDURE Flex_OS2Archivers_Write (VAR Archivers : FTNArchivers; Pos : LONGINT);
BEGIN
     FlexTdb_Write (FLEX_OS2_ARCHIVERS,SizeOf (FtnArchivers),Pos,Archivers);
END;


{==========================================================================}
{#                      AREAFIX FORWARDING                                 }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_New                                                      }
{                                                                          }
PROCEDURE Flex_AreaFixFwd_New (VAR Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
BEGIN
     WITH FwdRec DO
     BEGIN
          UplinkAddress.Zone:=0;
          UplinkAddress.Net:=0;
          UplinkAddress.Node:=0;
          UplinkAddress.Point:=0;
          UplinkAddress.Domain:='';
          Unconditional:=FALSE;
          AreaListPath:='';
          AreaList:=lstNAMES;
          AreaManager:='Areafix';
          Password:='';
          Group:=1; { = A1 }
          AddPlus:=FALSE;
          ExportAKA:=1;
     END; { with }

     Pos:=NILPos;
     FlexTdb_Write (FLEX_AFIX_FORWARD,SizeOf (AreafixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_ReadFirst                                                }
{                                                                          }
FUNCTION Flex_AreaFixFwd_ReadFirst (VAR FwdRec : AreafixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_AreaFixFwd_ReadFirst:=FlexTdb_ReadFirst (FLEX_AFIX_FORWARD,FwdRec,SizeOf (AreafixForwardRecord),Pos);
END;


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_ReadNext                                                 }
{                                                                          }
FUNCTION Flex_AreaFixFwd_ReadNext (VAR FwdRec : AreafixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_AreaFixFwd_ReadNext:=FlexTdb_ReadNext (Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_Read                                                     }
{                                                                          }
PROCEDURE Flex_AreaFixFwd_Read (Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
BEGIN
     FlexTdb_Read (SizeOf (AreafixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_Write                                                    }
{                                                                          }
PROCEDURE Flex_AreaFixFwd_Write (Pos : LONGINT; VAR FwdRec : AreafixForwardRecord);
BEGIN
     FlexTdb_Write (FLEX_AFIX_FORWARD,SizeOf (AreafixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_AreaFixFwd_Erase                                                    }
{                                                                          }
PROCEDURE Flex_AreaFixFwd_Erase (Pos : LONGINT);
BEGIN
     FlexTdb_Erase (Pos);
END;


{==========================================================================}
{#                      NEWSFIX FORWARDING                                 }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_NewNewFixFwd                                                        }
{                                                                          }
PROCEDURE Flex_NewNewsFixFwd (VAR Pos : LONGINT; VAR FwdRec : NewsfixForwardRecord);
BEGIN
     FwdRec.UUCPName:='';
     FwdRec.AreaListPath:='';
     FwdRec.Group:=1; { =A1 }

     Pos:=NILPos;
     FlexTdb_Write (FLEX_NFIX_FORWARD,SizeOf (NewsfixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_ReadNewsFixFwd_First                                                }
{                                                                          }
FUNCTION Flex_ReadNewsFixFwd_First (VAR FwdRec : NewsfixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_ReadNewsFixFwd_First:=FlexTdb_ReadFirst (FLEX_NFIX_FORWARD,FwdRec,SizeOf (NewsfixForwardRecord),Pos);
END;


{--------------------------------------------------------------------------}
{ Flex_ReadNewsFixFwd_Next                                                 }
{                                                                          }
FUNCTION Flex_ReadNewsFixFwd_Next (VAR FwdRec : NewsfixForwardRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_ReadNewsFixFwd_Next:=FlexTdb_ReadNext (Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_ReadNewsFixFwd                                                      }
{                                                                          }
PROCEDURE Flex_ReadNewsFixFwd (Pos : LONGINT; VAR FwdRec : NewsfixForwardRecord);
BEGIN
     FlexTdb_Read (SizeOf (NewsfixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_WriteNewsFixFwd                                                     }
{                                                                          }
PROCEDURE Flex_WriteNewsFixFwd (POS : LONGINT; VAR FwdRec : NewsfixForwardRecord);
BEGIN
     FlexTdb_Write (FLEX_NFIX_FORWARD,SizeOf (NewsfixForwardRecord),Pos,FwdRec);
END;


{--------------------------------------------------------------------------}
{ Flex_EraseNewsFixFwd                                                     }
{                                                                          }
PROCEDURE Flex_EraseNewsFixFwd (Pos : LONGINT);
BEGIN
     FlexTdb_Erase (Pos);
END;


{==========================================================================}
{#                      MAPPERS                                            }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_Filter_New                                                          }
{                                                                          }
PROCEDURE Flex_Filter_New (VAR Pos : LONGINT; VAR Filter : FilterRecord);
BEGIN
     FillChar (Filter,SizeOf (Filter),0);
     Filter.InOut:=3;   { both }
     Filter.Note:=TRUE;

     Pos:=NILPos;
     FlexTdb_Write (FLEX_FILTER,SizeOf (FilterRecord),Pos,Filter);
END;


{--------------------------------------------------------------------------}
{ Flex_Filter_ReadFirst                                                    }
{                                                                          }
FUNCTION Flex_Filter_ReadFirst (VAR Filter : FilterRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_Filter_ReadFirst:=FlexTdb_ReadFirst (FLEX_FILTER,Filter,SizeOf (FilterRecord),Pos);
END;


{--------------------------------------------------------------------------}
{ Flex_Filter_ReadNext                                                     }
{                                                                          }
FUNCTION Flex_Filter_ReadNext (VAR Filter : FilterRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_Filter_ReadNext:=FlexTdb_ReadNext (Pos,Filter);
END;


{--------------------------------------------------------------------------}
{ Flex_Filter_Read                                                         }
{                                                                          }
PROCEDURE Flex_Filter_Read (Pos : LONGINT; VAR Filter : FilterRecord);
BEGIN
     FlexTdb_Read (SizeOf (FilterRecord),Pos,Filter);
END;


{--------------------------------------------------------------------------}
{ Flex_Filter_Write                                                        }
{                                                                          }
PROCEDURE Flex_Filter_Write (Pos : LONGINT; VAR Filter : FilterRecord);
BEGIN
     FlexTdb_Write (FLEX_FILTER,SizeOf (FilterRecord),Pos,Filter);
END;


{--------------------------------------------------------------------------}
{ Flex_Filter_Erase                                                        }
{                                                                          }
PROCEDURE Flex_Filter_Erase (Pos : LONGINT);
BEGIN
     FlexTdb_Erase (Pos);
END;


{==========================================================================}
{#                      MAILING LISTS                                      }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Flex_MailingList_ReadFirst                                               }
{                                                                          }
FUNCTION Flex_MailingList_ReadFirst (VAR ListRec : MailingListRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_MailingList_ReadFirst:=FlexTdb_ReadFirst (FLEX_MAILINGLIST,ListRec,SizeOf (MailingListRecord),Pos);
END;


{--------------------------------------------------------------------------}
{ Flex_MailingList_ReadNext                                                }
{                                                                          }
FUNCTION Flex_MailingList_ReadNext (VAR ListRec : MailingListRecord; VAR Pos : LONGINT) : BOOLEAN;
BEGIN
     Flex_MailingList_ReadNext:=FlexTdb_ReadNext (Pos,ListRec);
END;


{--------------------------------------------------------------------------}
{ CreateNewMailingListID                                                   }
{                                                                          }
{ This routine generates a random number, then searches all mailing list   }
{ definitions and if this ListID is found a new random number will be      }
{ taken, etc. etc. until a new, unique, number is found. This number is    }
{ then returned.                                                           }
{                                                                          }
FUNCTION CreateNewMailingListID : WORD;

VAR ListRec : MailingListRecord;
    NewID   : WORD;
    Found   : BOOLEAN;
    Pos     : LONGINT;

BEGIN
     REPEAT
           NewID:=Random (65535);
           Found:=FALSE;

           { check all mailing list definitions for this number }
           IF Flex_MailingList_ReadFirst (ListRec,Pos) THEN
              REPEAT
                    IF (ListRec.ListID = NewID) THEN
                       Found:=TRUE;
              UNTIL (NOT Flex_MailingList_ReadNext (ListRec,Pos));

     UNTIL (NOT Found);

     CreateNewMailingListID:=NewID;
END;


{--------------------------------------------------------------------------}
{ Flex_MailingList_New                                                     }
{                                                                          }
PROCEDURE Flex_MailingList_New (VAR Pos : LONGINT; VAR ListRec : MailingListRecord);
BEGIN
     FillChar (ListRec,SizeOf (MailingListRecord),0);

     WITH ListRec DO
     BEGIN
          ListID:=CreateNewMailingListID;
          Aka:=1;
          MLAddress:=laHigher;
          HomeDomain:=1;
          NameInSubject:=TRUE;
          DefaultAccess:=laReadWrite;
     END; { with }

     Pos:=NILPos; { create at end of file }
     FlexTdb_Write (FLEX_MAILINGLIST,SizeOf (MailingListRecord),Pos,ListRec);
END;


{--------------------------------------------------------------------------}
{ Flex_MailingList_Read                                                    }
{                                                                          }
PROCEDURE Flex_MailingList_Read (Pos : LONGINT; VAR ListRec : MailingListRecord);
BEGIN
     FlexTdb_Read (SizeOf (MailingListRecord),Pos,ListRec);
END;


{--------------------------------------------------------------------------}
{ Flex_MailingList_Write                                                   }
{                                                                          }
PROCEDURE Flex_MailingList_Write (Pos : LONGINT; VAR ListRec : MailingListRecord);
BEGIN
     FlexTdb_Write (FLEX_MAILINGLIST,SizeOf (MailingListRecord),Pos,ListRec);
END;


{--------------------------------------------------------------------------}
{ Flex_MailingList_Erase                                                   }
{                                                                          }
PROCEDURE Flex_MailingList_Erase (Pos : LONGINT);
BEGIN
     FlexTdb_Erase (Pos);
END;


END.

