UNIT GrpEdit;

{ all code related to editing Group Definitions }

{ RAWI 990828 - broken out of wtrconf.pas }

INTERFACE

{$i platform.inc}

PROCEDURE EditGroupDescriptions;


IMPLEMENTATION

USES Ramon,
     Database,
     Cfg,
     Fido,
     Globals;

{$I WTRHLP.INC}

VAR OriginAkaDesc : STRING[MaxLenFidoAddrString];
    GroupData     : GroupDescRecord;

{--------------------------------------------------------------------------}
{ EditGroupDescOriginAka                                                   }
{                                                                          }
{ Met deze routine kan een andere origin aka voor deze group               }
{ uitgekozen worden.                                                       }
{                                                                          }
PROCEDURE EditGroupDescOriginAka; FAR;

VAR Keuze : WORD;
    Line  : STRING[50];
    Lp    : 1..MaxAkas;

BEGIN
     ListDefine (39,10,35,14,Default,'Origin AKAs',htr_GrpEdit_Default_AKA_Picklist);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR Lp:=1 TO MaxAkas DO
     BEGIN
          Line:=Fido2Str (Config.NodeNrs[Lp]);
          IF (Line <> '0') THEN
             ListAddItem (Line,Lp,Convert);
     END;

     ListSetCursorOnItem (GroupData.OriginAka);

     IF (ListItemCount = 0) THEN
        ListAddItem (Line,1,Bottom);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        WITH GroupData DO
        BEGIN
             OriginAka:=Keuze;
             OriginAkaDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[OriginAka]));
        END;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditSingleGroup                                                          }
{                                                                          }
PROCEDURE EditSingleGroup (GroupNr : GroupDescBaseRecordNrType);

CONST Yb = 6;
      Xl = MaxLenFidoAddrString+23;
      Xb = 40-(Xl DIV 2);
      Yl = 6;

VAR Quit : BOOLEAN;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;
     ReadGroupDescRecord (GroupNr,GroupData);

     WITH GroupData DO
     BEGIN
          GroupDesc:=AddUpWithSpaces (MaxLenGroupDesc,GroupDesc);
          OriginAkaDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[OriginAka]));
     END;

     WriteXY (Xb+2,Yb+1,'Group');
     WriteXY (Xb+21,Yb+1,BuildSingleGroupDesc (GroupNr));

     WriteXY (Xb+2,Yb+2,'Description ');
     FieldAutoDefineLongOne (Xb+21,Yb+2,48,@GroupData.GroupDesc,RepChar (MaxLenGroupDesc,'$'));
     FieldSetHelp (0,htr_GrpEdit_Description);

     WriteXY (Xb+2,Yb+3,'Default Origin Aka');
     FieldAutoDefineList (Xb+21,Yb+3,@OriginAkaDesc,EditGroupDescOriginAka);
     FieldSetHelp (0,htr_GrpEdit_DefaultOriginAKA);

     WriteXY (Xb+2,Yb+4,'Read-only group');
     FieldAutoDefineToggles (Xb+21,Yb+4,GroupData.ReadOnly,'no|yes',0);
     FieldSetHelp (0,htr_GrpEdit_ReadOnly);

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key = kEsc) THEN
           BEGIN
                WriteGroupDescRecord (GroupNr,GroupData);
                Quit:=TRUE;
           END;
     UNTIL Quit;

     WindowPop; { edit window }
END;


{--------------------------------------------------------------------------}
{ MoveAllUsersGroupAccess                                                  }
{                                                                          }
PROCEDURE MoveAllUsersGroupAccess (OldGroupNr,NewGroupNr : GroupDescBaseRecordNrType);

VAR UserLp  : UserBaseRecordNrType;
    UserRec : UserBaseRecord;

BEGIN
     Message ('Moving user access from group '+
              BuildSingleGroupDesc (OldGroupNr)+' to group '+BuildSingleGroupDesc (NewGroupNr));

     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserRec);

          { if part of old group }
          IF TestIfInGroup (UserRec.Groups,OldGroupNr) THEN
          BEGIN
               { remove old group }
               DeleteGroupFromGroupList (UserRec.Groups,OldGroupNr);

               { add new group }
               AddGroupToGroupList (UserRec.Groups,NewGroupNr);

               { write back to disk }
               WriteUserBaseRecord (UserLp,UserRec);
          END;
     END; { for }

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ MoveAllAreasGroupAccess                                                  }
{                                                                          }
PROCEDURE MoveAllAreasGroupAccess (OldGroupNr,NewGroupNr : GroupDescBaseRecordNrType);

VAR AreaLp  : AreaBaseRecordNrType;
    AreaRec : AreaBaseRecord;

BEGIN
     Message ('Moving area access from group '+
              BuildSingleGroupDesc (OldGroupNr)+' to group '+BuildSingleGroupDesc (NewGroupNr));

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaRec);

          { if part of old group }
          IF TestIfInGroup (AreaRec.IsInGroups,OldGroupNr) THEN
          BEGIN
               { remove old group }
               DeleteGroupFromGroupList (AreaRec.IsInGroups,OldGroupNr);

               { add new group }
               AddGroupToGroupList (AreaRec.IsInGroups,NewGroupNr);

               { write back to disk }
               WriteAreaBaseRecord (AreaLp,AreaRec);
          END;
     END; { for }

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ MoveSingleGroup                                                          }
{                                                                          }
{ Met deze routine kan een groep naar een nieuwe locatie verhuisd worden.  }
{ Alle verwijzingen worden ook veranderd.                                  }
{                                                                          }
FUNCTION MoveSingleGroup (GroupNr : GroupDescBaseRecordNrType) : GroupDescBaseRecordNrType;

VAR Lp         : 1..MaxGroups;
    NewGroupNr : GroupDescBaseRecordNrType;
    MoveUsers,
    MoveAreas  : BOOLEAN;

BEGIN
     MoveSingleGroup:=GroupNr; { no move }

     ListDefine (Video.Cols-3,3,Video.Cols-10,Video.Rows-4,TopRight,
                 'Select a new position for group '+BuildSingleGroupDesc (GroupNr),
                 htr_GrpEdit_MoveGroup_SelectNewGroup);

     FOR Lp:=1 TO MaxGroups DO
         IF (Lp <> GroupNr) THEN
         BEGIN
              ReadGroupDescRecord (Lp,GroupData);
              ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
         END;

     NewGroupNr:=ListSelect (NoTag,[]);

     IF (Key = kEsc) THEN
     BEGIN
          ListErase;
          Exit;
     END;

     MenuDefine (15,10,'The old group definition will be overwritten!');
     MenuSetHelp (htr_GrpEdit_MoveGroup_AreYouSure);
     MenuAddItem ('That''s OK, continue');
     MenuAddItem ('Abort!');
     MenuShow;
     MenuSelect;
     MenuErase;

     IF (Key IN [kEsc,mOpt02]) THEN
     BEGIN
          ListErase;
          Exit;
     END;

     MenuDefine (20,10,'Move access for users as well?');
     MenuSetHelp (htr_GrpEdit_MoveGroup_MoveUserAccessAsWell);
     MenuAddItem ('Yes, move user access');
     MenuAddItem ('Skip');
     MenuAddItem ('Abort entire move');
     MenuShow;
     MenuSelect;
     MenuErase;

     CASE Key OF
          mOpt01:
              MoveUsers:=TRUE;

          mOpt02:
              MoveUsers:=FALSE;

          kEsc,
          mOpt03 :
              BEGIN
                   ListErase;
                   Exit;
              END;

     END; { case }

     MenuDefine (21,10,'Move areas access as well?');
     MenuSetHelp (htr_GrpEdit_MoveGroup_MoveAreaAccessAsWell);
     MenuAddItem ('Yes, move areas');
     MenuAddItem ('Skip');
     MenuAddItem ('Abort entire move');
     MenuShow;
     MenuSelect;
     MenuErase;

     CASE Key OF
          mOpt01:
              MoveAreas:=TRUE;

          mOpt02:
              MoveAreas:=FALSE;

          kEsc,
          mOpt03 :
              BEGIN
                   ListErase;
                   Exit;
              END;

     END; { case }

     { move group }
     ReadGroupDescRecord (GroupNr,GroupData);
     WriteGroupDescRecord (NewGroupNr,GroupData);

     { move user access }
     IF MoveUsers THEN
        MoveAllUsersGroupAccess (GroupNr,NewGroupNr);

     { move area access }
     IF MoveAreas THEN
        MoveAllAreasGroupAccess (GroupNr,NewGroupNr);

     { erase old group description }
     WITH GroupData DO
     BEGIN
          GroupDesc:=AddUpWithSpaces (MaxLenGroupDesc,'<no description>');
          OriginAka:=1;
          ReadOnly:=FALSE;
     END; { with }

     WriteGroupDescRecord (GroupNr,GroupData);

     ListErase;
     MoveSingleGroup:=NewGroupNr;
END;


{--------------------------------------------------------------------------}
{ EditGroupDescriptions                                                    }
{                                                                          }
{ Met deze routine kunnen de omschrijvingen van de groupen worden inge-    }
{ voerd en aangepast.                                                      }
{                                                                          }
PROCEDURE EditGroupDescriptions;

VAR Lp    : GroupNrType;
    New,
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,Video.Cols-10{70},Video.Rows-4{21},Default,
                 'Group descriptions list',
                 htr_GrpEdit_GroupDescriptionsList);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END;

     Quit:=FALSE;
     REPEAT
           ListNoTagKeysLine:=' ^F1 Help  ^Esc Return  ^'#24#25' Select  ^Enter Edit  ^F2 Move';

           Keuze:=ListSelect (NoTag,[kF2]);

           ListNoTagKeysLine:=ORG_ListNoTagKeysLine;

           CASE Key OF
                kF2 :
                    BEGIN
                         { move group to new area }
                         New:=MoveSingleGroup (Keuze);

                         IF (New <> Keuze) THEN
                         BEGIN
                              ReadGroupDescRecord (Keuze,GroupData);
                              ListSetItemTekst (Keuze,BuildGroupDesc (Keuze,GroupData));

                              ReadGroupDescRecord (New,GroupData);
                              ListSetItemTekst (New,BuildGroupDesc (New,GroupData));

                              ListSetCursorOnItem (New);
                         END;
                    END;

                kRet :
                    BEGIN
                         EditSingleGroup (Keuze);
                         ListSetItemTekst (Keuze,BuildGroupDesc (Keuze,GroupData));
                    END;

                kEsc :
                    Quit:=TRUE;

           END; { case }

     UNTIL Quit;

     ListErase;
END;

END.

{ end of file grpedit.pas }
