UNIT Rescan;

{$i platform.inc}

{ all code related to %RESCAN goes here }

INTERFACE

USES Database;

TYPE RescanResultType = (rstExport,         { yes, export }
                         rstNoExport,       { no, do not export (to old) }
                         rstNoExport_Stop); { no, do not export, max # msgs reached }

{## add a response on the number of messages found and exported?}
PROCEDURE Rescan_Area (AreaRecNr : AreaBaseRecordNrType;
                       UserRecNr : UserBaseRecordNrType;
                       MaxAge    : WORD;  { in days }
                       MaxMsgs   : WORD); { max. msgs to export; 65535=unlimited}

FUNCTION  Rescan_ExportCheck (UnixTime : LONGINT) : RescanResultType;
PROCEDURE Rescan_DeliverMessage;


IMPLEMENTATION

USES Logs,
     Jam,
     Squish,
     FidoMsg,
     UnixTime,
     FidoPkt,
     Outbound,
     Msgs,
     Ramon,
     Deliver,
     Address,
     SeenBy;

VAR Rescan_MaxAge_UnixTime : LONGINT;
    Rescan_MaxMsgs         : WORD;
    Rescan_UserRecNr       : UserBaseRecordNrType;
    Rescan_AreaRecNr       : AreaBaseRecordNrType;
    Rescan_AreaRec         : AreaBaseRecord;

{--------------------------------------------------------------------------}
{ Rescan_Area                                                              }
{                                                                          }
{ This routine is called from the AreaFix code when a rescan of an area    }
{ has been requested. The record number of the area is given plus the      }
{ maximum number of messages to export (can be 0 for unlimited) and the    }
{ maximum age of the messages to export, in days.                          }
{ ## Can be 0 for all msgs??                                               }
{ ## have result type to indicate #msgs exported / error message in case   }
{    of pass-through area?                                                 }
{                                                                          }
PROCEDURE Rescan_Area (AreaRecNr : AreaBaseRecordNrType;
                       UserRecNr : UserBaseRecordNrType;
                       MaxAge    : WORD;
                       MaxMsgs   : WORD);

BEGIN
     Rescan_MaxMsgs:=MaxMsgs;
     Rescan_MaxAge_UnixTime:=GetCurrentUnixTime - Longint (MaxAge)*SEC_Dag;
     Rescan_AreaRecNr:=AreaRecNr;
     Rescan_UserRecNr:=UserRecNr;

     ReadAreaBaseRecord (AreaRecNr,Rescan_AreaRec);

     LogMessage (liGeneral,'Rescan of '+Rescan_AreaRec.AreaName_F);

     IF (Rescan_AreaRec.Deleted) OR
        (Rescan_AreaRec.AreaType <> Area_Echo) THEN
     BEGIN
          LogMessage (liFatal,'Invalid area type; aborting rescan');
          Exit; { ## EXIT ## }
     END;

     { save the reply built so far by AreaFix }
     MsgsPushState;

     CASE Rescan_AreaRec.FidoMsgStyle OF
          FidoMsgType :
              FidoMsg_Rescan (Rescan_AreaRec);

          SquishType :
              Squish_Rescan (Rescan_AreaRec);

          JamType :
              Jam_Rescan (Rescan_AreaRec);

          ELSE
              LogMessage (liFatal,'Area has no message base; rescan failed');
     END; { case }

     MsgsPopState;
END;


{--------------------------------------------------------------------------}
{ Rescan_ExportCheck                                                       }
{                                                                          }
{ This routine is used by all the message base routines that perform the   }
{ rescan to have one place to check whether the message has to be exported }
{ or not. The result of the routine is the RescanResultType, which can be: }
{ rstExport: Yes, export the message and continue the scan.                }
{ rstNoExport: No, do not export the message because it is too old.        }
{ rstNoExport_Stop: No, do not export the message because enough messages  }
{                   have been exported already.                            }
{                                                                          }
{ The input is the date of the message.                                    }
{                                                                          }
FUNCTION Rescan_ExportCheck (UnixTime : LONGINT) : RescanResultType;
BEGIN
     {LogMessage (liDebug,'Rescan_ExportCheck: '+Longint2String (UnixTime));}

     IF (Rescan_MaxMsgs = 0) THEN
     BEGIN
          Rescan_ExportCheck:=rstNoExport_Stop;
          Exit;
     END;

     IF (UnixTime >= Rescan_MaxAge_UnixTime) THEN
        Rescan_ExportCheck:=rstExport
     ELSE
         Rescan_ExportCheck:=rstNoExport;
END;


{--------------------------------------------------------------------------}
{ Rescan_DeliverMessage                                                    }
{                                                                          }
{ This routine is called by the message base rescan routines to export a   }
{ message. The message was allowed through by Rescan_ExportCheck and this  }
{ routines exports it. This routine is the glue and calls upon a routine   }
{ in deliver.pas that exports to the PKT or P2K file.                      }
{                                                                          }
{ Part of this routine was copied from Scan_DeliverNow.                    }
{                                                                          }
PROCEDURE Rescan_DeliverMessage;
BEGIN
     IF (Rescan_MaxMsgs <> 65535) THEN
        Dec (Rescan_MaxMsgs);

     { this is used to avoid import in the area we export from }
     Msg.ExportAreaRecNr:=Rescan_AreaRecNr;

     {## needed? - can remove Rescan_AreaRecNr if we remove this }
     Address_AddAreaToAreaRecNrsList (Rescan_AreaRecNr);

     { prepare the internal SEEN-BY and PATH administration }
     SBP_StoreSeenBysAndPath (Msg.FromAddr_F.Zone);

     Msg.DeliveringUserRecNr:=NILRecordNr; {WaterGate sends}

     { fill in the informational fields }
     Msg.ToUser_F:=Msg.Stored_ToUser;

     DeliverEchomail_Rescan (Rescan_UserRecNr,Rescan_AreaRec);
END;


END.
