PROGRAM DumpDupe;

USES Ramon,
     UnixTime;

CONST MAX_VALUES_PER_SECTION = 1024;

TYPE DupeSectionRecord = RECORD
                               Length  : WORD;    { including header }
                               NextPos : LONGINT; { next section }
                               AreaRef : LONGINT; { for check/recovery }
                               Sum     : WORD;    { sum in all sections }
                               Created : LONGINT; { unix stamp, for stats }
                               Age     : LONGINT; { unix stamp, when full }
                               Count   : WORD;    { used in this block }

                               { variable length, following is maximum }
                               Values  : ARRAY[1..MAX_VALUES_PER_SECTION] OF LONGINT;
                         END;

CONST SECTION_REC_STATIC = SizeOf (DupeSectionRecord)-MAX_VALUES_PER_SECTION*4;

VAR InFile    : FILE;
    Header    : STRING[30];
    BytesRead : WORD;
    DupeRec   : DupeSectionRecord;
    Cap       : WORD;
    Lp        : WORD;
    OutFile   : TEXT;
    Pos       : LONGINT;

BEGIN
     Assign (InFile,'DUPEBASE.TDB');
     Reset (InFile,1);
     IF (IOResult <> 0) THEN
     BEGIN
          WriteLn ('Failed to open DUPEBASE.TDB');
          Exit;
     END;

     WriteLn ('Creating DUPEBASE.TXT');

     Assign (OutFile,'DUPEBASE.TXT');
     ReWrite (OutFile);
     WriteLn (OutFile,'Created by DumpDupe at '+UnixTimeToString (GetCurrentUnixTime));

     BlockRead (InFile,Header[1],28);
     Header[0]:=#28;

     WriteLn (OutFile,'Header: "'+Header+'"');
     WriteLn (OutFile,'Size:   ',Longint2String (FileSize (InFile))+' bytes');

     Pos:=28;
     WHILE (Pos < FileSize (InFile)) DO
     BEGIN
          WriteLn (OutFile);
          WriteLn (OutFile,'Dupe record at $'+Long2HexString (Pos));

          Seek (InFile,Pos);
          BlockRead (InFile,DupeRec,SizeOf (DupeSectionRecord),BytesRead);

          WITH DupeRec DO
          BEGIN
               WriteLn (OutFile,'  Length:   ',Length);
               WriteLn (OutFile,'  NextPos:  $',Long2HexString (NextPos));
               WriteLn (OutFile,'  AreaRef:  $',Long2HexString (AreaRef));
               WriteLn (OutFile,'  Sum:      ',Sum);
               WriteLn (OutFile,'  Created:  $',Long2HexString (Created),' (',UnixTimeToString (Created)+')');
               WriteLn (OutFile,'  Age:      $',Long2HexString (Age),' (',UnixTimeToString (Age)+')');
               WriteLn (OutFile,'  Count:    ',Count);

               Cap:=(Length-SECTION_REC_STATIC) DIV 4;
               WriteLn (OutFile,'  Capacity: ',Cap);
               Write   (OutFile,'  Values:   ');

               FOR Lp:=1 TO Cap DO
               BEGIN
                    Write (OutFile,'$'+Long2HexString (Values[Lp])+' ');
                    IF ((Lp MOD 6) = 0) AND (Lp <> Cap) THEN
                    BEGIN
                         WriteLn (OutFile);
                         Write   (OutFile,'            ');
                    END;
               END;

               WriteLn (OutFile);
          END;

          Inc (Pos,DupeRec.Length);
     END; { while }

     WriteLn (OutFile);
     WriteLn (OutFile,'<end of file>');

     Close (InFile);
     Close (OutFile);
     WriteLn ('Done');
END.
