PROGRAM FEAreas;

USES Strings;

PROCEDURE ReadFastEchoConfig (Path : STRING);

TYPE FEConfigRecord = RECORD
                            revision        : WORD;
                            flags           : LONGINT;
                            NodeCnt,
                            AreaCnt,
                            unused1         : WORD;
                            NetMPath,
                            MsgBase,
                            InBound,
                            OutBound,
                            Unpacker,
                            LogFile         : ARRAY[1..56] OF CHAR;
                            unused2         : ARRAY[1..336] OF BYTE;
                            Unpacker2,
                            UnprotInBound,
                            StatFile,
                            SwapPath,
                            SemaphorePath,
                            BBSConfigPath,
                            QueuePath       : ARRAY[1..56] OF CHAR;
                            unused3         : ARRAY[1..32] OF BYTE;
                            RetearTo        : ARRAY[1..40] OF BYTE;
                            LocalInBound    : ARRAY[1..56] OF CHAR;
                            ExtAfter,
                            ExtBefore       : ARRAY[1..52] OF CHAR;
                            Unused4         : ARRAY[1..480] of BYTE;
                            CC              : ARRAY[1..10,1..34] of BYTE;
                            security,
                            loglevel         : BYTE;
                            def_days,
                            def_messages     : WORD;
                            unused5          : ARRAY[1..462] of BYTE;
                            autorenum,
                            def_recvdays     : WORD;
                            openQQQs,
                            Swapping         : BYTE;
                            compressafter,
                            afixmaxmsglen,
                            compressfree     : WORD;
                            TempPath         : ARRAY[1..56] OF CHAR;
                            graphics,
                            BBSSoftware      : BYTE;
                            AreaFixHelp      : ARRAY[1..56] OF CHAR;
                            unused6          : ARRAY[1..504] of BYTE;
                            AreaFixFlags     : WORD;
                            QuietLevel,
                            Buffers,
                            FWACnt,                     { # of ForwardAreaFix records}
                            GDCnt            : BYTE;    { # of Group Default records }
                            rescan_def       : ARRAY[1..5] OF WORD;
                            duperecords      : LONGINT;
                            arcext           : WORD;
                            AFixRcptLen      : WORD;
                            AkaCnt,
                            resv             : BYTE;              { # of Aka records stored }
                            maxPKT           : WORD;
                            sharing,
                            sorting          : Byte;
                            sysops           : Array[1..11,1..40] of BYTE;
                            AreaFixLog,
                            TempInBound      : ARRAY[1..56] OF CHAR;
                            maxPKTmsgs,
                            RouteCnt              : WORD;       { # of PackRoute records }
                            maxPACKratio          : Byte;
                            SemaphoreTimer        : Byte;
                            PackerCnt,
                            UnpackerCnt,                        { # of Packers and Unpackers records }
                            GroupCnt,
                            OriginCnt             : Byte;       { # of GroupNames and Origin records }
                            mailer                : Word;
                            maxarcsize,maxarcdays : Word;
                            reserved              : ARRAY[1..806] OF BYTE;
                            AreaRecSize,
                            GrpDefRecSize,                      { Size  of  Area  and  GroupDefaults }
                            MaxAreas,                           { records stored in this file        }
                            MaxNodes,                           { Current max values for this config }
                            NodeRecSize           : Word;       { Size of each stored Node record    }
                            offset                : Longint;    { This is the offset from the current}
                      END;                                      { file-pointer to the 1st Node       }

TYPE FEAreaRecord = RECORD
                          NAME       : ARRAY[1..52] OF CHAR;
                          board,
                          conference,
                          read_sec,
                          write_sec  : Word;
                          Info       : Word;
                          flags      : Word;
                          advflags   : Word;
                          resv1      : Word;
                          seenbys,
                          resv2      : LongInt;
                          days,
                          messages,
                          recvdays   : Word;
                          path       : ARRAY[1..56] OF CHAR;
                          desc       : ARRAY[1..52] OF CHAR;
                    END;

VAR FECfg     : FILE;
    IORes     : BYTE;
    FEConfig  : FEConfigRecord;
    SeekBase  : LONGINT;
    BytesRead : WORD;

    {----------------------------------------------------------------------}
    { ImportFEAreas                                                        }
    {                                                                      }
    { Deze routine importeert FastEcho areas. File is open en file pointer }
    { staat goed.                                                          }
    {                                                                      }
    PROCEDURE ImportFEAreas;

    VAR Lp     : WORD;
        FEArea : FEAreaRecord;
        Grp    : BYTE;

    BEGIN
         {$I-} Seek (FECfg,SeekBase); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              WriteLn (Output,'Error seeking to area block start');
              Exit;
         END;

         FOR Lp:=1 TO FEConfig.AreaCnt DO
         BEGIN
              {$I-} BlockRead (FECfg,FEArea,SizeOf (FEAreaRecord),BytesRead); {$I+} IORes:=IOResult;
              IF (IORes <> 0) OR (BytesRead <> SizeOf (FEAreaRecord)) THEN
              BEGIN
                   WriteLn (Output,'Error reading area block ',Lp);
                   Exit;
              END;

              IF (FEArea.Board = $8000) THEN
                 Continue; { deleted }

              IF ((FEArea.Flags SHR 4) = 3) THEN
              BEGIN
                   WriteLn (Output,'Skipping BadMail area');
                   Continue;
              END;

              IF ((FEArea.Flags SHR 4) = 4) THEN
              BEGIN
                   WriteLn (Output,'Skipping DupeMail area');
                   Continue;
              END;

              WriteLn (Output,'Area Name: ',StrPas (@FEArea.Name));

              CASE (FEArea.Flags SHR 4) OF
                   0 : WriteLn (Output,'  Type: Echo');
                   1 : WriteLn (Output,'  Type: Netmail');
                   2 : WriteLn (Output,'  Type: Local');
                   ELSE
                       WriteLn (Output,'    Unknown Area Type ',(FEArea.Flags SHR 4));
              END; { case }

              IF (FEArea.Board = $4000) THEN
              BEGIN
                   { not hmb, check for *.msg, squish, jam }
                   CASE (FEArea.Flags AND 15) OF
                        0: WriteLn (Output,'   BaseType: QBBS, not supported');
                        1: WriteLn (Output,'   BaseType: *.MSG');
                        2: WriteLn (Output,'   BaseType: Squish');
                        3: WriteLn (Output,'   BaseType: JAM');
                        7: WriteLn (Output,'   BaseType: Pass-through');
                   END; { case }
              END;

              WriteLn (Output,'   BasePath: ',StrPas (@FEArea.Path));
         END; { for }
    END;

VAR {FEExtHdr : FEExtensionHeader;}
    Quit     : BOOLEAN;
    Keuze    : WORD;

LABEL Abort;

BEGIN
     Assign (FECfg,Path);
     {$I-} Reset (FECfg,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (Output,'Cannot open ',Path,' (error ',IORes,')');
          Exit;
     END;

     {$I-} BlockRead (FECfg,FEConfig,SizeOf (FEConfigRecord),BytesRead); {$I+} IORes:=IOResult;
     IF (IORes <> 0) OR (BytesRead <> SizeOf (FEConfigRecord)) THEN
     BEGIN
          WriteLn (Output,'Error reading configuration block');
          GOTO Abort;
     END;

     IF (FEConfig.Revision <> 6) THEN
     BEGIN
          WriteLn (Output,'Revision (',FEConfig.Revision,') not supported');
          GOTO Abort;
     END;

     (* works as documented, but not needed
     SeekBase:=SizeOf (FEConfigRecord);

     WHILE (FilePos (FECfg) < FEConfig.Offset) DO
     BEGIN
          BlockRead (FECfg,FEExtHdr,SizeOf (FEExtensionHeader),BytesRead);
          IF (BytesRead <> SizeOf (FEExtensionHeader)) THEN
          BEGIN
               ListAddItem ('Error reading extension block',65535,Bottom);
               GoTO Abort;
          END;

          ListAddItem ('Extension block '+Word2HexString (FEExtHdr.Typ)+', length '+Longint2String (FEExtHdr.Offset),0,Bottom);

          Seek (FECfg,FilePos (FECfg)+FEExtHdr.Offset);
     END;
     *)

     SeekBase:=SizeOf (FEConfigRecord)+FEConfig.Offset;

     { adjust SeekBase to point behind the user record }
     SeekBase:=SeekBase+FEConfig.NodeCnt*FEConfig.NodeRecSize;
     ImportFEAreas;

Abort:
     Close (FECfg);

     WriteLn (Output,'Done');
END;


BEGIN
     Assign (Output,'');
     ReWrite (Output);

     ReadFastechoConfig ('c:\wsd\decoded\festuf\fastecho.cfg');
END.
