PROGRAM PktHead;

{ dit programma dumpt de header van een pakket }

USES Dos;

TYPE FidoPktHdr = RECORD                               { close to stoneage }
                        orig_node : WORD;               { originating node }
                        dest_node : WORD;               { destination node }

                        year   : WORD;                      { 1989 - nnnnn }
                        month  : WORD;
                        day    : WORD;
                        hour   : WORD;
                        minute : WORD;
                        second : WORD;

                        baud : WORD;                              { unused }
                        ver  : WORD;                                   { 2 }

                        orig_net: integer;                  { originating net }
                        dest_net: integer;                  { destination net }

                        product : BYTE;                { FTSC produkt code }
                        rev_lev : BYTE;                    { versie nummer }

                        password : ARRAY[1..8] OF BYTE;    { Node password }

                        qm_orig_zone : WORD;               { qm = Qmail ?? }
                        qm_dest_zone : WORD;                 { (verouderd) }

                        F48_AuxNet         : Word;
                        F48_ValidationCopy : Word;
                        F48_ProduktCode    : Byte;
                        F48_Revision       : Byte;
                        F48_Capability     : Word;

                        orig_zone  : WORD;              { originating zone }
                        dest_zone  : WORD;              { destination zone }
                        orig_point : WORD;             { originating point }
                        dest_point : WORD;             { destination point }
                        pr_data    : LONGINT;                  { reserved? }
                  END;

VAR InFile : FILE;
    Header : FidoPktHdr;
    Pw     : STRING[8];

BEGIN
     IF (ParamCount <> 1) THEN
     BEGIN
          WriteLn ('PktHead v1.0');
          WriteLn ('(c) Ramon van der Winkel ''95');
          WriteLn;
          WriteLn ('Usage: PKTHEAD <.PKT filename>');
          WriteLn;
          Halt;
     END;

     Assign (InFile,ParamStr (1));
     Reset (InFile,1);
     BlockRead (InFile,Header,SizeOf (FidoPktHdr));
     Close (InFile);

     WriteLn ('Header of ',FExpand (ParamStr (1)));
     WITH Header DO
     BEGIN
          Move (password,pw[1],8);
          pw[0]:=#8;

          WriteLn ('orig_node (word):          ',orig_node);
          WriteLn ('dest_node (word):          ',dest_node);
          WriteLn ('Y,M,D,H,M,S: (6x word):    ',year,' ',month,' ',day,' ',hour,' ',minute,' ',second);
          WriteLn ('baud (word):               ',baud);
          WriteLn ('ver (word):                ',ver);
          WriteLn ('orig_net (integer):        ',orig_net);
          WriteLn ('dest_net (integer):        ',dest_net);
          WriteLn ('product (byte):            ',product);
          WriteLn ('rev_lev (byte):            ',rev_lev);
          WriteLn ('password (8x byte):        ',pw);
          WriteLn ('qm_orig_zone (word):       ',qm_orig_zone);
          WriteLn ('qm_dest_zone (word):       ',qm_dest_zone);
          WriteLn ('F48_AuxNet (word):         ',F48_AuxNet);
          WriteLn ('F48_ValidationCopy (word): ',F48_ValidationCopy);
          WriteLn ('F48_ProduktCode (byte):    ',F48_ProduktCode);
          WriteLn ('F48_Revision (byte):       ',F48_Revision);
          WriteLn ('F48_Capability (word):     ',F48_Capability);
          WriteLn ('orig_zone (word):          ',orig_zone);
          WriteLn ('dest_zone (word):          ',dest_zone);
          WriteLn ('orig_point (word):         ',orig_point);
          WriteLn ('dest_point (word):         ',dest_point);
          WriteLn ('pr_data (longint):         ',pr_data);
     END;
END.
