{ -------------------------------------------------- }
{ Config.Inc                                         }
{                                                    }
{ This file contains the structure information of    }
{ the main configuration file (WtrCfg.Tdb)           }
{                                                    }
{ (c) 1994 WaterLine Software Development            }

{$IFNDEF Wtr_Config}
{$DEFINE Wtr_Config}

{$I kit\globals.inc}

TYPE  CharArrayType = ARRAY [128..255] OF Char;

CONST MaxLenComprPrgDescr = 79;
      MaxAreafixFwd       = 10;
      MaxInboundDirs      = 2;
      MaxOrigins          = 2;
      MaxPrivMail         = 10;
      MinFidoMsgLen       = 5000;  { minimale waarde voor de MaxFidoMsgLen }
      MinFidoArcLen       = 50000;
      MaxLenToUser_F      = 36;
      MaxLenFromUser_F    = 36;
      MaxLenSubj_F        = 72;
      MaxLenPath_F        = 255;
      MaxLenDate_F        = 20;


TYPE CompDecompType = (Compr,DeCompr);
     CompUsenetType = (Compress,GZip);
     SecurityType   = (Secure,NotSecure);
     FidoSystemType = (stBinkley,stFrontdoor);
     PrivateMailType= (PvtFrom,PvtTo,PvtSubj);
     ArcType        = (ArcArc,ArcHex,ArcAll);
     ReplyKludgeType= (FSC35,SenderInBody,SenderInHeader,SenderInHeaderABody);

     AreaListType         = (LstAREASBBS,LstNAMES);

     AreafixForwardRecord = RECORD
                             UplinkAddress : FidoAddrType;      { System to send requests to }
                             Unconditional : Boolean;           { Always forward messages ?  }
                             AreaListPath  : STRING[ 50 ];      { Path to file with names    }
                             AreaList      : AreaListType;      { AREAS.BBS or normal list ? }
                             AreaManager   : STRING[ 10 ];      { Name of 'Areafix'          }
                             Password      : STRING[ 10 ];      { Password to use for uplink }
                             Group         : Byte;              { Group to work              }
                             AddPlus       : Boolean;           { Add a '+' before the name? }
                            END;

     UsenetForwardRecord  = RECORD
                             UUCPName      : STRING[ MaxLenUUCPName ]; { UUCP Name of the user                 }
                             AreaListPath  : STRING[ 50 ];             { to search in this file for area names }
                            END;



     { The configuration record as stored on disk }

     ConfigRecord   = RECORD

        SystemDir  : STRING[79];              { WaterGate system directory   }
        Sysop      : STRING[MaxLenSysopName]; { System Operator              }

        DupeChecks : WORD;         { Maximum numb. of dupechecks     }
        DoDupeChk  : BOOLEAN;      { En/Disable dupe checking        }
        MaxHandles : BYTE;         { Maximum number of file handles  }
        TimeZone   : STRING[10];   { Time Zone ID string             }
        CacheTdb   : BOOLEAN;      { Cache .TDB files into XMS       }

        TooLargePath: STRING[79];  { Used to dump oversized messages }
        LogFilePath : STRING[79];  { Used to store the logfile       }

        { fido }
        NodeNrs     : ARRAY[AkaIndexType] OF FidoAddrType;       { System Fido Node Numbers             }
        PointNets   : ARRAY[AkaIndexType] OF WORD;               { Pointnet definitions                 }
        Security_F  : ARRAY[1..MaxInboundDirs] OF SecurityType;  { Security for the inbound directory's }
        Inbound_F   : ARRAY[1..MaxInboundDirs] OF STRING[79];    { Fido Inbound directory's             }
        Outbound_F  : STRING[79];                                { Outbound directory                   }
        ComprPrgs_F : ARRAY[CompDecompType,ARC..GUS]             { Compression program definitions      }
                      OF STRING[MaxLenComprPrgDescr];

        MaxFidoMsgLen : LONGINT;           { Maximum fido message length                       }
        MaxFidoArcLen : LONGINT;           { Maximum fido archive length                       }
        DefGroups_F   : GroupFlagType;     { Default Fido Groups                               }

        FidoSystem    : FidoSystemType;    { Binkley/Frontdoor mode                            }
        FidoAcceptTO  : BOOLEAN;           { Accept domain addresses in TO Field               }

        FidoNetmailType     : FidoMsgStyleType;      { *.MSG/Squish netmail directory          }
        FidoNetmailPath     : STRING[79];            { Netmail directory/filename              }
        FidoBadAreaType     : FidoMsgStyleType;      { Bad mail base type                      }
        FidoBadPath         : STRING[79];            { Bad mail directory/filename             }
        FidoDupeAreaType    : FidoMsgStyleType;      { Dupe mail base type                     }
        FidoDupePath        : STRING[79];            { Dupe mail directory/filename            }
        FidoAutoCreateType  : FidoMsgStyleType;      { Auto create area base type              }
        DefaultFidoMsgPath  : STRING[79];            { Default path for new areas              }

			  { Local Fido Message Bases }

        StripSeenBy,                                 { Remove SeenBy's at import               }
        AutoLink,                                    { AutoLink areas with new mail after toss }
        ReplaceTear      : Boolean;                  { Replace Tearline at export, ignored for }
                                                     { unregistered operation.                 }

        ReplyKludges     : ReplyKludgeType;          { ^REPLYADDR                              }

        DefNumbToKeep_F,                             { Default number of messages to keep      }
        DefDaystoKeep_F     : Integer;               { Default number of Days to keep          }
        FidoArcmailExtension: ArcType;               { 0..9,A..F,G..Z                          }

			  { Import from Usenet	      }

        UUCPGATEWAY   : AkaIndexType;                { Gateway AKA                             }
        NameSeparator : CHAR;                        { Character to replace spaces in fido     }
                                                     { names when converting them to usenet    }
        UseGateFields : LONGINT;                     { Usenet fields to convert to fido        }
        GateWayUser   : STRING[MaxLenDomain];        { User name for 'UUCP' gateway            }


        Origins       : ARRAY[1..MaxOrigins] OF STRING[MaxLenOrigin];  { Origin line definitions       }

        { UseNet }
        WorldWide     : BOOLEAN;             { Is our system worldwide registered ?    }
        DefGroups_U   : GroupFlagType;       { Default Usenet groups                   }
        SpoolBaseDir  : STRING[79];          { Spool file root directory               }
        MaxDatLength  : LONGINT;             { Maximum *.DAT file size                 }

        SmartHost     : STRING[MaxLenUUCPName];                        { Smarthost system ID               }
        UUCPName      : STRING[MaxLenUUCPName];                        { Our UUCP ID                       }
        BackBone      : STRING[MaxLenDomain];                          { Backbone system                   }
        Organization  : STRING[MaxLenOrganization];                    { Our organization description      }
        Domains       : ARRAY[ 1..MaxDomains] OF STRING[MaxLenDomain]; { Our domain AKA definitions        }
        ComprPrg_U    : ARRAY[CompUsenetType,CompDecompType] OF STRING[MaxLenComprPrgDescr];

        { Private mail information                      }
        PrivmailType  : FidoMsgStyleType;                                 { Base to use for private mail   }
        PrivmailPath  : STRING[79];                                       { Path to base/directory         }

        PrivmailOption: ARRAY [1 .. MaxPrivMail] OF String[MaxLenSubj_F]; { Name/Subject for private copy scan   }
        PrivmailSelect: ARRAY [1 .. MaxPrivMail] OF PrivateMailType;      { Select on To/From/Subject      }

        { Areafix forwarding information                }
        AreafixForward: ARRAY [1 .. MaxAreaFixFwd] OF AreaFixForwardRecord;
        UsenetForward : ARRAY [1 .. MaxAreaFixFwd] OF UsenetForwardRecord;

        { Conversion character table Fido->UUCP         }
        ConversionTable      : CharArrayType;

        { Maximum size of a message in a squish/jam area, if a message  }
        { exceeds this size it is split into multiple parts.            }

        MaxSquishMsgLen      : Longint;
        MaxJAMMsgLen         : Longint;

        DefaultCompressor    : CompressionType;
        PackedAddresses      : Boolean;

        { New fields  14/08/1994 }
        SemaphorePath        : FilePathStr;
        DBridgeQueuePath     : FilePathStr;
        AreafixName          : STRING[ 10 ];

                             END;


{$ENDIF}





