PROGRAM WTR2EDIT;

{ WaterGate to Editor                                                       }
{ - Exports TimEd and GoldEd compatible files                               }
{                                                                           }
{ File    : WTR2EDIT.PAS                                                    }
{ Compiler: Turbo Pascal v7.00                                              }
{ Date    : 19/03/1994                                                      }
{ Version : 1.01                                                            }
{                                                                           }

{ "WtrFunc" contains some basic functions to access the configuration       }

USES WtrFunc;

VAR   Config            : ConfigRecord;
      AreaData          : AreaBaseRecord;
      AreaBaseFile      : FILE;
      EditorAreaFile    : Text;

      FileName          : String;
      GoldEd            : Boolean;

      MaximusAreaName   : STRING;
      BoardNumber       : Longint;


{ -------------------------------------------------------------------------}
{ ShowInfo                                                                 }
{                                                                          }

PROCEDURE ShowInfo;
BEGIN
 Writeln( 'Wtr2Editor v1.00' );
 Writeln( 'Waterline Software Dev. 1994');
 Writeln;
END;


{ -------------------------------------------------------------------------}
{ ShowHelp                                                                 }
{                                                                          }

PROCEDURE ShowHelp;
BEGIN
 Writeln( 'Usage: WTR2EDIT <filename> [GoldEd]' );
 Writeln;
 Writeln( 'By default this program will export a TimEd compatible');
 Writeln( 'area listing. If put "GoldEd" on the command line after');
 Writeln( 'the name of the file to export to, a GoldEd compatible');
 Writeln( 'listing is generated.');
 Writeln;
END;

{ ------------------------------------------------------------------------- }
{ ParseCommandLineOptions                                                   }
{                                                                           }
{ Checks the commandline for BOARD= and FILE= commands                      }

PROCEDURE ParseCommandLineOptions;
VAR ParamCounter : Byte;
    ToUpper      : Byte;
    Error        : Integer;
    GoldEdStr,
    Parameter    : String;
BEGIN

 { -- Eerste optie is een file name }
 IF ParamCount < 1 THEN
  BEGIN
  ShowHelp;
  Halt(1);
  END;

 FileName := ParamStr(1);

 { -- De tweede mogenlijk 'GoldEd' }

 GoldEdStr := ParamStr(2);

 IF ParamCount < 3 THEN
  BEGIN
   FOR ToUpper := 1 TO Length( GoldEdStr ) DO
    GoldEdStr[ToUpper] := UpCase( GoldEdStr[ToUpper] );

   IF GoldEdStr = 'GOLDED' THEN
    Golded := True;
   END;

END;


{ ------------------------------------------------------------------------- }
{ Main                                                                      }
{                                                                           }
{ Processes the area configuration, and dumps it into an export file        }

VAR AreaCounter : Longint;

BEGIN

 { Show program info                   }
 ShowInfo;
 GoldEd := False;

 { Check the command line              }
 ParseCommandlineOptions;

 { Try to open the Configuration file  }
 IF NOT ReadConfiguration( Config ) THEN
  BEGIN
  Writeln('Error! Unable to open WaterGate configuration file !');
  Halt(1);
  END;

 { Try to open the AreaBase file       }
 IF NOT OpenAreaBase( AreaBaseFile ) THEN
  BEGIN
  Writeln('Error! Unable to open WaterGate Area Base !');
  Halt(1);
  END;

 { Try to open the Maximus export file }

 {$I-}
 Assign( EditorAreaFile , FileName );
 Rewrite( EditorAreaFile );
 {$I+}

 IF IoResult > 0 THEN
  BEGIN
  Writeln( 'Error! Unable to open "' + FileName + '" for output.');
  Halt(1);
  END;

 { Export all areas to disk            }
 FOR AreaCounter := 1 TO AreaBaseRecordCount( AreaBaseFile ) DO
  BEGIN

   ReadAreaBaseRecord( AreaBaseFile, AreaData, AreaCounter );

   IF (NOT AreaData.Deleted) AND (AreaData.FidoMsgStyle <> NoneType) THEN
   BEGIN

    { Show a counter for those nervous CTRL-ALT-DELlers }
    Write( 'Area : ' , AreaCounter , #13 );

    IF GoldEd THEN
      BEGIN

      Write( EditorAreaFile, 'AREA ' + AreaData.AreaName_F + ' "' + AreaData.AreaName_F + '" ');

      CASE AreaData.FidoMsgStyle OF
        FidoMsgType : Write ( EditorAreaFile,' FE ' );
        SquishType  : Write ( EditorAreaFile,' ME ' );
        JamType     : Write ( EditorAreaFile,' JE ' );
      END;

      Writeln( EditorAreaFile,AreaData.FidoMsgPath );

      END
    ELSE
      BEGIN

      { Timed }
      Write( EditorAreaFile, 'EchoArea  "' + AreaData.AreaName_F + '" ' + AreaData.AreaName_F  + ' ' + AreaData.FidoMsgPath );

      CASE AreaData.FidoMsgStyle OF
        SquishType  : WriteLn ( EditorAreaFile, ' -$' );
        JamType     : WriteLn ( EditorAreaFile, ' -J' );
       END;

      END;

    Inc( BoardNumber );
   END;
  END;

 { Close all open files }
 CloseAreaBase( AreaBaseFile );
 Close ( EditorAreaFile );

 Writeln;
 Writeln( 'Finished !');

END.
