PROGRAM XmsTest;

USES Crt,XmsLib;

VAR ExtMaxAvail,
    ExtMemAvail  : WORD; { in blokken van 1Kb }
    BlockHandle  : WORD;

{ main }

VAR Lp2,
    Lp  : WORD;
    Arr : ARRAY[0..2047] OF BYTE; { 256*8 = 2K }

BEGIN
     WriteLn ('XmsTest v1.0 - RvdW ''93');
     WriteLn;

     IF (NOT XmsPresent) THEN
     BEGIN
          WriteLn ('No XMS Memory Manager, aborting program');
          Halt;
     END;

     WriteLn ('XMS version ',XmsVersionStr);
     WriteLn ('Memory Manager ',XmmVersionStr);

     QueryFreeExtendedMemory (ExtMaxAvail,ExtMemAvail);
     WriteLn ('ExtMaxAvail = ',ExtMaxAvail,' Kb');
     WriteLn ('ExtMemAvail = ',ExtMemAvail,' Kb');

{ 200Kb, 256 blokken van 2Kb test data}
     IF (NOT AllocateXMB (2*201{Kb},BlockHandle)) THEN
     BEGIN
          WriteLn (XmsErrorStr);
          Halt;
     END;

{ vullen met test data }
     FOR Lp:=0 TO 200 DO
     BEGIN
          Write ('w',Lp,'  ',#13);
          FOR Lp2:=0 TO 2047 DO Arr[Lp2]:=Lp+Lp2;

          IF (NOT CopyToXmb (2048,@Arr,BlockHandle,Longint (Lp)*2048)) THEN
          BEGIN
               WriteLn (XmsErrorStr);
               WriteLn ('On storage to the array, Lp = ',Lp);
               Break;
          END;
     END;
     WriteLn;

     { terug lezen }
     FOR Lp:=0 TO 200 DO
     BEGIN
          Write ('r',Lp,'  ',#13);

          IF (NOT CopyFromXmb (2048,@Arr,BlockHandle,Longint (Lp)*2048)) THEN
          BEGIN
               WriteLn (XmsErrorStr);
               Halt;
          END;

          FOR Lp2:=0 TO 2047 DO
              IF (Arr[Lp2] <> ((Lp+Lp2) AND 255)) THEN
              BEGIN
                   WriteLn ('Retrieve error in block ',Lp,' at offset ',Lp2);
                   Break;
              END;
     END;
     WriteLn;

     IF (NOT FreeXMB (BlockHandle)) THEN
     BEGIN
          WriteLn (XmsErrorStr);
          Halt;
     END;
END.
