PROGRAM TGUsers2;

{ this program exports a tgusers.txt file with all users in a Telegard  }
{ 3.00 users.dat file. Note that deleted and locked out users are left  }
{ out. Have not found a use to include the user number since JAM/Squish }
{ is used only.                                                         }

{$I c:uit\telegard.inc }

VAR InFile  : FILE;
    OutFile : TEXT;
    IORes   : BYTE;
    Count   : WORD;
    Rec     : userrec;

BEGIN
     WriteLn ('TGUsers2 v1.00 - 970825');
     WriteLn ('Written by Ramon van der Winkel, ramon@wsd.wline.se');
     WriteLn;

     IF (ParamCount = 0) THEN
     BEGIN
          WriteLn ('Exports a tgusers.txt file with all user names');
          WriteLn ('for use by WaterGate''s "bbsusers" features.');
          WriteLn;
          WriteLn ('Usage: tgusers <path to users.dat file>');
          WriteLn ('Example: tgusers c:\tg\users.dat');
          WriteLn;
          WriteLn ('The tgusers.txt file is created in the current');
          WriteLn ('directory - say the WaterGate system directory.');
          WriteLn;
          Halt;
     END;

     Assign (InFile,ParamStr (1));
     {$I-} Reset (InFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Failed to open USERS.IDX (error ',IORes,')');
          { in case of sharing violations: tgusers.txt not overwritten }
          Halt;
     END;

     Assign (OutFile,'tgusers.txt');
     {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Failed to create tgusers.txt');
          Close (InFile);
          Halt;
     END;

     Count:=0;

     WHILE (FilePos (InFile) < FileSize (InFile)) DO
     BEGIN
          BlockRead (InFile,Rec,SizeOf (userrec));

          WriteLn (OutFile,Rec.Name);

          IF (Rec.Name <> Rec.RealName) THEN
             WriteLn (OutFIle,Rec.RealName);

          Inc (Count);
     END; { while }

     WriteLn ('Exported ',Count,' user names to tgusers.txt');

     Close (InFile);
     Close (OutFile);
END.

