PROGRAM CheckLog;

{ search for anomalies in the log }

USES Dos,
     Ramon;

{--------------------------------------------------------------------------}
{ TimeStamp                                                                }
{                                                                          }
{ Deze functie geeft een string in het formaat "10:13:12" terug met de     }
{ huidige tijd erin.                                                       }
{                                                                          }
FUNCTION TimeStamp : STRING;

VAR Hour,Min,Sec,SecH  : WordLong;

BEGIN
     GetTime (Hour,Min,Sec,SecH);

     TimeStamp:=AddUpWithPre0s (2,Word2String (Hour))+':'+
                AddUpWithPre0s (2,Word2String (Min))+':'+
                AddUpWithPre0s (2,Word2String (Sec));
END;


VAR LogFile  : TEXT;
    LogPath  : STRING;
    WorkPath : STRING;
    Regel    : STRING;
    IORes    : BYTE;
    InFile   : TEXT;
    First    : BOOLEAN;

BEGIN
     LogPath:=GetEnv ('WGTESTLOG');

     IF (LogPath = '') THEN
     BEGIN
          WriteLn (#7,'WGTESTLOG not set');
          Halt;
     END;

     WorkPath:=GetEnv ('WORKDRIVE');

     IF (WorkPath = '') THEN
     BEGIN
          WriteLn (#7,'WORKDRIVE not set');
          Halt;
     END;

     WorkPath:=WorkPath+'\wtrgate\wtrgate.log';

     Assign (LogFile,LogPath);
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7,'Error appending to / creating '+LogPath,' (error ',IORes,')');
          Halt;
     END;

     Assign (InFile,WorkPath);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 2) THEN
          BEGIN
               Close (LogFile);
               Halt;
          END;

          Regel:=TimeStamp+Spaces (5)+'Error opening '+WorkPath+' (error '+Byte2String (IORes)+')';
          WriteLn (LogFile,Regel);
          WriteLn (Regel);
     END ELSE
     BEGIN
          First:=TRUE;
          WHILE (NOT Eof (InFile)) DO
          BEGIN
               ReadLn (InFile,Regel);

               IF (Pos ('** PLEASE',Regel) > 0) OR
                  (Pos ('Not returned: +$',Regel) > 0) OR
                  (Pos ('Free block at +$',Regel) > 0) OR
                  (Pos ('Memory dump:',Regel) > 0) OR
                  (Pos ('(error ',Regel) > 0) THEN
               BEGIN
                    IF First THEN
                    BEGIN
                         LogPath:=TimeStamp+Spaces (5)+'--- Extract from '+WorkPath+' start ---';
                         WriteLn (LogFile,LogPath);
                         WriteLn (LogPath);
                         First:=FALSE;
                    END;

                    WriteLn (LogFile,Regel);
               END;
          END;

          Close (InFile);

          IF (NOT First) THEN
          BEGIN
               Regel:=TimeStamp+Spaces (5)+'--- Extract from '+WorkPath+' end ---';
               WriteLn (LogFile,Regel);
               WriteLn (Regel);
          END;
     END;

     Close (LogFile);
END.
