PROGRAM ReplaceDesc;

{ This is a program to search through Renegade's file bases for files   }
{ which don't contain any descriptions.  It will then replace the       }
{ empty description with a description the sysop has defined on the     }
{ commandline.  It fully supports SHARE, and can be run while a user    }
{ is online.                                                            }
{                                                                       }
{ This program and the source code included, have, in their entirety    }
{ been donated to the public domain.  Therefore the programmer holds    }
{ absolutely no liabilities, including, but not limited to damage, or   }
{ loss of profit due to the use or misuse of this program.              }
{                                                                       }
{ You may do whatever you want with this program; it took me 10 minutes }
{ to write it, and I'm using it for my own use, so frankly, it works    }
{ for me, I don't care what it does with your system, nor what you      }
{ decide to use it for.                                                 }
{                                                                       }
{ Programmed and released on January 8, 1994.                           }
{ Written by Lars Hellsten of MatrixSoft.                               }

USES DOS,
     CRT,
     MyShare,
     Strings,  { Custom strings unit }
     Misc1;    { Miscellaneous routines }


CONST ADver = 'v1.00';

{$I RECORDS.PAS }

VAR TempS,NewDesc : String;
    DirFile       : FILE OF ULFRec;
    Dir           : ULFRec;
    FBaseFile     : FILE OF ULRec;
    FBase         : ULRec;
    GeneralFile   : FILE OF GeneralRec;
    General       : GeneralRec;
    ThisBase,
    ThisFile      : Word;



PROCEDURE GetCustomDesc;
VAR ThisParam:Byte;
BEGIN
  NewDesc := '';
  IF ParamCount > 0 THEN NewDesc := ParamStr(1);
  IF ParamCount < 2 THEN Exit;

  FOR ThisParam := 2 TO ParamCount DO
     NewDesc := NewDesc+' '+ParamStr(ThisParam);
END;


PROCEDURE WriteIntro;
BEGIN
   ClrScr;
   WritePipe('|10ADD DESCRIPTION '+ADver+'|05  |15Replace Empty Descriptions Utility for Renegade'+#13#10);
   WritePipe('|11Written & Released January 8, 1994 by Lars Hellsten and MatrixSoft.'+#13#10);
   WritePipe('|09You can contact MatrixSoft at Access-PC BBS (416)491-9249.  Fido 1:250/320.'+#13#10);
   Window(1,5,80,25);
END;


BEGIN
   IF MyShare.ShareInstalled THEN FileMode := 66; { Read/Write, Deny None }
   WriteIntro;
   GetCustomDesc;
   Assign(GeneralFile,GetEnv('RENEGADE')+'RENEGADE.DAT');
   {$I-} Reset(GeneralFile); {$I+}
   IF IOResult <> 0 THEN
      BEGIN
         WritePipe('|12Error: Unable to locate RENEGADE.DAT; please run from main BBS directory or'+#13#10+
                   '|12       set the "RENEGADE" environment variable'+#13#10#13#10);
         Halt(1);
      END;
   Read(GeneralFile,General);
   Close(GeneralFile);
   Assign(FBaseFile,General.DataPath+'FBASES.DAT');
   {$I-} Reset(FBaseFile); {$I+}
   IF IOResult <> 0 THEN
      BEGIN
         WritePipe('|12Error: Unable to locate FBASES.DAT.'+#13#10#13#10);
         Halt(1);
      END;
   IF FileSize(FBaseFile) <= 0 THEN Halt(1);
   FOR ThisBase := 0 TO (FileSize(FBaseFile)-1) DO
      BEGIN
         Seek(FBaseFile,ThisBase);
         Read(FBaseFile,FBase);
         WritePipe('|09Processing: |10'+FBase.Filename);
         GotoXY(21,WhereY);
         WritePipe('|10 - ');
         IF (fbdirdlpath IN FBase.FBStat)
            THEN Assign(DirFile,FBase.DLPath+FBase.Filename+'.DIR')
            ELSE Assign(DirFile,General.DataPath+FBase.Filename+'.DIR');
         {$I-} Reset(DirFile); {$I+}
         IF (IOResult = 0) AND (FileSize(DirFile) > 0) THEN
            FOR ThisFile := 0 TO (FileSize(DirFile)-1) DO
               BEGIN
                  Seek(DirFile,ThisFile);
                  Read(DirFile,Dir);
                  GotoXY(24,WhereY);
                  WritePipe('|02'+Dir.Filename+'           ');
                  GotoXY(24,WhereY);
                  TempS := Dir.Description;
                  TempS := StripTrailingSpaces(TempS);
                  TempS := StripLeadingSpaces(TempS);
                  IF (Dir.VPointer = -1) AND (TempS[0] = #0) THEN
                     BEGIN
                        Dir.Description := NewDesc;
                        Seek(DirFile,ThisFile);
                        Write(DirFile,Dir);
                     END;
               END;
         Close(DirFile);
         GotoXY(22,WhereY);
         WritePipe('                    '+#13#10);
      END;
   Close(FBaseFile);
   WriteLn;
   WritePipe('|03Completed.'+#13#10);
END.
