SET BELL OFF
SET EXCLUSIVE OFF

PUBLIC nam,ONECH,XXX,EXTRA,BJDLR[5],BJPLR[5],IGMTXT,THISDAY,THATDAY
PUBLIC ONECH,YN,ESC,AXSEED,AYSEED,RAND_RESULT,RND_RET,FU_FLAG,DEKCNT,PCNT,DCNT
PUBLIC ESC,XCOLOR,BLACK,LGREEN,YELLOW,LBLUE,LPINK,LCYAN,WHITE,DGRAY,DRED,BJPSK
PUBLIC DGREEN,BROWN,DBLUE,DPINK,DCYAN,BBLACK,BRED,BGREEN,BBROWN,BBLUE,BPINK,BJDSK
PUBLIC BCYAN,BWHITE,FOUNDONE,OKTOJF,FOFLAG,OK2FIGHT,LUCKY,XFLAG,GAMBLES
PUBLIC CFG_CPD,CFG_FPD,CFG_TPD,CFG_JPD,CFG_RNAM,CFG_MSGBASE,CFG_GPD,DECK[52]
PUBLIC FIGHTS[55],CURFIGHT,EXPLEV,CFG_BBN,CFG_SYN,CFG_RNM,CFG_RKY,REGED



ESC     =   CHR(27) + "["
XCOLOR  =   ESC+"0m"
BLACK   =   ESC+"1;30m"
LRED    =   ESC+"1;31m"
LGREEN  =   ESC+"1;32m"
YELLOW  =   ESC+"1;33m"
LBLUE   =   ESC+"1;34m"
LPINK   =   ESC+"1;35m"
LCYAN   =   ESC+"1;36m"
WHITE   =   ESC+"1;37m"
DGRAY   =   XCOLOR + ESC+"0;30m"
DRED    =   XCOLOR + ESC+"0;31m"
DGREEN  =   XCOLOR + ESC+"0;32m"
BROWN   =   XCOLOR + ESC+"0;33m"
DBLUE   =   XCOLOR + ESC+"0;34m"
DPINK   =   XCOLOR + ESC+"0;35m"
DCYAN   =   XCOLOR + ESC+"0;36m"
BBLACK  =   ESC+"40m"
BRED    =   ESC+"41m"
BGREEN  =   ESC+"42m"
BBROWN  =   ESC+"43m"
BBLUE   =   ESC+"44m"
BPINK   =   ESC+"45m"
BCYAN   =   ESC+"46m"
BWHITE  =   ESC+"47m"


ProgNam = "Dragon's Hoard"
version = "960818b"
author  = "Darryl Perry"


DO BEGINING
DO MAINMENU
QUIT

PROCEDURE OPENPLYR
SELECT 1
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "HOARDPLR.DBF,HOARDEXP.DBF"
USE HOARDPLR INDEX HOARDEXP ALIAS PLYR
RETURN

PROCEDURE OPENGOODS
SELECT 2
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "EQUIPMNT.DBF"
USE EQUIPMNT ALIAS GOODS
RETURN

PROCEDURE OPENOTHR
SELECT 3
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "HOARDPLR.DBF,HOARDEXP.DBF"
USE HOARDPLR INDEX HOARDEXP ALIAS OTHR
RETURN

PROCEDURE OPENTEMP
SELECT 4
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "HOARDTMP.DBF"
USE HOARDTMP ALIAS TEMP
GO TOP
LOCATE FOR RECNO() = VAL(ULINE()) + 1
RETURN

PROCEDURE OPENSPEL
SELECT 5
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "SPELLS.DBF"
USE SPELLS ALIAS SPELLS
RETURN

PROCEDURE OPENMNST
SELECT 6
SET EXCLUSIVE OFF
ON ERROR DO FILEWAIT WITH "MONSTERS.DBF"
USE MONSTERS ALIAS MNST
RETURN

PROCEDURE OPENIGM
SELECT 7
USE IGM ALIAS IGM
RETURN


PROCEDURE NEWUSER
  REPLACE PLYR->LASTON WITH DATE()
  REPLACE PLYR->REALNAME WITH UNAME()
  REPLACE PLYR->MONIKER WITH UNAME()
  REPLACE PLYR->GOLDHAND WITH 350
  REPLACE PLYR->GOLDBANK WITH 0
  REPLACE PLYR->LEVEL WITH 1
  REPLACE PLYR->MAXHITPTS WITH ((PLYR->LEVEL + PLYR->LEVEL)) * PLYR->LEVEL * 10
  REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
  REPLACE PLYR->NUMWEAPON WITH 1
  REPLACE PLYR->WEAPON WITH "Hands"
  REPLACE PLYR->NUMARMOR WITH 1
  REPLACE PLYR->ARMOR WITH "Skin"
  REPLACE PLYR->EXPER WITH 100
  REPLACE PLYR->EXPER_NEED WITH PLYR->EXPER - (plyr->level * plyr->level * 500)
  REPLACE PLYR->ALIVE WITH .T.
  REPLACE PLYR->STRENGTH WITH 10
  REPLACE PLYR->AGILITY WITH 10
  REPLACE PLYR->WISDOM WITH 10
  REPLACE PLYR->INTELIGENCE WITH 10
  REPLACE PLYR->POWER WITH 20
  REPLACE PLYR->MAXPOWER WITH 20
  REPLACE PLYR->WIN_J WITH 0
  REPLACE PLYR->WIN_F WITH 0
  REPLACE PLYR->LOSES_J WITH 0
  REPLACE PLYR->LOSES_F WITH 0
  REPLACE PLYR->LEFT_J WITH 0
  REPLACE PLYR->LEFT_F WITH 0
  REPLACE PLYR->SKILL_J WITH PLYR->AGILITY + PLYR->STRENGTH + PLYR->WIN_J - PLYR->LOSES_J
  REPLACE PLYR->SKILL_F WITH PLYR->INTELIGENCE + PLYR->AGILITY + PLYR->WIN_F - PLYR->LOSES_F
  REPLACE PLYR->SPELLS WITH "0000000000000000000000000"
RETURN

PROCEDURE INTRO
	?   white
	?   "  Ahh....."
	?   "  Fresh Meat!!!"
	?
	?   "  Welcome, stranger, to the village of Hildenar.  I see that you"
	?   "  have come to seek your fame and fortune in the Warrior Realm! "
	?   "  Many have come before you, and lived to regret it.  More still"
	?   "  did NOT live to regret it.  "
	?
	?   "  Are you sure you wish to continue? "
RETURN

PROCEDURE RESETUSER
SELECT 1
IF PLYR->LASTON <> DATE()
	REPLACE PLYR->LASTON WITH DATE()
	REPLACE PLYR->ONTODAY WITH 1
ELSE
	REPLACE PLYR->ONTODAY WITH PLYR->ONTODAY + 1
	IF PLYR->ONTODAY > cfg_cpd
		?   
		?   "   Warrior, you must wait another moon."
		?
		?
		WAIT
		USE
		QUIT
	ENDIF
ENDIF
REPLACE PLYR->TOTALCALLS WITH PLYR->TOTALCALLS + 1
replace plyr->hitpoints with plyr->maxhitpts
REPLACE PLYR->POWER WITH PLYR->MAXPOWER
REPLACE PLYR->FIGHTSLEFT WITH CFG_TPD
REPLACE PLYR->LEFT_J WITH CFG_JPD
REPLACE PLYR->LEFT_F WITH CFG_FPD
GAMBLES=CFG_GPD

IF .NOT. PLYR->ALIVE
  REPLACE PLYR->ALIVE WITH .T.
  ? LRED + "  You have been killed!" 
  ? LRED + "  You have been resurrected!" 
  ?
  do pause
ENDIF


PROCEDURE VERYWELL
?
? LPINK + "  Very well.  Have a nice day!" 
DO PAUSE
RETURN

PROCEDURE FINDPLYR            
SELECT 1
GO TOP
LOCATE FOR PLYR->REALNAME=UNAME()
IF FOUND()
	FU_FLAG=.T.
ELSE
	FU_FLAG=.F.
ENDIF
RETURN



PROCEDURE BEGINING
CLEAR
DO INIT
if file(igmtxt)
	erase &igmtxt
	DO FINDPLYR
	IF FU_FLAG
		return
	else
		?
		?   "Error reinitializing " + prognam
		?   "Please inform your sysop."
		?
		do pause
		close all
		quit
	endif
endif

CLEAR
?
IF REGED
	?
	?
	DO CENTLINE WITH CFG_BBN + " is a REGISTERED Beta Site"
	DO CENTLINE WITH "Of " + prognam
	?
	DO CENTLINE WITH "Please Remember!"
	DO CENTLINE WITH "This is a BETA test version of " + prognam + "."
	?
	DO CENTLINE WITH "If you notice any bugs or errors, or would like"
	DO CENTLINE WITH "to make a suggestion, please inform your sysop."
	?
	?
	DO CENTLINE WITH "On With the Game!"
ELSE
	?
	?
	set color to g/n
	DO CENTLINE WITH "!! UNREGISTERED BETA VERSION !!"
	?
	set color to b+/n
	DO CENTLINE WITH "This is a BETA test copy of " + prognam + "!"
	?
	DO CENTLINE WITH "If you would like to become an official registered Beta Site,"
	DO CENTLINE WITH "Please refer to the BETASITE.DOC in this archive."
	DO CENTLINE WITH "Or Day Matrix Online at (408) 260-7989"
	DO CENTLINE WITH "And download the form."
	?
	set color to g/n
	DO CENTLINE WITH "As an Unregistered Beta Copy, this program will only"
	DO CENTLINE WITH "work in local mode.  "
	?
	?
	x=1
	do while x<=10000
		x=x+1
	enddo
ENDIF
DO PAUSE
CLEAR
set color to g/n
DO CENTLINE WITH "Welcome to " + ProgNam + version + "!" 
DO CENTLINE WITH "by Darryl Perry, 1993-1996" 
DO CENTLINE WITH "Compilation date: 08/14/96"
KEYS="BILQ"
DO WHILE .T.
	?   LRED
	IF UPRIV()>250
		?   "  (" + YELLOW + "C" + LRED+ ")onfigure " + Prognam
		KEYS=KEYS+"C"
	ENDIF
	?   "  (" + YELLOW + "B" + LRED+ ")egin Adventure"
	?   "  (" + YELLOW + "I" + LRED+ ")nformation"
	?   "  (" + YELLOW + "L" + LRED+ ")ist Warriors"
	?   "  (" + YELLOW + "Q" + LRED+ ")uit Game"
	?
	?   dgreen + "  Command: "
	DO ONEKEY WITH KEYS "Q"
	CH=ONECH
	? ""
	DO CASE
		CASE CH="B"
			DO FINDPLYR
			IF .NOT. FU_FLAG
				DO INTRO
				DO YESNO
				IF YN="Y"
					SELECT 1
					APPEND BLANK
					DO NEWUSER
					REPLACE PLYR->LASTON WITH DATE()
					REPLACE PLYR->ONTODAY WITH 1
					REPLACE PLYR->POWER WITH PLYR->MAXPOWER
					REPLACE PLYR->FIGHTSLEFT WITH CFG_TPD
					REPLACE PLYR->LEFT_J WITH CFG_JPD
					REPLACE PLYR->LEFT_F WITH CFG_FPD
					GAMBLES=CFG_GPD
					DO CHMON
				ELSE
					?
					?   "  This could be a descision that you regret for your entire pitiful life!"
					?
					QUIT
				ENDIF
			ENDIF
			DO RESETUSER
			DO CHECKLEVEL
			IF FILE("LOGONS.TXT")
				IF FDATE("LOGONS.TXT")<>DATE()
					ERASE LOGONS.TXT
				ENDIF
			ENDIF
			IF FILE("BATTLES.TXT")
				IF FDATE("BATTLES.TXT")<>DATE()
					ERASE BATTLES.TXT
				ENDIF
			ENDIF
			STR=YELLOW + TRIM(PLYR->MONIKER) + WHITE + REPLICATE('.',40-LEN(TRIM(PLYR->MONIKER))) + LBLUE + TIME() + ESC + "0m"
			DO W2MAIL WITH STR,"LOGONS.TXT"
			EXPLEV=.T.
			RETURN
		CASE CH="I"
			IF FILE ("CATACOMB.TXT")
				DO TYPETEXT WITH "CATACOMB.TXT"
			ELSE
				?
				?   "   File not found::[CATACOMB.TXT]"
				?
			ENDIF
		CASE CH="L"
			DO LISTUSER
		CASE CH="C"
			DO GODMENU
		CASE CH="Q"
			DO Q2BBS
	ENDCASE
ENDDO
RETURN


PROCEDURE MAINMENU
DO WHILE .T.
	IF EXPLEV
		DO TYPETEXT WITH "MAINMENU.SCR"
	ENDIF
	KEYLIST="ABDEFGHIJKLMOPQRSYX?"
	?   dgreen + "["+lgreen + prognam +dgreen "]["+lblue + "Main Street"+lblue+"]"+white+"[A/B/D/E/F/G/H/I/J/L/M/O/Q/R/S/Y/X/?]:"
	DO onekey WITH KEYLIST, "?"
	DO CASE
		CASE ONECH = 'A'
			DO TOWNSQR
		CASE ONECH = 'B'
			CLEAR
			?   yellow + "Battles for today"
			?   white
			IF FILE("BATTLES.TXT")
				DO TYPETEXT WITH "BATTLES.TXT"
			ELSE
				?   lpink + "  No battles yet today"
			ENDIF
			do pause
		CASE ONECH = 'D'
			IF PLYR->FIGHTSLEFT > 0
				DO DUNGEON
			else
				?   lpink
				?   "You have done enough fighting for today?"
				?   "Try again tommorrow."
				do pause
			ENDIF
		CASE ONECH = "F"
			DO JANDF WITH "F"
			DO CHECKLEVEL
		CASE ONECH = 'G'
			DO GUILD
		CASE ONECH = "H"
			CLEAR
			DO TYPETEXT WITH "HELP.TXT"
			DO PAUSE
		CASE ONECH = "J"
			DO JANDF WITH "J"
			DO CHECKLEVEL
		CASE ONECH = "K"
			DO TREASURY
		CASE ONECH = 'L'
			CLEAR
			DO LISTUSER
			DO PAUSE
		CASE ONECH = 'M'
			DO MISCEL
		CASE ONECH = 'O'
			CLEAR
			?   yellow + "Logons for today"
			?
			DO TYPETEXT WITH "LOGONS.TXT"
			DO PAUSE
		CASE ONECH = 'P'
			DO IGMMENU
		CASE ONECH = 'Q'
			DO Q2BBS
		CASE ONECH = 'R'
			DO READMAIL
		CASE ONECH = 'S'
			DO SENDMAIL
		CASE ONECH = 'T'
		CASE ONECH = 'X'
			IF EXPLEV
				EXPLEV=.F.
			ELSE
				EXPLEV=.T.
			ENDIF
		CASE ONECH = 'Y'
			DO VIEWSTAT
		CASE ONECH = '?'
			DO TYPETEXT WITH "MAINMENU.SCR"
	ENDCASE
ENDDO
RETURN

PROCEDURE GUILD
DO WHILE .T.
	DO TYPETEXT WITH "GUILD.SCR"
	?   "  Choice -)> "
	KEYLIST="AHTRMGQ"
	DO ONEKEY WITH KEYLIST,"Q"
	DO CASE
		CASE ONECH="A"
			DO ANNOUNCE
		CASE ONECH="H"
			DO HAPPEN
		CASE ONECH="T"
			CLEAR
			?   yellow + "  Warriors who made it to the top!" + white
			IF FILE("TOPLIST.TXT")
				DO TYPETEXT WITH "TOPLIST.TXT"
			ELSE
				?   dpink + "  This is a new game.  There are not top players yet."
			ENDIF
			DO PAUSE
		CASE ONECH="R"
			DO REROLL
		CASE ONECH="M"
			?
			?   "  Do you really wish to change your moniker?"
			DO YESNO
			IF YN="Y"
				?       
				?   "  By what name would you be called? " 
				ACCEPT "  : " TO STRNG
				IF LEN(STRNG) < 1
					?
					?   "  Try something a little more descriptive."
				ELSE
					SELECT 3
					GO TOP
					DO WHILE .NOT. EOF()
						fnd=.f.
						IF UPPER(STRNG)=UPPER(OTHR->MONIKER) .AND. OTHR->REALNAME <> PLYR->REALNAME
							?
							?   "  Sorry, but the REAL " + strng+ " may not wish you to use that name!"
							?
							fnd=.t.
						ENDIF
						SKIP
					ENDDO
					IF .NOT. FND
						?   "  So be it.. you will be know as Warrior " + STRNG
						SELECT 1
						REPLACE PLYR->MONIKER WITH STRNG
					ELSE
						?   "  Please try agian."
					ENDIF
				ENDIF
			ENDIF
			DO PAUSE
		CASE ONECH="G"
			DO BJACK
		CASE ONECH="Q"
			RETURN
	ENDCASE
ENDDO
RETURN

PROCEDURE TOWNSQR
DO WHILE .T.
	IF EXPLEV
		DO TYPETEXT WITH "TOWNSQAR.SCR"
		?   "  Choice -)> "
	ELSE
		?   "  Choice -)[A/C/S/F/Q]> "
	ENDIF
	KEYLIST="ACSFQ"
	DO ONEKEY WITH KEYLIST,"Q"
	DO CASE
		CASE ONECH="A"
			DO ARMORY
		CASE ONECH="C"
			DO CLERIC
		CASE ONECH="S"
			DO SPELLSTORE
		CASE ONECH="F"
			DO FINDWORK
		CASE ONECH="Q"
			RETURN
	ENDCASE
ENDDO
RETURN

PROCEDURE ARMORY
?   WHITE + "  <" + YELLOW + "B" + WHITE + ">uy, <" + YELLOW + "S" + WHITE + ">ell, <" + YELLOW + "L" + WHITE + ">ist -)> "
DO ONEKEY WITH "BSLQ","Q"
DO CASE
	CASE ONECH="B"
		DO BUYITEMS
	CASE ONECH="S"
		DO SELITEMS
	CASE ONECH="L"
		DO LISTITEMS WITH .F.
		DO PAUSE
	CASE ONECH="Q"
		RETURN
ENDCASE
RETURN

PROCEDURE BUYITEMS
	? WHITE +  "  You have " +YELLOW+ LTRIM(STR(PLYR->GOLDHAND)) +WHITE+ " Gold pieces on Hand"
	INPUT WHITE + "  Enter the number of the item you wish to buy: " TO RNUM
	IF RNUM=0
		RETURN
	ENDIF
	select 2
	GO TOP
	SKIP rnum - 1
	IF (GOODS->COST*100) > PLYR->GOLDHAND
		? LRED + "  You don't have that much Gold!"
		DO PAUSE
	ELSE
		? WHITE + "  Buy "+LBLUE+"["+YELLOW+"W"+LBLUE+"]"+WHITE+"eapon or "+LBLUE+"["+YELLOW+"A"+LBLUE+"]"+WHITE+"rmor"+LRED+": "
		DO ONEKEY WITH "WA" "?"
		IF ONECH="W"
			AW="WEAPON"
		ELSE
			AW="ARMOR"
		ENDIF
		? WHITE + "  Buy a " +YELLOW+ TRIM(GOODS->&AW) +WHITE+ " for " +DGREEN+ LTRIM(STR(GOODS->COST*100)) +WHITE+ " Gold pieces? "
		DO YESNO
		IF YN = "Y"
			REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND - (GOODS->COST*100)
			REPLACE PLYR->&AW WITH GOODS->&AW
			REPLACE PLYR->NUM&AW WITH GOODS->RANK
		ENDIF
	ENDIF
RETURN

PROCEDURE SELITEMS
? WHITE + "  Sell " +LBLUE+"["+YELLOW+"W"+LBLUE+"]"+WHITE+"eapon or "+LBLUE+"["+YELLOW+"A"+LBLUE+"]"+WHITE+"rmor"+LRED+": "
DO ONEKEY WITH "WA" "Q"
IF ONECH="W"
	AW="WEAPON"
ELSE
	IF ONECH="A"
		AW="ARMOR"
	ELSE
		RETURN
	ENDIF
ENDIF
IF PLYR->NUM&AW = 1
	? LRED + "  You don't have any to sell!" 
	DO PAUSE
ELSE       
	SELECT 2
	GO TOP
	SKIP PLYR->NUM&AW-1
	? WHITE + "  Sell Your " +YELLOW+ TRIM(PLYR->&AW) +WHITE+ " for " +DGREEN+ LTRIM(STR(INT((GOODS->COST*100)/2))) +WHITE+ "?"
	DO YESNO
	IF YN = "Y"
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + INT(((GOODS->COST*100)/2))
		GO TOP
		REPLACE PLYR->NUM&AW WITH GOODS->RANK
		REPLACE PLYR->&AW WITH GOODS->&AW
	ENDIF
ENDIF
RETURN



PROCEDURE CLERIC
CST=(PLYR->LEVEL * PLYR->LEVEL) + 10
DAM=PLYR->MAXHITPTS-PLYR->HITPOINTS
AFF=PLYR->GOLDHAND/CST
?   LGREEN
?
?   "  You enter a hut.  A cleric says it will"
?   "  cost " + LTRIM(STR(CST)) + " Gold to heal 1 point."
?   "  You have " + LTRIM(STR(DAM)) + " points to heal."
?   "  You can afford to heal " + LTRIM(STR(AFF)) + " points."
?
?
IF DAM*CST > AFF
	MAX=AFF
ELSE
	MAX=DAM
ENDIF
IF PLYR->GOLDHAND < CST
	?
	?   DPINK + "  You can't afford any."
	?
	DO PAUSE
	RETURN
ELSE
	INUM=-1
	DO WHILE INUM < 0 .OR. INUM > MAX
		INPUT WHITE + "  Heal how many: " TO INUM
		?
	ENDDO
	IF INUM = 0
		RETURN
	ELSE
		SELECT 1
		REPLACE PLYR->HITPOINTS WITH PLYR->HITPOINTS + INUM
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND - (INUM*CST)
	ENDIF
ENDIF
RETURN



PROCEDURE DUNGEON
DO WHILE .T.
	IF EXPLEV
		DO TYPETEXT WITH "DUNGEON.SCR"
		?   "  Choice -)> "
	ELSE
		?   "  Choice -)[D/P/F/Q]> "
	ENDIF
	KEYLIST="DPFQ"
	DO ONEKEY WITH KEYLIST,"Q"
	DO CASE
		CASE ONECH="D"
			DO CATACOMB WITH 20
			DO CHECKLEVEL
		CASE ONECH="P"
			DO CATACOMB WITH 1
			DO CHECKLEVEL
		CASE ONECH="F"
			DO FIGHTUSER
			DO CHECKLEVEL
		CASE ONECH="Q"
			RETURN
	ENDCASE
ENDDO
RETURN


PROCEDURE GODMENU
DO WHILE .T.
  CLEAR
  ? LRED
  DO CENTLINE WITH PROGNAM + VERSION + " Sysop Menu"
  ? 
  ? "   "+DGREEN+"["+LGREEN+"G"+DGREEN+"]"+YELLOW+"ame Config      "
  ? "   "+DGREEN+"["+LGREEN+"I"+DGREEN+"]"+YELLOW+"GM Config       "
  ? "   "+DGREEN+"["+LGREEN+"E"+DGREEN+"]"+YELLOW+"dit Players     "
  ? "   "+DGREEN+"["+LGREEN+"L"+DGREEN+"]"+YELLOW+"ist Players     "
  ? "   "+DGREEN+"["+LGREEN+"P"+DGREEN+"]"+YELLOW+"ack Database    "
  ? "   "+DGREEN+"["+LGREEN+"Q"+DGREEN+"]"+YELLOW+"uit to Main Menu"
  ?
  ? LRED + "  [" + DGREEN + "Sysop Menu" +LRED+"]"+LBLUE+": "
  DO ONEKEY WITH "QIEPLG" "?"
  DO CASE
	CASE ONECH = 'I'
		DO IGMSETUP
	CASE ONECH = 'L'
		SELECT 3
		GO TOP 
		DO TYPETEXT WITH "PLYRLIST.SCR"
		I=1
		DO WHILE .NOT. EOF()
			if deleted()
				strn=lred
			else
				strn=dgreen
			endif
			STRN=strn + "  " + OTHR->MONIKER + "  " + OTHR->REALNAME
			IF OTHR->ALIVE
				STRN=STRN + "  ALIVE   "
			ELSE
				STRN=STRN + "  DEAD    "
			ENDIF
			STRN=STRN + STR(OTHR->EXPER)
			? STRN
			IF I>20
				DO PAUSE
				I=1
			ENDIF
			SKIP
			I=I+1
		ENDDO
		DO PAUSE
	CASE ONECH = 'E'
		SELECT 2
		GO TOP
		DO WHILE .NOT. EOF()
			DO HLSO
			IF ABS(THISDAY-THATDAY)>14
				DELETE
			ENDIF
			SKIP
		ENDDO
		DO PLYREDIT
	CASE ONECH = 'P'
		DO PACKIT
	CASE ONECH = 'G'
		DO GAMECFG
	CASE ONECH = 'Q'
		RETURN
  ENDCASE
ENDDO
RETURN

PROCEDURE LISTIGM
SELECT 7
GO TOP
I=1
?   "No. D Display                                  Opt Data"
?   "--- - ---------------------------------------- ----------------------------"
DO WHILE .NOT. EOF()
	IF DELETED()
		?   LRED
	ELSE
		?   YELLOW
	ENDIF
	??  RIGHT(STR(I),3) + " " 
	if igm->ok2show
		??  "Y "
	else
		??  "N "
	endif
	??  LEFT(IGM->DISPLAY,40) + " " + LEFT(IGM->ODATA,30)
	SKIP
	I=I+1
ENDDO
RETURN

PROCEDURE IGMSETUP
CLEAR
?   "Inter-Game Module Setup for " + prognam
do listigm
do while .t.
	?
	?   WHITE + "[IGM Setup]:(A)dd, (M)odify, (D)elete, (L)ist, (Q)uit: "
	do onekey with "AMDLQ","L"
	ch5=onech
	do case
		case ch5="A"
			SELECT 7
			APPEND BLANK
			DO EDITIGM
		case ch5="M"
			SELECT 7
			RC=RECCOUNT()
			IF RC > 0
				ACCEPT "Modify which? [1-"+LTRIM(STR(RC))+"]:" TO ISTR
				IF LEN(ISTR)>0
					INUM=VAL(ISTR)
					IF INUM <= RC .AND. INUM > 0
						GO TOP
						SKIP INUM - 1
						DO EDITIGM
					ELSE
						?   "That is not a valid entry."
					ENDIF
				else
					?   "That is not a valid entry."
				ENDIF
			ELSE
				APPEND BLANK
				DO EDITIGM
			ENDIF
		case ch5="D"
			SELECT 7
			RC=RECCOUNT()
			IF RC > 0
				ACCEPT "Delete which? [1-"+LTRIM(STR(RC))+"]:" TO ISTR
				IF LEN(ISTR)>0
					INUM=VAL(ISTR)
					IF INUM <= RC .AND. INUM > 0
						GO TOP
						SKIP INUM - 1
						IF DELETED()
							RECALL
						ELSE
							DELETE
						ENDIF
					ELSE
						?   "That is not a valid entry."
					ENDIF
				else
					?   "That is not a valid entry."
				ENDIF
			ENDIF
		case ch5="L"
			DO LISTIGM
		case ch5="Q"
			RETURN
	endcase
enddo
RETURN

PROCEDURE EDITIGM
DO WHILE .T.
	clear
	?   "[A] IGM Display Text  : " + left(IGM->DISPLAY,55)
	?   "[B] IGM Opt Data Text : " + left(IGM->ODATA,55)
	?   "[C] Display this entry: "
	if igm->ok2show
		??  "Yes"
	else
		??  "No"
	endif
	?
	?   "[Q] Quit"
	?
	?   "Command: "
	do onekey with "ABCQ","Q"
	DO CASE
		CASE ONECH="A"
			?
			?   "Enter new display text:"
			ACCEPT ":" to istr
			if len(istr)>0
				select 7
				replace igm->display with istr
			endif
		CASE ONECH="B"
			?
			?   "Enter new Opt DAta text:"
			ACCEPT ":" to istr
			if len(istr)>0
				select 7
				replace igm->odata with upper(istr)
			endif
		CASE ONECH="C"
			IF IGM->OK2SHOW
				replace IGM->OK2SHOW with .F.
			ELSE
				replace IGM->OK2SHOW with .T.
			ENDIF
		CASE ONECH="Q"
			RETURN
	ENDCASE
enddo
RETURN

PROCEDURE PLYREDIT
SELECT 3
GO TOP
DO WHILE .T.
	CLEAR
	IF .NOT. DELETED()
		?   White + "    Real Name    : " + LGREEN + OTHR->REALNAME + "         "
	ELSE
		?   White + "    Real Name    : " + LGREEN + OTHR->REALNAME + "*DELETED*"
	ENDIF
	?   WHITE + "[A] Name         : " + LGREEN + TRIM(OTHR->MONIKER) + SPACE(24-LEN(TRIM(OTHR->MONIKER)))
	??  WHITE + "[B] Level        : " + LGREEN + LTRIM(STR(OTHR->LEVEL))
	IF CFG_CPD=0
		?   WHITE + "    Calls Left   : " + LGREEN + "Unlimited" + SPACE(24 - LEN("Unlimited"))
	ELSE
		?   WHITE + "    Calls Left   : " + LGREEN + LTRIM(STR(CFG_CPD-OTHR->ONTODAY)) + SPACE(24 - LEN(LTRIM(STR(CFG_CPD-OTHR->ONTODAY))))
	ENDIF
	??  WHITE + "[C] Experience   : " + LGREEN + LTRIM(STR(OTHR->EXPER))
	?   WHITE + "    Total Calls  : " + LGREEN + LTRIM(STR(OTHR->TOTALCALLS)) + SPACE(24-LEN(LTRIM(STR(OTHR->TOTALCALLS))))
	??  WHITE + "    Exp needed   : " + LGREEN + LTRIM(STR(OTHR->EXPER_NEEDED))
	?
	?   WHITE + "[D] Strength     : " + LGREEN + LTRIM(STR(OTHR->STRENGTH)) + SPACE(24-LEN(LTRIM(STR(OTHR->STRENGTH))))
	??  WHITE + "[E] Gold in hand : " + LGREEN + LTRIM(STR(OTHR->GOLDHAND))
	?   WHITE + "[F] Agility      : " + LGREEN + LTRIM(STR(OTHR->AGILITY)) + SPACE(24-LEN(LTRIM(STR(OTHR->AGILITY))))
	??  WHITE + "[G] Gold in bank : " + LGREEN + LTRIM(STR(OTHR->GOLDBANK))
	?   WHITE + "[H] Wisdom       : " + LGREEN + LTRIM(STR(OTHR->WISDOM)) + SPACE(24-LEN(LTRIM(STR(OTHR->WISDOM))))
	??  WHITE + "[I] Power        : " + LGREEN + LTRIM(STR(OTHR->POWER)) + WHITE + "/" + LGREEN +LTRIM(STR(OTHR->MAXPOWER))
	?   WHITE + "[J] Intelligence : " + LGREEN + LTRIM(STR(OTHR->INTELIGENCE)) + SPACE(24-LEN(LTRIM(STR(OTHR->INTELIGENCE))))
	??  WHITE + "[K] Hit points   : " + LGREEN + LTRIM(STR(OTHR->HITPOINTS)) + WHITE + "/" + LGREEN + LTRIM(STR(OTHR->MAXHITPTS))
	?
	?   WHITE + "[L] Joust wins   : " + LGREEN + LTRIM(STR(OTHR->WIN_J))   + SPACE(24-LEN(LTRIM(STR(OTHR->WIN_J))))
	??  WHITE + "[M] Fence wins   : " + LGREEN + LTRIM(STR(OTHR->WIN_F))
	?   WHITE + "[N] Joust losses : " + LGREEN + LTRIM(STR(OTHR->LOSES_J)) + SPACE(24-LEN(LTRIM(STR(OTHR->LOSES_J))))
	??  WHITE + "[O] Fence losses : " + LGREEN + LTRIM(STR(OTHR->LOSES_F))
	?   WHITE + "    Joust skill  : " + LGREEN + LTRIM(STR(OTHR->SKILL_J)) + SPACE(24-LEN(LTRIM(STR(OTHR->SKILL_J))))
	??  WHITE + "    Fence skill  : " + LGREEN + LTRIM(STR(OTHR->SKILL_F))
	?
	?   WHITE + "[P] Fights left  : " + LGREEN + LTRIM(STR(OTHR->FIGHTSLEFT)) + SPACE(24-LEN(LTRIM(STR(OTHR->FIGHTSLEFT))))
	??  WHITE + "[Q] Gambles left : " + LGREEN + LTRIM(STR(CFG_GPD-GAMBLES))
	?   WHITE + "[R] Jousts left  : " + LGREEN + LTRIM(STR(OTHR->LEFT_J)) + SPACE(24-LEN(LTRIM(STR(OTHR->LEFT_J))))
	??  WHITE + "[S] Weapon       : " + LGREEN + "#" + LTRIM(STR(OTHR->NUMWEAPON)) + " " + TRIM(OTHR->WEAPON)
	?   WHITE + "[T] Fences left  : " + LGREEN + LTRIM(STR(OTHR->LEFT_F)) + SPACE(24-LEN(LTRIM(STR(OTHR->LEFT_F))))
	??  WHITE + "[U] Armor        : " + LGREEN + "#" + LTRIM(STR(OTHR->NUMARMOR)) + " " + TRIM(OTHR->ARMOR)
	?
	?
	?   " [=Next, ]=Prev, X=Delete, 0=Quit: >"
	SELECT 3
	DO ONEKEY WITH "ABCDEFGHIJKLMNOPQRSTUVWXYZ[]0","+"
	DO CASE
		CASE ONECH="A"
			?   "Current Moniker: " + othr->moniker
			accept "New Moniker: " to str1
			if len(STR1)>0
				REPLACE OTHR->MONIKER WITH STR1
			ENDIF
		CASE ONECH="B"
			?   "Current Level: " + STR(OTHR->MONIKER)
			INPUT "New Level [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->LEVEL WITH NUM1
			ENDIF
		CASE ONECH="C"
			?   "Current Experience: " + STR(OTHR->EXPER)
			INPUT "New Experience [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->EXPER WITH NUM1
			ENDIF
		CASE ONECH="D"
			?   "Current Strength: " + STR(OTHR->STRENGTH)
			INPUT "New Strength [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->STRENGTH WITH NUM1
			ENDIF
		CASE ONECH="E"
			?   "Current Gold in Hand: " + STR(OTHR->GOLDHAND)
			INPUT "New Gold in Hand [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->GOLDHAND WITH NUM1
			ENDIF
		CASE ONECH="F"
			?   "Current Agility: " + STR(OTHR->AGILITY)
			INPUT "New Agility [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->AGILITY WITH NUM1
			ENDIF
		CASE ONECH="G"
			?   "Current Gold in  Bank: " + STR(OTHR->GOLDBANK)
			INPUT "New Gold in Bank [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->GOLDBANK WITH NUM1
			ENDIF
		CASE ONECH="H"
			?   "Current Wisdom: " + STR(OTHR->WISDOM)
			INPUT "New Wisdom [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->WISDOM WITH NUM1
			ENDIF
		CASE ONECH="I"
			?   "Current Power: " + STR(OTHR->POWER)
			INPUT "New Power [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->POWER WITH NUM1
			ENDIF
		CASE ONECH="J"
			?   "Current Intelligence: " + STR(OTHR->INTELIGENCE)
			INPUT "New Intelligence [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->INTELIGENCE WITH NUM1
			ENDIF
		CASE ONECH="K"
			?   "Current HitPoints: " + STR(OTHR->HITPOINTS)
			INPUT "New HitPoints [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->HITPOINTS WITH NUM1
			ENDIF
		CASE ONECH="L"
			?   "Current Joust Wins: " + STR(OTHR->WIN_J)
			INPUT "New Joust Wins [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->WIN_J WITH NUM1
			ENDIF
		CASE ONECH="M"
			?   "Current Fence Wins: " + STR(OTHR->WIN_F)
			INPUT "New Fence Wins [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->WIN_F WITH NUM1
			ENDIF
		CASE ONECH="N"
			?   "Current Joust Losses: " + STR(OTHR->LOSES_J)
			INPUT "New Joust Losses [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->LOSES_J WITH NUM1
			ENDIF
		CASE ONECH="O"
			?   "Current Fence Losses: " + STR(OTHR->LOSES_F)
			INPUT "New Fence Losses [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->LOSES_F WITH NUM1
			ENDIF
		CASE ONECH="P"
			?   "Current Fights Left: " + STR(OTHR->FIGHTSLEFT)
			INPUT "New Fights Left [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->FIGHTSLEFT WITH NUM1
			ENDIF
		CASE ONECH="Q"
			?   "Current Gambles Left: " + STR(OTHR->GAMBLES)
			INPUT "New Gambles Left [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->GAMBLES WITH NUM1
			ENDIF
		CASE ONECH="R"
			?   "Current Jousts Left: " + STR(OTHR->LEFT_J)
			INPUT "New Jousts Left [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->LEFT_J WITH NUM1
			ENDIF
		CASE ONECH="S"
		CASE ONECH="T"
			?   "Current Fences Left: " + STR(OTHR->LEFT_F)
			INPUT "New Fences Left [1-9999999999]: " to num1
			IF NUM1 >=1 .AND. NUM1 <=9999999999
				REPLACE OTHR->LEFT_F WITH NUM1
			ENDIF
		CASE ONECH="U"
		CASE ONECH="X"
			IF DELETED()
				RECALL
			ELSE
				DELETE
			ENDIF
		CASE ONECH="["
			IF BOF()
				GO BOTTOM
			ELSE
				SKIP - 1
			ENDIF
		CASE ONECH="]"
			IF EOF()
				GO TOP
			ELSE
				SKIP
			ENDIF
		CASE ONECH="0"
			RETURN
	ENDCASE
ENDDO
RETURN



PROCEDURE INDATAS
PARAMETERS PTXT,OFIELD
?   ":" + &OFIELD + ":"
?   "  Current " + trim(ptxt) + ": " + OTHR->&ofield
ACCEPT  "  New " + trim(ptxt) + ": " + OTHR->&ofield to instr1
if instr1 <> ""
	replace OTHR->&ofield with instr1
endif
RETURN

PROCEDURE INDATAI
PARAMETERS PTXT,OFIELD,LO,HI
?   "  Current " + TRIM(PTXT) + ": " + STR(OTHR->&OFIELD)
INPUT   "  New " + TRIM(PTXT) + "["+LTRIM(STR(LO))+"-"+LTRIM(STR(HI))+"]: " TO IND1
IF IND1 <= HI .AND. IND1 >= LO
	REPLACE OTHR->&OFIELD WITH IND1
ELSE
	?
	?   "  That is value is not valid."
	DO PAUSE
ENDIF
RETURN





PROCEDURE TREASURY
SELECT 1
IF PLYR->GOLDBANK < 1
	REPLACE PLYR->GOLDBANK WITH 0
ENDIF
IF PLYR->GOLDHAND < 1
	REPLACE PLYR->GOLDHAND WITH 0
ENDIF
?
?   DGREEN + "  Treasury"
?
?   WHITE + "  <" + YELLOW + "D" + WHITE + ">eposit, or <" + YELLOW + "W" + WHITE + ">ithdraw -)> "
DO ONEKEY WITH "WDQ","Q"
DO CASE
	CASE ONECH="W"
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + PLYR->GOLDBANK
		REPLACE PLYR->GOLDBANK WITH 0
		?
		?
		?   DPINK + "  You now have " + LTRIM(STR(PLYR->GOLDHAND)) + " in your hands"
	CASE ONECH="D"
		REPLACE PLYR->GOLDBANK WITH PLYR->GOLDBANK + PLYR->GOLDHAND
		REPLACE PLYR->GOLDHAND WITH 0
		?
		?
		?   DPINK + "  You now have " + LTRIM(STR(PLYR->GOLDBANK)) + " in the bank"
	CASE ONECH="Q"
		RETURN
ENDCASE
DO PAUSE
RETURN



PROCEDURE SPELLSTORE
?   WHITE + "  <" + YELLOW + "B" + WHITE + ">uy, <" + YELLOW + "L" + WHITE + ">ist -)> "
DO ONEKEY WITH "BLQ","Q"
DO CASE
	CASE ONECH="B"
		DO BUYSPELLS
	CASE ONECH="L"
		DO LISTSPELLS
		DO PAUSE
	CASE ONECH="Q"
		RETURN
ENDCASE
RETURN

PROCEDURE BUYSPELLS
	select 5
	? WHITE +  "  You have " +YELLOW+ LTRIM(STR(PLYR->GOLDHAND)) +WHITE+ " Gold pieces on Hand"
	ch = " "
	ACCEPT WHITE + "  Enter the number of the item you wish to buy: " TO ch
	rnum = VAL(ch)
	IF LEN(ch)=0
		RETURN
	ENDIF
	GO TOP
	SKIP rnum - 1
	IF SPELLS->COST > PLYR->GOLDHAND
		? LRED + "  You don't have that much Gold!"
		DO PAUSE
	ELSE
		MAXBUY=INT(PLYR->GOLDHAND/SPELLS->COST)
		STR1=PLYR->SPELLS
		A1=VAL(SUBSTR(STR1,RNUM,1))
		A2=9-A1
		IF A2>MAXBUY
			A2=MAXBUY
		ENDIF
		IF A2 > 0
			CH=" "
			accept WHITE + "  Buy how many?  (Max="+ltrim(str(a2))+"): " TO CH
			rnum1=VAL(CH)
			IF RNUM1 <=A2 .AND. RNUM1 > 0
				select 1
				REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND - (SPELLS->COST * RNUM1)
				STR1=STUFF(STR1,RNUM,1,LTRIM(STR(A1+RNUM1)))
				REPLACE PLYR->SPELLS WITH STR1
			ENDIF
		ELSE
			?   LRED + "  You may not have any more at this time!"
		ENDIF
	ENDIF
RETURN


PROCEDURE LISTSPELLS
SELECT 5
GO TOP
stnum=""
accept dgreen + "  Start at # " to stnum
stnum1=val(stnum)
if stnum1 < 26 .and. stnum1 > 0
	skip stnum1 - 1
endif
?   lgreen + "  ## "+dpink+"Spell                             Price"
?   dgreen + "  (-----------------------------------------)"
OK=.T.
DO WHILE .NOT. EOF() .and. spells->cost <= plyr->goldhand
	?   white + RIGHT(STR(SPELLS->RANK),4) + " " + lgreen + SPELLS->SPELLNAME + dpink + STR(SPELLS->COST)
	SKIP    
ENDDO
do pause
RETURN


PROCEDURE FIGHTUSER
IF PLYR->FIGHTSLEFT < 1
	? LPINK + "  You are tired.. Try again tommorrow." 
	DO PAUSE
	RETURN
ENDIF
OK = .T.
SELECT 3
DO BATLIST WITH "Fight","B"
IF FOFLAG 
	IF PLYR->REALNAME <> OTHR->REALNAME 
		IF OTHR->ALIVE
			DO O2TEMP
			?
			?   "   " + LRED + OTHR->MONIKER
			?
			?   WHITE + "   His HitPoints : " + YELLOW + LJUST(STR(OTHR->HITPOINTS))
			??  WHITE + "Your HitPoints : " + YELLOW + LJUST(STR(PLYR->HITPOINTS))
			?   WHITE + "   His Weapon #  : " + YELLOW + LJUST(STR(OTHR->NUMWEAPON))
			??  WHITE + "Your Weapon #  : " + YELLOW + LJUST(STR(PLYR->NUMWEAPON))
			?   WHITE + "   His Armor #   : " + YELLOW + LJUST(STR(OTHR->NUMARMOR))
			??  WHITE + "Your Armor #   : " + YELLOW + LJUST(STR(PLYR->NUMARMOR))
			?            
			?   DGREEN + "  Fight This Warrior?" 
			DO YESNO
			IF YN="N"
				DO VERYWELL
				RETURN
			ELSE
				DO CATAFIGHT WITH 0
				DO CHECKPLR WITH 0
			ENDIF
		ELSE
			?   LRED + "  Why don't you pick on somebody with more life in his body!"
			DO PAUSE
			RETURN
		ENDIF
	ELSE
		?   "  You decide that it would be benificial NOT to fight yourself today."
		DO PAUSE
		RETURN
	ENDIF
ELSE
	RETURN
ENDIF
RETURN


PROCEDURE FIGHT
PARAMETER NRUT
EXTRA=0
DO WHILE PLYR->ALIVE .AND. TEMP->ALIVE
	TURN=NRUT
	IF TURN=0
		
			DO HILO WITH 1*TEMP->NUMWEAPON,(8*TEMP->NUMWEAPON)+ABS(TEMP->STRENGTH-PLYR->AGILITY)
			DAMAGE=RND_RET
		
		? YELLOW + "  It strikes you for " + LBLUE + LTRIM(STR(DAMAGE)) + YELLOW + " damage!" 
		REPLACE PLYR->HITPOINTS WITH PLYR->HITPOINTS - DAMAGE
		IF PLYR->HITPOINTS < 1
			IF EXTRA<>256
				SELECT 1
				REPLACE PLYR->ALIVE WITH .F.
				REPLACE PLYR->HITPOINTS WITH 0
				?   LRED
				?   "  It kills you!"
				?   "  It takes your gold!"
				?
				?   dgreen + "  You have " + LTRIM(STR(CFG_CPD-(PLYR->ONTODAY))) + " more plays left today!"
				?
				DO PAUSE
			ELSE
				?
				?   "  You have been killed!!"
				?   "  You have been resurected!!"
				SELECT 1
				REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
				EXTRA=0
			ENDIF
		ENDIF
		NRUT=1
	ELSE
		OK=.F.
		DO WHILE .NOT. OK
			EXTRA=0
			?
			? WHITE + "  <F>ight, <C>ast, <S>tats: "
			DO ONEKEY WITH "FCS" "F"
			FCS=ONECH
			DO CASE
				CASE FCS="S"
					DO VIEWSTATS
				CASE FCS="C"
					DO CAST WITH "O"
					OK=.T.
				OTHERWISE
					OK=.T.
			ENDCASE
		ENDDO
		
		DO HILO WITH 1*PLYR->NUMWEAPON,(8*PLYR->NUMWEAPON)+ABS(PLYR->STRENGTH-TEMP->AGILITY)
		DAMAGE=RND_RET+EXTRA

		?
		? DGREEN + "  You strike IT for " + LRED + LTRIM(STR(DAMAGE)) + DGREEN + " damage!" 
		SELECT 4 
		REPLACE TEMP->HITPOINTS WITH TEMP->HITPOINTS - DAMAGE
		IF TEMP->HITPOINTS < 1
			SELECT 4
			REPLACE TEMP->HITPOINTS WITH 0
			REPLACE TEMP->ALIVE WITH .F.
		ENDIF
		NRUT=0
	ENDIF
ENDDO
RETURN


PROCEDURE CATACOMBS
PARAMETERS TIMES
IF PLYR->FIGHTSLEFT < 1
	? LRED
	? "  You are in no condition to fight today.." 
	? "  Come back again tommorrow" 
	DO PAUSE
	RETURN
ELSE
	IF TIMES=20
		? DGREEN + "  This uses all your fights for today..." 
		? YELLOW + "  Continue anyway?"
		DO YESNO
		IF YN="N"
			RETURN
		ENDIF
		room=-1
		DO WHILE room < 0 .OR. room > 220
			INPUT WHITE + "  Enter which room? [1-220]: >" TO room
		ENDDO
		IF ROOM=0
			RETURN
		ELSE
			SELECT 1
			REPLACE PLYR->FIGHTSLEFT WITH 0
		ENDIF
	ELSE
		LVL=-1
		DO WHILE LVL < 0 .OR. LVL > 12
			INPUT WHITE + "  Enter level of creature to fight ? [1-12]: >" TO LVL
		ENDDO
		IF LVL=0
			RETURN
		ELSE
			SELECT 1
			REPLACE PLYR->FIGHTSLEFT WITH PLYR->FIGHTSLEFT - 1
			DO HILO WITH (LVL*20)-19,LVL*20
			ROOM=RND_RET+1
		ENDIF
	ENDIF
ENDIF
III=room
LUCKY=0
CURFIGHT=1
IF TIMES=20
	DO PRELUCK
ENDIF
DO WHILE room < (III + TIMES)
	? LRED +  "  Entering room #" + LTRIM(STR(room)) + XCOLOR
	IF TIMES=20
		LUCKY=0
		DO LUCKYDAY
		IF LUCKY=1
			RETURN
		ENDIF
		IF LUCKY=2
			DO PAUSE
		ENDIF
		CURFIGHT=CURFIGHT+1
	ENDIF
	IF LUCKY=0
		DO CATAFIGHT WITH room 
		DO CHECKPLR WITH ROOM
		IF TIMES > 1
			OK=.T.
			DO WHILE OK
				?
				? WHITE + "  <"+YELLOW+"M"+WHITE+">ove, <"+YELLOW+"C"+WHITE+">ast, <"+YELLOW+"S"+WHITE+">tats: "
				DO ONEKEY WITH "MCS" "?"
				DO CASE
					CASE ONECH = "M"
						?
						? LRED +  "  Moving to room #" + LTRIM(STR(room+1)) + XCOLOR
						OK=.F.
					CASE ONECH = "C"
						DO CAST WITH "D"
						IF EXTRA=255
							RETURN
						ENDIF
						OK=.T.
					CASE ONECH = "S"
						DO VIEWSTATS
						OK=.T.
				ENDCASE
			ENDDO
		ENDIF
	ENDIF
	room=room+1
ENDDO
DO PAUSE
RETURN

PROCEDURE CHECKPLR
PARAMETERS ROOM
IF PLYR->ALIVE
	?   
	?   LBLUE +  "  You killed IT!    "
	?
	IF ROOM=0
		STR=TRIM(PLYR->MONIKER) + " attacked and killed " + TRIM(OTHR->MONIKER)
		DO W2MAIL WITH STR, "BATTLES.TXT"
	ENDIF
	SELECT 1
	IF TEMP->NUMWEAPON > PLYR->NUMWEAPON
		?   LRED + "  You take ITS weapon!"
		SELECT 1
		REPLACE PLYR->NUMWEAPON WITH TEMP->NUMWEAPON
		REPLACE PLYR->WEAPON WITH TEMP->WEAPON
		IF ROOM=0
			SELECT 3
			REPLACE OTHR->NUMWEAPON WITH 1
			REPLACE OTHR->WEAPON WITH "Hands"
		ENDIF
	ENDIF
	IF TEMP->NUMARMOR > PLYR->NUMARMOR
		?   LGREEN + "  You take ITS armor!"
		SELECT 1
		REPLACE PLYR->NUMARMOR WITH TEMP->NUMARMOR
		REPLACE PLYR->ARMOR WITH TEMP->ARMOR
		IF ROOM=0
			SELECT 3
			REPLACE OTHR->NUMARMOR WITH 1
			REPLACE OTHR->ARMOR WITH "Skin"
		ENDIF
	ENDIF
	IF ROOM=0
		SCOR1 = INT(PLYR->EXPER/6)
		SELECT 1 
		REPLACE PLYR->EXPER WITH PLYR->EXPER + SCOR1
		SCOR3 = INT(PLYR->EXPER/12)
		SELECT 3
		IF (OTHR->EXPER - SCOR3) < 0
			REPLACE OTHR->EXPER WITH 0
		ELSE
			REPLACE OTHR->EXPER WITH OTHR->EXPER - SCOR3
		ENDIF
		REPLACE OTHR->ALIVE WITH .F.
	ELSE
		?   DGREEN + "  You get " + LTRIM(STR(TEMP->EXPER)) + " experience points!"
		?   DGREEN + "  You get " + ltrim(str(temp->goldhand)) + " gold pieces"
		SELECT 1
		REPLACE PLYR->EXPER WITH PLYR->EXPER + TEMP->EXPER
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + TEMP->GOLDHAND
	ENDIF
ELSE
	IF ROOM=0
		STR=TRIM(PLYR->MONIKER) + " died while attacking " + TRIM(OTHR->MONIKER)
		DO W2MAIL WITH STR, "BATTLES.TXT"
	ENDIF
	SELECT 1
	REPLACE PLYR->GOLDHAND WITH 0
	IF ROOM = 0
		SCOR1 = INT(PLYR->EXPER/6)
		SELECT 1 
		IF (PLYR->EXPER - SCOR1) < 0
			REPLACE PLYR->EXPER WITH 0
		ELSE
			REPLACE PLYR->EXPER WITH PLYR->EXPER - SCOR1
		ENDIF
		SCOR3 = INT(PLYR->EXPER/12)
		SELECT 3
		REPLACE OTHR->EXPER WITH OTHR->EXPER + SCOR3
		IF PLYR->NUMWEAPON > TEMP->NUMWEAPON
			?
			?   LRED + "  He takes your weapon!"
			SELECT 3
			REPLACE OTHR->NUMWEAPON WITH PLYR->NUMWEAPON
			REPLACE OTHR->WEAPON WITH PLYR->WEAPON
			SELECT 1
			REPLACE PLYR->NUMWEAPON WITH 1
			REPLACE PLYR->WEAPON WITH "Hands"
		ENDIF
		IF PLYR->NUMARMOR > TEMP->NUMARMOR
			?
			?   LBLUE + "  He takes your armor!"
			SELECT 3
			REPLACE OTHR->NUMARMOR WITH PLYR->NUMARMOR
			REPLACE OTHR->ARMOR WITH PLYR->ARMOR
			SELECT 1
			REPLACE PLYR->NUMWEAPON WITH 1
			REPLACE PLYR->WEAPON WITH "Skin"
		ENDIF
	ENDIF
	QUIT
ENDIF
RETURN



PROCEDURE O2TEMP
SELECT 4
REPLACE TEMP->MONIKER WITH OTHR->MONIKER
REPLACE TEMP->ALIVE WITH OTHR->ALIVE
REPLACE TEMP->LEVEL WITH OTHR->LEVEL
REPLACE TEMP->STRENGTH WITH OTHR->STRENGTH
REPLACE TEMP->HITPOINTS WITH OTHR->HITPOINTS
REPLACE TEMP->GOLDHAND WITH OTHR->GOLDHAND
REPLACE TEMP->EXPER WITH OTHR->EXPER
REPLACE TEMP->NUMWEAPON WITH OTHR->NUMWEAPON
REPLACE TEMP->WEAPON WITH OTHR->WEAPON
REPLACE TEMP->NUMARMOR WITH OTHR->NUMARMOR
REPLACE TEMP->ARMOR WITH OTHR->ARMOR
RETURN

PROCEDURE MAKEIGM
IF FILE("NEWDBF.DBF")
	ERASE NEWDBF.DBF
ENDIF
CREATE NEWDBF
USE NEWDBF
APPEND BLANK
REPLACE FIELD_NAME WITH "DISPLAY", FIELD_TYPE WITH "C", FIELD_LEN WITH 64
APPEND BLANK
REPLACE FIELD_NAME WITH "ODATA", FIELD_TYPE WITH "C", FIELD_LEN WITH 64
APPEND BLANK
REPLACE FIELD_NAME WITH "OK2SHOW", FIELD_TYPE WITH "L", FIELD_LEN WITH 1
CREATE IGM FROM NEWDBF
ERASE NEWDBF.DBF
RETURN



PROCEDURE MAKECRE
PARAMETERS room
SELECT 4
REPLACE TEMP->LEVEL WITH int(room/21)+1
DO HILO WITH TEMP->LEVEL,TEMP->LEVEL*(TEMP->LEVEL*8)+(TEMP->LEVEL*2)
REPLACE TEMP->AGILITY WITH RND_RET
DO HILO WITH TEMP->LEVEL,TEMP->LEVEL*(TEMP->LEVEL*8)+(TEMP->LEVEL*2)
REPLACE TEMP->STRENGTH WITH RND_RET
DO HILO WITH TEMP->LEVEL+TEMP->STRENGTH,(TEMP->LEVEL*8)+TEMP->STRENGTH
REPLACE TEMP->HITPOINTS WITH RND_RET
REPLACE TEMP->EXPER WITH RND_RET * 2
DO HILO WITH (TEMP->level*TEMP->level)*100,(TEMP->level*TEMP->level)*200
REPLACE TEMP->GOLDHAND WITH RND_RET
DO HILO WITH (TEMP->LEVEL*2)-1,(TEMP->LEVEL*2)+1
REPLACE TEMP->NUMWEAPON WITH RND_RET
DO HILO WITH (TEMP->LEVEL*2)-1,(TEMP->LEVEL*2)+1
REPLACE TEMP->NUMARMOR WITH RND_RET
SELECT 2
GO TOP
SKIP TEMP->NUMWEAPON - 1 
SELECT 4
REPLACE TEMP->WEAPON WITH GOODS->WEAPON
SELECT 2
GO TOP
SKIP TEMP->NUMARMOR - 1
SELECT 4
REPLACE TEMP->ARMOR WITH GOODS->ARMOR
SELECT 6
DO HILO WITH 1,101
GO TOP
SKIP RND_RET-1
SELECT 4
REPLACE TEMP->MONIKER WITH MNST->MONNAME
RETURN

PROCEDURE CATAFIGHT
PARAMETERS room
SELECT 4
REPLACE TEMP->ALIVE WITH .T.
DO WHILE PLYR->ALIVE .AND. TEMP->ALIVE
	IF ROOM > 0
		DO MAKECRE WITH room
		?
		? LPINK + "  You stumble across a viscious " + YELLOW + TRIM(TEMP->MONIKER) + LPINK + "!"  
	ELSE
		DO O2TEMP
	ENDIF
	IF PLYR->AGILITY >= TEMP->AGILITY
		? LBLUE + "  You get first attack!"
		X=1
	ELSE
		? LBLUE + "  You defend yourself against attack!"
		X=0
	ENDIF
	DO FIGHT WITH X
ENDDO
RETURN





PROCEDURE LISTUSER
? DGREEN + "                                 " + prognam + version
? YELLOW + "                                   By " + author
? LPINK  + "  Warrior Status" 
? DGREEN + "  Warrior                 Status     Level     Score" 
? LBLUE  + "  -------------------------------------------------------" 
SELECT 3
GO TOP
n = 1
DO WHILE .NOT. EOF()
	? "  " + LGREEN + OTHR->MONIKER
	IF OTHR->ALIVE
		?? LBLUE + "    ALIVE"
	ELSE
		?? LRED  + "    DEAD " 
	ENDIF
	?? WHITE + STR(OTHR->LEVEL) + DGREEN + STR(OTHR->EXPER) 
	IF N > UMORE()
		DO PAUSE
		N=1
	ENDIF
	n = n + 1
	SKIP
ENDDO
? ""
DO PAUSE
RETURN

PROCEDURE VIEWSTAT
CLEAR
?   WHITE + "Name         : " + LGREEN + TRIM(PLYR->MONIKER) + SPACE(30-LEN(TRIM(PLYR->MONIKER)))
??  WHITE + "Level        : " + LGREEN + LTRIM(STR(PLYR->LEVEL))
IF CFG_CPD<1
	?   WHITE + "Calls Left   : " + LGREEN + "Unlimited" + SPACE(30 - LEN("Unlimited"))
ELSE
	?   WHITE + "Calls Left   : " + LGREEN + LTRIM(STR(CFG_CPD-OTHR->ONTODAY)) + SPACE(30 - LEN(LTRIM(STR(CFG_CPD-OTHR->ONTODAY))))
ENDIF
??  WHITE + "Experience   : " + LGREEN + LTRIM(STR(PLYR->EXPER))
?   WHITE + "Total Calls  : " + LGREEN + LTRIM(STR(PLYR->TOTALCALLS)) + SPACE(30-LEN(LTRIM(STR(PLYR->TOTALCALLS))))
??  WHITE + "Exp needed   : " + LGREEN + LTRIM(STR(PLYR->EXPER_NEEDED))
?
?   WHITE + "Strength     : " + LGREEN + LTRIM(STR(PLYR->STRENGTH)) + SPACE(30-LEN(LTRIM(STR(PLYR->STRENGTH))))
??  WHITE + "Gold in hand : " + LGREEN + LTRIM(STR(PLYR->GOLDHAND))
?   WHITE + "Agility      : " + LGREEN + LTRIM(STR(PLYR->AGILITY)) + SPACE(30-LEN(LTRIM(STR(PLYR->AGILITY))))
??  WHITE + "Gold in bank : " + LGREEN + LTRIM(STR(PLYR->GOLDBANK))
?   WHITE + "Wisdom       : " + LGREEN + LTRIM(STR(PLYR->WISDOM)) + SPACE(30-LEN(LTRIM(STR(PLYR->WISDOM))))
??  WHITE + "Power        : " + LGREEN + LTRIM(STR(PLYR->POWER)) + WHITE + "/" + LGREEN +LTRIM(STR(PLYR->MAXPOWER))
?   WHITE + "Intelligence : " + LGREEN + LTRIM(STR(PLYR->INTELIGENCE)) + SPACE(30-LEN(LTRIM(STR(PLYR->INTELIGENCE))))
??  WHITE + "Hit points   : " + LGREEN + LTRIM(STR(PLYR->HITPOINTS)) + WHITE + "/" + LGREEN + LTRIM(STR(PLYR->MAXHITPTS))
?
?   WHITE + "Joust wins   : " + LGREEN + LTRIM(STR(PLYR->WIN_J))   + SPACE(30-LEN(LTRIM(STR(PLYR->WIN_J))))
??  WHITE + "Fence wins   : " + LGREEN + LTRIM(STR(PLYR->WIN_F))
?   WHITE + "Joust losses : " + LGREEN + LTRIM(STR(PLYR->LOSES_J)) + SPACE(30-LEN(LTRIM(STR(PLYR->LOSES_J))))
??  WHITE + "Fence losses : " + LGREEN + LTRIM(STR(PLYR->LOSES_F))
?   WHITE + "Joust skill  : " + LGREEN + LTRIM(STR(PLYR->SKILL_J)) + SPACE(30-LEN(LTRIM(STR(PLYR->SKILL_J))))
??  WHITE + "Fence skill  : " + LGREEN + LTRIM(STR(PLYR->SKILL_F))
?
?   WHITE + "Fights left  : " + LGREEN + LTRIM(STR(PLYR->FIGHTSLEFT)) + SPACE(30-LEN(LTRIM(STR(PLYR->FIGHTSLEFT))))
??  WHITE + "Gambles left : " + LGREEN + LTRIM(STR(CFG_GPD-GAMBLES))
?   WHITE + "Jousts left  : " + LGREEN + LTRIM(STR(PLYR->LEFT_J)) + SPACE(30-LEN(LTRIM(STR(PLYR->LEFT_J))))
??  WHITE + "Weapon       : " + LGREEN + "#" + LTRIM(STR(PLYR->NUMWEAPON)) + " " + TRIM(PLYR->WEAPON)
?   WHITE + "Fences left  : " + LGREEN + LTRIM(STR(PLYR->LEFT_F)) + SPACE(30-LEN(LTRIM(STR(PLYR->LEFT_F))))
??  WHITE + "Armor        : " + LGREEN + "#" + LTRIM(STR(PLYR->NUMARMOR)) + " " + TRIM(PLYR->ARMOR)
?
DO PAUSE
CLEAR
DO SHOWSPELLS
DO PAUSE
RETURN

PROCEDURE SHOWSPELLS
CLEAR
SELECT 5
STR1=PLYR->SPELLS
I=1
?   dgreen + "  Spells List"
?
DO WHILE I<=25
	A1=VAL(SUBSTR(STR1,I,1))
	IF A1 > 0
		GO TOP
		SKIP I-1
		?   white + right(str(i),4) + " " + lgreen + SPELLS->SPELLNAME + white + "(" + lgreen + ltrim(str(a1)) + white + ")     "+lgreen+"Power Needed "+white+"("+lgreen+ltrim(str(SPELLS->POWERNEED))+white +")"
	ENDIF
	I=I+1
ENDDO
RETURN

PROCEDURE LISTITEMS
PARAMETERS SYSFLAG
select 2
ACCEPT DGREEN + "  Start at what #: " + WHITE TO ISTR
IF LEN(ISTR) < 0 .OR. VAL(ISTR) < 1 .OR. VAL(ISTR) > reccount()
	RETURN
ENDIF
	
? DGREEN + "  ### Weapon                        Armor                              Price" 
? LPINK  + "  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"
SELECT 2
GO TOP
I = VAL(ISTR)
SKIP I - 1
DO WHILE I <= reccount() .and. ((goods->cost*100) <= plyr->goldhand)
	? DGREEN + RIGHT(STR(I),5) + " " 
	IF PLYR->NUMWEAPON = I
		?? LPINK
	ELSE
		?? DGREEN 
	ENDIF
	?? GOODS->WEAPON 
	IF PLYR->NUMARMOR = I
		?? LPINK 
	ELSE
		?? DGREEN
	ENDIF
	?? GOODS->ARMOR + LBLUE + STR(GOODS->COST*100)
	IF MOD(I,20)=0
		DO PAUSE
	ENDIF
	I=I+1
	SKIP
ENDDO
? 
RETURN


PROCEDURE CHECKLEVEL
SELECT 1
EXPNTOP=(PLYR->LEVEL * PLYR->LEVEL*500)
REPLACE PLYR->EXPER_NEED WITH EXPNTOP - PLYR->EXPER
DO WHILE PLYR->EXPER_NEED < 0
	REPLACE PLYR->LEVEL WITH PLYR->LEVEL+1
	IF PLYR->LEVEL > 20
		STR1=TRIM(PLYR->MONIKER) + REPLICATE('.',40-LEN(TRIM(PLYR->MONIKER))) + DTOC(PLYR->LASTON)
		DO W2MAIL WITH STR1,"TOPLIST.TXT"
		CLEAR
		?
		?   "  Congratulations!!!"
		?
		?   "  You are the most hearty of warriors.  You are the first in this"
		?   "  game to make it to level 13"
		? 
		?   "  The Game will now be reset, and your name will be added to the"
		?   "  top players of the game!"
		?
		DO W2MAIL WITH "Sorry!","NEWGAME.TXT"
		DO W2MAIL WITH "","NEWGAME.TXT"
		DO W2MAIL WITH "The current game has been won by "+trim(plyr->moniker),"NEWGAME.TXT"
		DO W2MAIL WITH "","NEWGAME.TXT"
		DO W2MAIL WITH "A new game will start tommorrow.","NEWGAME.TXT"
		DO W2MAIL WITH "","NEWGAME.TXT"
		DO PAUSE
		QUIT
	ENDIF
	EXPNTOP=((PLYR->LEVEL * PLYR->LEVEL)*500)
	REPLACE PLYR->EXPER_NEED WITH EXPNTOP - PLYR->EXPER 
	?
	?   LRED + "  Level " + DRED + LTRIM(STR(PLYR->LEVEL))
	?   
	?   LGREEN + "  You kneel befor the King."
	?
	?   WHITE+"  1"+YELLOW+") "+WHITE+"Strength"
	?   WHITE+"  2"+YELLOW+") "+WHITE+"Agility"
	?   WHITE+"  3"+YELLOW+") "+WHITE+"Wisdom"
	?   WHITE+"  4"+YELLOW+") "+WHITE+"Intelligence"
	?
	?   DPINK + "  Choose: "
	DO ONEKEY WITH "1234","1"
	CH=ONECH
	DO CASE
		CASE CH="1"
			THESTAT="STRENGTH"
		CASE CH="2"
			THESTAT="AGILITY"
		CASE CH="3"
			THESTAT="WISDOM"
		CASE CH="4"
			THESTAT="INTELIGENCE"
	ENDCASE
	DO HILO WITH PLYR->LEVEL,(PLYR->LEVEL)*8
	STATVAL=RND_RET
	DO HILO WITH PLYR->LEVEL,(PLYR->LEVEL)*8
	HPVAL=RND_RET
	DO HILO WITH PLYR->LEVEL,(PLYR->LEVEL)*8
	PWVAL=RND_RET
	?
	?   "  Stat +" + LTRIM(STR(STATVAL))
	?   "  Hit Points +" + LTRIM(STR(HPVAL))
	?   "  Power +" + LTRIM(STR(PWVAL))
	?   "  All stats +2"
	?    
	SELECT 1
	REPLACE PLYR->&THESTAT WITH PLYR->&THESTAT + STATVAL
	REPLACE PLYR->STRENGTH WITH PLYR->STRENGTH + 2
	REPLACE PLYR->AGILITY WITH PLYR->AGILITY + 2
	REPLACE PLYR->WISDOM WITH PLYR->WISDOM + 2
	REPLACE PLYR->INTELIGENCE WITH PLYR->INTELIGENCE + 2
	REPLACE PLYR->MAXHITPTS WITH PLYR->MAXHITPTS + HPVAL
	REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
	REPLACE PLYR->MAXPOWER WITH PLYR->MAXPOWER + PWVAL
	REPLACE PLYR->POWER WITH PLYR->MAXPOWER
	REPLACE PLYR->SKILL_J WITH PLYR->AGILITY + PLYR->STRENGTH + PLYR->WIN_J - PLYR->LOSES_J
	REPLACE PLYR->SKILL_F WITH PLYR->AGILITY + PLYR->INTELIGENCE + PLYR->WIN_F - PLYR->LOSES_F
	DO PAUSE
	ENDDO
RETURN



PROCEDURE JANDF
PARAMETERS JF
DO CASE
  CASE JF = "J"
	jfstr="Joust"
  CASE JF = "F"
	jfstr="Fence"
ENDCASE
?
IF PLYR->LEFT_&JF < 1
	? "  You are tired...come back and " + TRIM(JFSTR) + " tommorrow."
	DO PAUSE
	RETURN
ENDIF
DO BATLIST WITH TRIM(jfSTR),JF
IF FOFLAG .AND. PLYR->REALNAME <> OTHR->REALNAME
	DO JFSTAT WITH jfSTR,JF
	IF OKTOJF
		DO JFUSER WITH JFSTR,JF
	ENDIF
ENDIF
RETURN


PROCEDURE JFSTAT
PARAMETERS JFSTR,JF
?
?   "   " + LRED + OTHR->MONIKER
?
?   WHITE + "   His "  + JFSTR + "ing wins : " + YELLOW + LJUST(STR(OTHR->WIN_&JF))
??  WHITE + "Your " + JFSTR + "ing wins : " + YELLOW + LJUST(STR(PLYR->WIN_&JF))
?   WHITE + "   His "  + JFSTR + "ing loses: " + YELLOW + LJUST(STR(OTHR->LOSES_&JF))
??  WHITE + "Your " + JFSTR + "ing loses: " + YELLOW + LJUST(STR(PLYR->LOSES_&JF))
?   WHITE + "   His "  + JFSTR + "ing skill: " + YELLOW + LJUST(STR(OTHR->SKILL_&JF))
??  WHITE + "Your " + JFSTR + "ing skill: " + YELLOW + LJUST(STR(PLYR->SKILL_&JF))
OKTOJF=.T.
IF OTHR->LEVEL > PLYR->LEVEL
	IF OTHR->LEVEL -  PLYR->LEVEL > 6
		?
		? LRED + "   That's suicidal!"
		OKTOJF=.F.
		do pause
	ENDIF
ELSE
	IF abs(PLYR->LEVEL - OTHR->LEVEL) > 6
		?
		? LRED + "   Pick on someone your own size!"
		OKTOJF=.F.
		DO PAUSE
	ENDIF
ENDIF
RETURN


PROCEDURE JFUSER
PARAMETERS JFSTR,JF
?
? "   " + JFSTR + " this warrior? "
DO YESNO
IF YN="Y"
	WINS=0
	LOSES=0
	DO WHILE WINS < 3 .AND. LOSES < 3
		?
		? WHITE + "  <"+LGREEN+jf+WHITE+">"+substr(jfstr,2,4) + " <"+LGREEN+"R"+WHITE+">un: "
		DO ONEKEY WITH "RFJ" JF
		IF ONECH="R"
			LOSES=3
		ELSE
			DO HILO WITH 1 ,PLYR->SKILL_&JF + OTHR->SKILL_&JF
			IF RND_RET < PLYR->SKILL_&JF
				WINS=WINS+1
				? LBLUE + "  ---* " + LCYAN + "THUNK " + LBLUE + "*---   " + WHITE + "You won this round!!!"
			ELSE
				LOSES=LOSES+1
				? LRED  + "  ---# " + LCYAN + "TWANG " + LRED  + "#---   " + WHITE + "You lost this round!!!"
			ENDIF
		ENDIF
	ENDDO
	IF WINS = 3
		?
		? YELLOW + "  You won this match!"
		XXX=PLYR->LEVEL*60
		? WHITE + "  You win " + LGREEN+ LTRIM(STR(XXX)) + WHITE + " gold pieces"
		SELECT 1
		REPLACE PLYR->WIN_&JF WITH PLYR->WIN_&JF + 1
		IF JF="F"
			REPLACE PLYR->SKILL_&JF WITH PLYR->INTELIGENCE + PLYR->AGILITY + PLYR->WIN_&JF - PLYR->LOSES_&JF
		ELSE
			REPLACE PLYR->SKILL_&JF WITH PLYR->STRENGTH + PLYR->AGILITY + PLYR->WIN_&JF - PLYR->LOSES_&JF
		ENDIF
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + XXX
		IF MOD(PLYR->WIN_&JF,20)=0 .AND. PLYR->SKILL_&JF > 0
			?   dgreen + "  +5 All Stats"
			REPLACE PLYR->STRENGTH WITH PLYR->STRENGTH + 5
			REPLACE PLYR->AGILITY WITH PLYR->AGILITY + 5
			REPLACE PLYR->WISDOM WITH PLYR->WISDOM + 5
			REPLACE PLYR->INTELIGENCE WITH PLYR->INTELIGENCE + 5
			REPLACE PLYR->SKILL_J WITH PLYR->STRENGTH+PLYR->AGILITY+PLYR->WIN_J-PLYR->LOSES_J
			REPLACE PLYR->SKILL_F WITH PLYR->INTELIGENCE+PLYR->AGILITY+PLYR->WIN_F-PLYR->LOSES_F
		ENDIF
		IF PLYR->SKILL_&JF < 1
			?   DGREEN + "  Resetting your " +JFSTR+ "ing stats"
			REPLACE PLYR->WIN_&JF WITH 0
			REPLACE PLYR->LOSES_&JF WITH 0
			IF JF="F"
				REPLACE PLYR->SKILL_&JF WITH PLYR->AGILITY + PLYR->INTELIGENCE + PLYR->WIN_F - PLYR-LOSES_F
			ELSE
				REPLACE PLYR->SKILL_&JF WITH PLYR->AGILITY + PLYR->STRENGTH + PLYR->WIN_J - PLYR-LOSES_J
			ENDIF
		ENDIF
		SELECT 3
		REPLACE OTHR->LOSES_&JF WITH OTHR->LOSES_&JF + 1
		IF JF="F"
			REPLACE OTHR->SKILL_&JF WITH OTHR->AGILITY + OTHR->INTELIGENCE + OTHR->WIN_F - OTHR->LOSES_F
		ELSE
			REPLACE OTHR->SKILL_&JF WITH OTHR->AGILITY + OTHR->STRENGTH + OTHR->WIN_J - OTHR->LOSES_J
		ENDIF
		IF OTHR->SKILL_&JF < 1
			?   DGREEN + "  Resetting opponents "+JFSTR+"ing stats"
			REPLACE OTHR->LOSES_&JF WITH 0
			REPLACE OTHR->WIN_&JF WITH 0
			IF JF="F"
				REPLACE OTHR->SKILL_&JF WITH OTHR->AGILITY + OTHR->INTELIGENCE + OTHR->WIN_&JF - OTHR->LOSES_&JF
			ELSE
				REPLACE OTHR->SKILL_&JF WITH OTHR->AGILITY + OTHR->STRENGTH + OTHR->WIN_&JF - OTHR->LOSES_&JF
			ENDIF
		ENDIF
	ENDIF
	IF LOSES = 3
		SELECT 1
		REPLACE PLYR->LOSES_&JF WITH PLYR->LOSES_&JF + 1
		IF JF="F"
			REPLACE PLYR->SKILL_F WITH PLYR->INTELIGENCE + PLYR->AGILITY - PLYR->LOSES_F + PLYR->WIN_F
		ELSE
			REPLACE PLYR->SKILL_J WITH PLYR->STRENGTH + PLYR->AGILITY - PLYR->LOSES_J + PLYR->WIN_J
		ENDIF
		IF PLYR->SKILL_&JF < 1
			REPLACE PLYR->LOSES_&JF WITH 0
			REPLACE PLYR->WIN_&JF WITH 0
			IF JF="F"
				REPLACE PLYR->SKILL_&JF WITH PLYR->INTELIGENCE + PLYR->AGILITY - PLYR->LOSES_&JF + PLYR->WIN_&JF
			ELSE
				REPLACE PLYR->SKILL_&JF WITH PLYR->STRENGTH + PLYR->AGILITY - PLYR->LOSES_&JF + PLYR->WIN_&JF
			ENDIF
		ENDIF
		SELECT 3
		REPLACE OTHR->WIN_&JF WITH OTHR->WIN_&JF + 1
		IF JF="F"
			REPLACE OTHR->SKILL_&JF WITH OTHR->INTELIGENCE + OTHR->AGILITY - OTHR->LOSES_&JF + OTHR->WIN_&JF
		ELSE
			REPLACE OTHR->SKILL_&JF WITH OTHR->STRENGTH + OTHR->AGILITY - OTHR->LOSES_&JF + OTHR->WIN_&JF
		ENDIF
	ENDIF
	SELECT 1
	REPLACE PLYR->LEFT_&JF WITH PLYR->LEFT_&JF - 1
ENDIF
DO PAUSE
RETURN

PROCEDURE BATLIST
PARAMETERS TFITE,JF
DO FINDOTHER WITH TFITE
RETURN



PROCEDURE CAST
PARAMETERS OD
OK=.T.
DO WHILE OK
	IF OD="O"
		?
		ACCEPT WHITE + "  Cast which spell? ([2,3,5,6,8-11,13,19,23], (S)tats ): " TO SPNUM
	ELSE
		?
		ACCEPT WHITE + "  Cast which spell? ([1,4,7,12,20,21,22,24,25], (S)tats ): " TO SPNUM
	ENDIF
	IF ISALPHA(SPNUM)
		IF UPPER(TRIM(LTRIM(SPNUM))) = "S"
			DO VIEWSTATS
		ENDIF
	ELSE
		SPNUM1=VAL(SPNUM)
		IF SPNUM1 > 0 .AND. SPNUM1 < 26
			SELECT 5
			GO TOP
			SKIP SPNUM1-1
			IF VAL(SUBSTR(PLYR->SPELLS,SPNUM1,1))>0
				IF SPELLS->POWERNEED <= PLYR->POWER
					IF TRIM(OD)=TRIM(SPELLS->OFFDEF)
						DO CASE
							CASE SPNUM1=1
								SELECT 1
								REPLACE PLYR->HITPOINTS WITH PLYR->HITPOINTS + INT(PLYR->MAXHITPTS/4)
								IF PLYR->HITPOINTS > PLYR->MAXHITPTS
									REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
								ENDIF
								?   "  Zap!"
								?   "  You cured 1/4 of your wounds!"
							CASE SPNUM1=2
								EXTRA=int(plyr->strength/10)
							CASE SPNUM1=3
								EXTRA=int(plyr->strength/10)
							CASE SPNUM1=4 
								SELECT 1
								REPLACE PLYR->HITPOINTS WITH PLYR->HITPOINTS + INT(PLYR->MAXHITPTS/2)
								IF PLYR->HITPOINTS > PLYR->MAXHITPTS
									REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
								ENDIF
							CASE SPNUM1=5
								EXTRA=15
							CASE SPNUM1=6
								EXTRA=20
							CASE SPNUM1=7
								EXTRA=255
							CASE SPNUM1=8
								EXTRA=30
							CASE SPNUM1=9
								EXTRA=35
							CASE SPNUM1=10
								EXTRA=40
							CASE SPNUM1=11
								EXTRA=45
							CASE SPNUM1=12
								SELECT 1
								REPLACE PLYR->HITPOINTS WITH PLYR->HITPOINTS + INT(PLYR->MAXHITPTS/2)
								IF PLYR->HITPOINTS > PLYR->MAXHITPTS
									REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
								ENDIF
								?   "  Zap!"
								?   "  You cured half your wounds!"
							CASE SPNUM1=13
								EXTRA=50
							CASE SPNUM1=14
								EXTRA=55
							CASE SPNUM1=15
								EXTRA=60
							CASE SPNUM1=16
								EXTRA=65
							CASE SPNUM1=17
								EXTRA=70
							CASE SPNUM1=18
								EXTRA=TEMP->HITPOINTS + 1
							CASE SPNUM1=19
								EXTRA=75
							CASE SPNUM1=20
							CASE SPNUM1=21
								SELECT 1
								REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
							CASE SPNUM1=22
								SELECT 1
								REPLACE PLYR->MAXHITPTS WITH INT(PLYR->MAXHITPTS * 1.25)
								REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
							CASE SPNUM1=23
								EXTRA=TEMP->HITPOINTS + 1
							CASE SPNUM1=24
								SELECT 1
								REPLACE PLYR->MAXHITPTS WITH INT(PLYR->MAXHITPTS * 1.5)
								REPLACE PLYR->HITPOINTS WITH PLYR->MAXHITPTS
							CASE SPNUM1=25
								EXTRA=256
						ENDCASE
						SELECT 1
						REPLACE PLYR->POWER WITH PLYR->POWER - SPELLS->POWERNEED
						STR1=PLYR->SPELLS
						A1=VAL(SUBSTR(STR1,SPNUM1,1))-1
						STR1=STUFF(STR1,SPNUM1,1,LTRIM(STR(A1)))
						REPLACE PLYR->SPELLS WITH STR1
					ELSE
						IF OD="D"
							ODS=" defensive"
						ELSE
							ODS="n offensive"
						ENDIF
						?   lred + "  That is a" + ods + " spell, and may not be used at this time."
						?   yellow + "  Try a different spell? "
						DO YESNO
						IF YN="N"
							EXTRA=0
							OK=.F.
						ENDIF
					ENDIF
				ELSE
					?   LRED + "  You don't have that much power!"
					?   LGREEN + "  Try another spell? "
					DO YESNO
					IF YN="N"
						EXTRA=0
						OK=.T.
					ENDIF
				ENDIF
			ELSE
				?   lred + "  You don't have any " + TRIM(spells->spellname) + " spells."
				?   yellow + "  Try a different spell? "
				DO YESNO
				IF YN="N"
					EXTRA=0
					OK=.F.
				ENDIF
			ENDIF
			EXTRA=0
			OK=.F.
		ENDIF
	ENDIF
ENDDO
RETURN


PROCEDURE Q2BBS
?
? LRED + "  Quit Game?" 
DO YESNO
IF YN="Y"
	CLOSE ALL
	QUIT
ELSE
	RETURN
ENDIF
RETURN


PROCEDURE FILEWAIT
PARAMETERS FILENAME
IF ERROR() = 108                        && File in use by another?
	? "Waiting for access...["+ FILENAME +"]"
	A=INKEY(1)                          && delay 1 second
	RETRY                               && Try to open the file again
ENDIF
? "Try another time..["+ FILENAME +"]"
HALT MESSAGE()
RETURN

PROCEDURE ONEKEY
PARAMETERS CHOICES, DEF
DO WHILE .T.
	ONECH=UPPER(CHR(INKEY(0)))
	IF ONECH=CHR(13)
		ONECH=DEF
		?? WHITE + ONECH
		RETURN
	ELSE
		IF ONECH $ CHOICES
			?? WHITE + ONECH
			RETURN
		ENDIF
	ENDIF
ENDDO
RETURN


PROCEDURE YESNO
?? LRED + " (Y/N)  :"
DO ONEKEY WITH "YN" "Y"
YN=ONECH
RETURN

PROCEDURE CENTLINE 
PARAMETERS STR
S1=(UWIDTH()-LEN(STR))/2
IF .NOT. UANSI()
	? ""
ENDIF
? SPACE(S1) + STR + ESC +"0K"
RETURN

PROCEDURE C2
PARAMETERS CLR,STR
S1=(UWIDTH()-LEN(STR))/2
IF .NOT. UANSI()
	? ""
ENDIF
? CLR + SPACE(S1) + STR + ESC +"0K"
RETURN

PROCEDURE RANDOMIZE
  AXSEED = SECONDS()*100
  AYSEED = 1
RETURN

PROCEDURE RANDOM
PARAMETERS LIMIT
IF LIMIT<=0
	LIMIT=1
ENDIF
AXSEED = MOD(40014*AXSEED,2147483563)
AYSEED = MOD(40692*AYSEED,2147483399)
RAND_RESULT = MOD(AXSEED + AYSEED,2147483563)/(2147483563/limit)
RETURN

PROCEDURE HILO
PARAMETERS LO,HI
DO RANDOM WITH (HI-LO)
RND_RET=RAND_RESULT+LO
RETURN

PROCEDURE CL2
PARAMETERS COLR,STR1
?   SPACE(40-INT(LEN(STR1)/2)) + COLR + STR1
RETURN

PROCEDURE PAUSE
DO CL2 WITH LBLUE,"[Styke a Keye]"
A=INKEY(0)
RETURN


PROCEDURE INIT
IGMTXT="IGM"+ULINE()+".TXT"
IF FILE("CONFIG.MEM")
	RESTORE FROM "CONFIG.MEM" ADDITIVE
ELSE
	CFG_CPD=0
	CFG_JPD=10
	CFG_FPD=10
	CFG_TPD=25
	CFG_GPD=10
	CFG_RNM=0
	CFG_RKY=""
	CFG_MSGBASE="EMAIL"
	CFG_BBN="No Name BBS"
	CFG_SYN="Sysop"
	CFG_RNAM=CFG_SYN
	SAVE TO "CONFIG.MEM" ALL LIKE CFG_*
	REGED=.F.
ENDIF
IF LEN(TRIM(CFG_RKY))>=16
	DO DEKRYPT
ELSE
	REGED=.F.
ENDIF
IF .NOT. REGED .AND. VAL(ULINE()) > 0
	CLEAR
	?
	DO CENTLINE WITH "This is an"
	DO CENTLINE WITH "Unregistered Beta Test Version"
	DO CENTLINE WITH "of"
	DO CENTLINE WITH PROGNAM + VERSION
	DO PAUSE
ENDIF
GAMBLES=CFG_GPD
IF FILE("NEWGAME.TXT")
	IF FDATE("NEWGAME.TXT")=DATE()
		CLEAR
		DO TYPETEXT WITH "NEWGAME.TXT"
		DO PAUSE
		QUIT
	ELSE
		ERASE NEWGAME.TXT
		ERASE HOARDPLR.DBF
	ENDIF
ENDIF
IF .NOT. FILE("HOARDTMP.DBF")
	DO CREATEDBF
	USE
	CREATE "HOARDTMP.DBF" FROM NEWSTRUC
	ERASE NEWSTRUC.DBF
	I=1
	DO WHILE I <= 65
		APPEND BLANK
		I=I+1
	ENDDO
ENDIF

IF .NOT. FILE("HOARDPLR.DBF")
	DO CREATEDBF
	USE
	CREATE "HOARDPLR.DBF" FROM NEWSTRUC
	ERASE NEWSTRUC.DBF
	SET EXCLUSIVE ON
	USE HOARDPLR
	INDEX ON DESCEND(EXPER) TO HOARDEXP
	SET EXCLUSIVE OFF
ENDIF
IF FILE("TODAY.TXT")
	IF FDATE("TODAY.TXT") <> DATE()
		IF FILE("YESTERDY.TXT")
			ERASE YESTERDY.TXT
		ENDIF
		RENAME TODAY.TXT TO YESTERDY.TXT
	ENDIF
ENDIF
IF .NOT. FILE("IGM.DBF")
	DO MAKEIGM
ENDIF
DO OPENPLYR
DO OPENOTHR
DO OPENGOODS
DO OPENTEMP
DO OPENSPEL
DO OPENMNST
DO OPENIGM
DO RANDOMIZE
RETURN


PROCEDURE TYPETEXT
PARAMETERS TFILE
FOPEN FPTR &TFILE 10 2048
I=1
DO WHILE .T.
	A=INKEY()
	IF MOD(I,UMORE())=0 
		DO PAUSE
	ENDIF
	FLREAD FPTR SIZE REC
	IF SIZE > 0
		? CRTRIM(REC)
	ELSE
		FCLOSE FPTR
		RETURN
	ENDIF
	I=I+1
ENDDO
FCLOSE FPTR
RETURN


PROCEDURE W2MAIL
PARAMETERS STR, FNAME
FNAME=FNAME+".TXT"
IF .NOT. FILE(FNAME)
	FCREATE FPTR &FNAME 3
	FCLOSE FPTR
ENDIF
FOPEN FPTR &FNAME 11 2048
FLWRITE FPTR SIZE "  " + STR + CHR(13) + CHR(10)
FCLOSE FPTR
RETURN



PROCEDURE FINDOTHER
PARAMETERS JFSTR
DONE=.F.
DO WHILE .NOT. DONE
	FOFLAG=.F.
	?
	?  DGREEN + "  Enter the full or PARTIAL name of the Warrior to " + JFSTR
	?   "  or LIST to list all warriors."
	ACCEPT  "  NAME: " + WHITE TO STRING
	IF LEN(STRING)=0
		RETURN
	ENDIF
	IF UPPER(STRING)="LIST"
		DO LISTUSER
	ELSE
		STRING=UPPER(STRING)
		SELECT 3
		GO TOP  
		DO WHILE .NOT. EOF()
			IF STRING $ UPPER(OTHR->MONIKER)
				? 
				? LBLUE + "  You mean " + TRIM(OTHR->MONIKER) + "?"
				DO YESNO
				IF YN="Y"
					FOFLAG=.T.
					RETURN
				ENDIF
			ENDIF
			SKIP
		ENDDO
	ENDIF
ENDDO
RETURN




PROCEDURE CREATEDBF
CREATE NEWSTRUC
USE NEWSTRUC
APPEND BLANK
REPLACE FIELD_NAME WITH "REALNAME", FIELD_TYPE WITH "C", FIELD_LEN WITH 20
APPEND BLANK
REPLACE FIELD_NAME WITH "MONIKER", FIELD_TYPE WITH "C", FIELD_LEN WITH 20
APPEND BLANK
REPLACE FIELD_NAME WITH "ALIVE", FIELD_TYPE WITH "L", FIELD_LEN WITH 1
APPEND BLANK
REPLACE FIELD_NAME WITH "LASTON", FIELD_TYPE WITH "D", FIELD_LEN WITH 8
APPEND BLANK
REPLACE FIELD_NAME WITH "ONTODAY", FIELD_TYPE WITH "N", FIELD_LEN WITH 1
APPEND BLANK
REPLACE FIELD_NAME WITH "TOTALCALLS", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "LEVEL", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "STRENGTH", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "AGILITY", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "WISDOM", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "POWER", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "MAXPOWER", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "INTELIGENCE", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "HITPOINTS", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "MAXHITPTS", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "SKILL_J", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "WIN_J", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "LOSES_J", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "LEFT_J", FIELD_TYPE WITH "N", FIELD_LEN WITH 2
APPEND BLANK
REPLACE FIELD_NAME WITH "SKILL_F", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "WIN_F", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "LOSES_F", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "LEFT_F", FIELD_TYPE WITH "N", FIELD_LEN WITH 2
APPEND BLANK
REPLACE FIELD_NAME WITH "FIGHTSLEFT", FIELD_TYPE WITH "N", FIELD_LEN WITH 2
APPEND BLANK
REPLACE FIELD_NAME WITH "GOLDHAND", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "GOLDBANK", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "EXPER", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "EXPER_NEED", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "RATIONS", FIELD_TYPE WITH "N", FIELD_LEN WITH 5
APPEND BLANK
REPLACE FIELD_NAME WITH "NUMWEAPON", FIELD_TYPE WITH "N", FIELD_LEN WITH 3
APPEND BLANK
REPLACE FIELD_NAME WITH "WEAPON", FIELD_TYPE WITH "C", FIELD_LEN WITH 25
APPEND BLANK
REPLACE FIELD_NAME WITH "NUMARMOR", FIELD_TYPE WITH "N", FIELD_LEN WITH 3
APPEND BLANK
REPLACE FIELD_NAME WITH "ARMOR", FIELD_TYPE WITH "C", FIELD_LEN WITH 25
APPEND BLANK
REPLACE FIELD_NAME WITH "SPELLS", FIELD_TYPE WITH "C", FIELD_LEN WITH 25

RETURN

PROCEDURE CHMON
DONE1=.F.
DO WHILE .NOT. DONE1
	?
	?   "  By what name would you be called? " 
	ACCEPT "  : " TO STRNG
	IF LEN(STRNG) < 1
		DONE1=.T.
		RETURN
	ELSE
		SELECT 3
		GO TOP
		LOCATE FOR UPPER(OTHR->MONIKER) = UPPER(STRNG)
		IF FOUND()
			?   LRED
			?   "  The REAL " + TRIM(OTHR->MONIKER) + " might not like to have"
			?   "  an imposter in the village...."
			?   YELLOW + "  You would do well to choose another moniker..."
			DO PAUSE
			DONE1=.F.
		ELSE
			?   LBLUE
			?   "  So be it..."
			?   "  You will be known as Warrior " + TRIM(STRNG) + "!"
			?
			SELECT 1
			REPLACE PLYR->MONIKER WITH STRNG
			DONE1=.T.
			DO PAUSE
		ENDIF
	ENDIF
ENDDO
RETURN




PROCEDURE LUCKYDAY
DO CASE
	CASE FIGHTS[CURFIGHT]=0
		LUCKY=0
	CASE FIGHTS[CURFIGHT]=1
		?
		?   "  You stumble across an exit..."
		?   "  Do you take it?"
		DO YESNO
		IF YN="Y"
			LUCKY=1
		ENDIF
	CASE FIGHTS[CURFIGHT]=3
		LO=temp->LEVEL-1
		IF LO<1
			LO=1
		ENDIF
		HI=temp->LEVEL+3
		IF HI>100
			HI=100
		ENDIF
		DO HILO WITH LO,HI
		RR1=RND_RET
		SELECT 2
		SKIP RR1-1
		?
		?   "  You find the rotting corpse of a fallen warrior."
		?   "  In his skeletal hands, you spy a #" +LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->WEAPON) + "."
		?   "  Do you drop your #" + LTRIM(STR(PLYR->NUMWEAPON)) + " " + TRIM(PLYR->WEAPON)+ " for the #" + LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->WEAPON) + "?"
		DO YESNO
		IF YN="Y"
			?
			?   "  You leave your trusty #" + LTRIM(STR(PLYR->NUMWEAPON)) + " " + TRIM(PLYR->WEAPON) + " for another poor soul to find"
			?   "  and pry the #" + LTRIM(STR(GOODS->RANK)) + " " + TRIM(GOODS->WEAPON) + " from the lifeless hands of your fallen comrad."
			REPLACE PLYR->NUMWEAPON WITH GOODS->RANK
			REPLACE PLYR->WEAPON WITH GOODS->WEAPON
		ELSE    
			?
			?   "  You decide to leave the #" + LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->WEAPON) + " for the next hapless warrior."
			?
		ENDIF
		LUCKY=2
	CASE FIGHTS[CURFIGHT]=4
		LO=temp->LEVEL-3
		IF LO<1
			LO=1
		ENDIF
		HI=temp->LEVEL+3
		IF HI>49
			HI=49
		ENDIF
		DO HILO WITH LO,HI
		RR1=RND_RET
		SELECT 2
		SKIP RR1-1
		?
		?   "  You find the rotting corpse of a fallen warrior."
		?   "  He wore a #" + LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->ARMOR) + " that seems to have done him little good."
		?   "  Do you shed your #" + LTRIM(STR(PLYR->NUMARMOR)) +" "+ TRIM(PLYR->ARMOR)+ " for the #" + LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->ARMOR) + "?"
		DO YESNO
		IF YN="Y"
			?
			?   "  You leave your trusty #" + LTRIM(STR(PLYR->NUMARMOR)) +" "+ TRIM(PLYR->ARMOR) + " for another poor soul to find"
			?   "  and pry the #" + LTRIM(STR(GOODS->RANK)) +" "+ TRIM(GOODS->ARMOR) + " from the lifeless husk of your fallen comrad."
			REPLACE PLYR->NUMARMOR WITH GOODS->RANK
			REPLACE PLYR->ARMOR WITH GOODS->ARMOR
		ELSE    
			?
			?   "  You decide to leave the " + TRIM(GOODS->ARMOR) + " for the next hapless warrior."
			?
		ENDIF
		LUCKY=2
	CASE FIGHTS[CURFIGHT]=5
			?   
			?   "  In your push through the dank and darkness of the dungeon, you stumble"
			?   "  into an underground oasis.  You find here a cascading waterfall, and a "
			?   "  softly bubbling spring.  The cavern is illuminated by phosphoresent moss"
			?   "  and the grass under your feet is soft and inviting."
			?
			?   "  Staying awhile could do you a world of good."
			?   "  Do you stay?"
			DO YESNO
			IF YN="Y"
				?
				?   "  You settle down for a little nap, keeping one eye open."
				?   "  When you awake, you are much refreshed!."
				?
				RR1=PLYR->HITPOINTS + (PLYR->LEVEL * 5)
				IF RR1 > PLYR->MAXHITPTS
					RR1=PLYR->MAXHITPTS
				ENDIF
				REPLACE PLYR->HITPOINTS WITH RR1
			ELSE
				?
				?   "  You decide that you would rather KILL! KILL! KILL!"
				?   "  Let's hope you make it!"
				?
			ENDIF
		LUCKY=2
	CASE FIGHTS[CURFIGHT]=6
		DO HILO WITH 1,PLYR->LEVEL+(PLYR->LEVEL*150)
		RR1=RND_RET
		?
		?   "  As you wander around in the darkness, you hear the tinkle "
		?   "  of metal at your feet.  You look down and find a leather pouch."
		?   "  In it, you find " + LTRIM(STR(RR1)) + " gold pieces."
		?
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + RR1
		LUCKY=2
	CASE FIGHTS[CURFIGHT]=7
		DO HILO WITH 1,25
		RR1=RND_RET
		SELECT 5
		GO TOP
		SKIP RR1-1
		?
		?   "  As you wander around in the darkness, you hear the crinkle "
		?   "  of parchment at your feet.  You look down and find a tattered "
		?   "  scroll.  On it, you find a " + TRIM(SPELLS->SPELLNAME) + " spell."
		?
		SELECT 1
		SPSTR=PLYR->SPELLS
		SPN=VAL(SUBSTR(SPSTR,RR1,1))
		IF SPN >= 9
			?   "  To bad you have as many of those as you can carry."
		ELSE
			?   "  You add it to your collection."
			SPN=SPN+1
			SPSTR=STUFF(SPSTR,RR1,1,LTRIM(STR(SPN)))
			REPLACE PLYR->SPELLS WITH SPSTR
		ENDIF

	OTHERWISE
		LUCKY=0
ENDCASE
RETURN


PROCEDURE DEKRYPT
LASER="$%gold67pieces*!"
i=1
ZONE=0
IF LEN(CFG_RKY)<>16
	REGED=.F.
	RETURN
ENDIF
do while i<=16
	ZONE=ZONE+(ASC(SUBSTR(CFG_RKY,I,1))*ASC(SUBSTR(LASER,I,1)))*i
	I=I+1
ENDDO
IF ZONE=CFG_RNM
	REGED=.T.
ELSE
	REGED=.F.
ENDIF
RETURN




PROCEDURE GAMECFG
DO WHILE .T.
	CLEAR
	DO CENTLINE WITH PROGNAM + VERSION + " Game Config Menu"
	IF REGED
		DO CENTLINE WITH "REGISTERED!!"
	ELSE
		DO CENTLINE WITH "!!UNREGISTERED EVALUATION COPY!!"
	ENDIF
	?
	?   "       [A] BBS Name                        :  "  + CFG_BBN
	?   "       [B] Sysop Name                      :  "  + CFG_SYN
	?   "       [C] Number of Days per day         :  "  + STR(CFG_CPD)
	?   "       [D] Number of Jousts per Day       :  "  + STR(CFG_JPD)
	?   "       [E] Number of Fences per Day       :  "  + STR(CFG_FPD)
	?   "       [F] Number of Fights per Day       :  "  + STR(CFG_TPD)
	?   "       [G] Number of Gambles per Day      :  "  + STR(CFG_GPD)
	?   "       [H] Define Messagebase              :  "  + CFG_MSGBASE
	?   "       [I] Give someone credit for registration.       "
	?   "       [J] Reroll the game                             "
	?   "       [K] Enter Registration Code         :           "
	? 
	?   "       [Q] Quit to Sysop Menu"
	?
	?   "       [Dragon's Hoard Config Menu]: "
	DO ONEKEY WITH "ABCDEFGHIJKQ","Q"
	CH=ONECH
	DO CASE
		CASE CH="A"
			?   "        Enter BBS Name"
			ACCEPT   "        : " TO CFG_BBN
			DO DEKRYPT
		CASE CH="B"
			?   "        Enter Sysop Name"
			ACCEPT   "        : " TO CFG_SYN
		CASE CH="C"
			?   "        How many Days per day for each Caller?"
			INPUT   "        : " TO CFG_CPD
		CASE CH="D"
			?   "        How many Jousts per Day for each Caller?"
			INPUT   "        : " TO CFG_JPD
		CASE CH="E"
			?   "        How many Fences per Day for each Caller?"
			INPUT   "        : " TO CFG_FPD
		CASE CH="F"
			?   "        How many Fights per Day for each Caller?"
			INPUT   "        : " TO CFG_TPD
		CASE CH="G"
			?   "        How many Gambles per Day for each Caller?"
			INPUT   "        : " TO CFG_GPD
		CASE CH="H"
			?   "        Enter TBBS Message base to use"
			ACCEPT  "        : " TO CFG_MSGBASE
		CASE CH="I"
			?   "        Give somebody Credit for Registering the Game"
			?   "        Currently Set to: " + CFG_RNAM
			ACCEPT  "        : " TO CFG_RNAM
		CASE CH="J" 
		CASE CH="K"
			?   "        Enter your Registration Number"
			INPUT  "        : " TO CFG_RNM
			?   "        Enter your Registration Key"
			ACCEPT  "        : " TO CFG_RKY
			DO DEKRYPT
		CASE CH="Q"
			SAVE TO "CONFIG.MEM" ALL LIKE CFG_*
			RETURN
	ENDCASE
ENDDO
RETURN


PROCEDURE PACKIT
CLOSE ALL
ON ERROR DO FILEPROB
USE HOARDPLR EXCLUSIVE
ON ERROR
COPY TO TEMP6 FOR .NOT. DELETED()
ZAP
APPEND FROM TEMP6
ERASE TEMP.DBF
INDEX ON DESCEND(EXPER) TO HOARDEXP
CLOSE ALL
DO OPENPLYR
DO OPENOTHR
DO OPENGOODS
DO OPENTEMP
DO OPENSPEL
DO OPENMNST
SELECT 1
GO TOP
LOCATE FOR PLYR->REALNAME=UNAME()
IF .NOT. FOUND()
	?   "Error finding your account"
	do pause
	quit
ENDIF
RETURN


PROCEDURE FILEPROB
? "Sorry, but the database cannot be packed at this time."
RETURN



PROCEDURE MISCEL
?   "           " + PROGNAM + VERSION
?   "           by " + AUTHOR
?
?   WHITE + "  Current Time  : " + DPINK + TIME()
?   WHITE + "  Current Date  : " + DPINK + DTOC(DATE())
?   WHITE + "  Last Time On  : " + DPINK + DTOC(PLYR->LASTON)
?   WHITE + "  Days Since   : " + DPINK + LTRIM(STR(PLYR->TOTALCALLS))
?
?
DO PAUSE
RETURN


PROCEDURE SENDMAIL
?
?   dgreen + "  You summon a scribe, and inform him that you wish" 
?   "  to send a message"
SELECT 1
DO FINDOTHER WITH "send mail to"
IF FOFLAG
	SELECT 2
	TOWHO = "MAIL"+LTRIM(STR(RECNO()))+".MAL"
	DO W2MAIL WITH "" TOWHO
	DO W2MAIL WITH ESC+ "1;37;44m" + TRIM(PLYR->MONIKER) + " sent you this: " + ESC + "1;37;40m" TOWHO
	?
	? DGREEN + "  Enter message now..Blank line quits!"
	DO WHILE .T.
		ACCEPT LCYAN + " > " + WHITE TO STR
		IF LEN(STR)=0
			?
			? LCYAN + "  Mail sent!"
			DO W2MAIL WITH SPACE(34) + dgreen + "-=-=-=-" TOWHO
			DO W2MAIL WITH "" TOWHO
		  RETURN
		ELSE
			DO W2MAIL WITH ESC + "1;37m" + STR TOWHO
		ENDIF
	ENDDO
ELSE
	?   dgreen '"My pidgeon does not know where to find that Warrior!" '+white+"cries the scribe."
	do pause
ENDIF
RETURN



PROCEDURE READMAIL
?
?   lgreen + "A carrier pidgeon lites on your shoulder."
?
SELECT 1
MF="MAIL"+LTRIM(STR(RECNO()))+".MAL"
IF FILE(MF)
	?   dgreen + "You notice that it has a parchment afixed to his leg."
	?   "You untie the parchment, and shoo the bird away before he makes a mess"
	do pause
	do typetext with mf
else
	?   lred + "You shoo the bird away before he makes a mess!"
ENDIF
do pause
RETURN


PROCEDURE BJACK
CLEAR
?
?   DPINK + "  BlackJack"
?   
BETAMT = 0
DO MAKEBET
IF BETAMT = 0
	RETURN
ELSE
	DO SHUFFLE
	DO DEAL
	XFLAG=.T.
ENDIF
DO WHILE .T.
	IF PCNT>=5 .OR. DCNT>=5
		RETURN
	ENDIF
	DO THECARDS
	IF BJPSK=21
		?
		?   "  You won!"
		SELECT 1
		REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + (BETAMT*2)
		DO PAUSE
		RETURN
	ENDIF
	IF BJPSK>21
		?
		?   "  You busted!"
		DO PAUSE
		RETURN
	ENDIF
	?
	?   yellow + "  H"+white+")it, "+yellow+"S"+white+")tay ->)"
	DO ONEKEY WITH "HS?","?"
	CH=ONECH
	DO CASE
		CASE CH="H"
			PCNT=PCNT+1
			DEKCNT=DEKCNT+1
			BJPLR[PCNT]=DECK[DEKCNT]
		CASE CH="S"
			XFLAG=.F.
			DO WHILE .T.
				IF bjdsk >= bjpsk .AND. BJDSK <=21 .and. dcnt <=5
					do thecards
					?   lred + "  Dealer Wins!"
					do pause
					return
				ENDIF
				DCNT=DCNT+1
				DEKCNT=DEKCNT+1
				BJDLR[DCNT]=DECK[DEKCNT]
				IF DCNT <= 5
					do thecards
					IF BJDSK > 21 
						do thecards
						?   LRED + "  You Won!   Dealer busted!"
						REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + (BETAMT*2)
						DO PAUSE
						RETURN
					ENDIF
					IF BJDSK = 21
						?   LRED + "  Dealer Wins!"
						DO PAUSE
						return
					ENDIF
				ELSE
					RETURN
				ENDIF
			ENDDO
		CASE CH="?"
	ENDCASE
ENDDO
RETURN

PROCEDURE SHUFFLE
?   dgreen + "  Shuffling the deck"
I=1
DEKCNT=1
DO WHILE I<=52
	DECK[I]=DEKCNT
	DEKCNT=DEKCNT+1
	IF DEKCNT > 13
		DEKCNT=1
	ENDIF
	I=I+1
ENDDO

J=1
DO WHILE J<=1
	I=1
	DO WHILE I<=51
		DO HILO WITH I+1,52
		TEMP=DECK[I]
		DECK[I]=DECK[RND_RET]
		DECK[RND_RET]=TEMP
		I=I+1
	ENDDO
	J=J+1
ENDDO
RETURN

PROCEDURE DEAL
I=1
DEKCNT=0
DCNT=0
PCNT=0
DO WHILE I<=5
	BJPLR[I]=0
	BJDLR[I]=0
	I=I+1
ENDDO
I=1
DO WHILE I<=2
	DEKCNT=DEKCNT+1
	PCNT=PCNT+1
	BJPLR[PCNT]=DECK[DEKCNT]
	DEKCNT=DEKCNT+1
	DCNT=DCNT+1
	BJDLR[DCNT]=DECK[DEKCNT]
	I=I+1
ENDDO
RETURN

PROCEDURE THECARDS
?   WHITE
?   "  Dealer: "
I=1
BJDSK=0
BJPSK=0
DO WHILE I<=5
	IF XFLAG .AND. I=1
		??  "  X"
	ELSE
		IF BJDLR[I]>0
			IF BJDLR[I]=1
				??  "  A"
				IF I=1
					BJDSK=BJDSK+11
				ELSE
					BJDSK=BJDSK+1
				ENDIF
			ELSE
				IF BJDLR[I]=11
					??  "  J"
					BJDSK=BJDSK+10
				ELSE
					IF BJDLR[I]=12
						??  "  Q"
						BJDSK=BJDSK+10
					ELSE
						IF BJDLR[I]=13
							??  "  K"
							BJDSK=BJDSK+10
						ELSE
							??  RIGHT(STR(BJDLR[I]),3)
							BJDSK=BJDSK+BJDLR[I]
						ENDIF       
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDIF
	I=I+1
ENDDO
IF XFLAG
	??  " (??)"
ELSE
	??  " (" + RIGHT(STR(BJDSK),2)+ ")"
ENDIF
?   "  Player: "
I=1
DO WHILE I<=5
	IF BJPLR[I]>0
		IF BJPLR[I]=1
			??  "  A"
			IF I=1
				BJPSK=BJPSK+11
			ELSE
				BJPSK=BJPSK+1
			ENDIF
		ELSE
			IF BJPLR[I]=11
				??  "  J"
				BJPSK=BJPSK+10
			ELSE
				IF BJPLR[I]=12
					??  "  Q"
					BJPSK=BJPSK+10
				ELSE
					IF BJPLR[I]=13
						??  "  K"
						BJPSK=BJPSK+10
					ELSE
						??  RIGHT(STR(BJPLR[I]),3)
						BJPSK=BJPSK+BJPLR[I]
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDIF
	I=I+1
ENDDO
??  " (" + RIGHT(STR(BJPSK),2)+ ")"
?
RETURN


PROCEDURE MAKEBET
?   dgreen + "  You have " + LTRIM(STR(PLYR->GOLDHAND)) + " gold pieces"
?
INPUT white + "  Bet: " TO BETAMT
IF BETAMT < 1 .OR. BETAMT > PLYR->GOLDHAND
	BETAMT=0
ELSE
	SELECT 1
	REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND - BETAMT
ENDIF
RETURN


PROCEDURE FINDWORK
?   LGREEN
IF PLYR->FIGHTSLEFT < 1
	?   "  You are too exhausted to work today."
	?   "  Come back tommorrow."
ELSE
	SELECT 1
	DO HILO WITH PLYR->STRENGTH*2,PLYR->STRENGTH*10
	WAGES=RND_RET
	?   "  You spend an honest day's work, for an honest day's pay!"
	?   "  You are rewarded for your labors with " + LTRIM(STR(WAGES)) + " gold pieces."
	?   "  This uses up one of your fights for today."
	REPLACE PLYR->FIGHTSLEFT WITH PLYR->FIGHTSLEFT - 1
	REPLACE PLYR->GOLDHAND WITH PLYR->GOLDHAND + WAGES
	IF PLYR->FIGHTSLEFT < 0
		REPLACE PLYR->FIGHTSLEFT WITH 0
	ENDIF
ENDIF
DO PAUSE
RETURN

PROCEDURE PRELUCK
?
?   dpink + "  Just a moment.....waking up the monsters."
?
I=1
DO WHILE I<=7
	FIGHTS[I]=I
	I=I+1
ENDDO
DO WHILE I<=50
	FIGHTS[I]=0
	I=I+1
ENDDO
I=1
?   
DO WHILE I<=49
	DO HILO WITH I+1,50
	TEMP=FIGHTS[I]
	FIGHTS[I]=FIGHTS[RND_RET]
	FIGHTS[RND_RET]=TEMP
	I=I+1
ENDDO
RETURN

PROCEDURE REROLL
SELECT 1
DO WHILE .T.
	CLEAR
	?   DGREEN + "  Reroll stats"
	?
	?   YELLOW + "  A"+WHITE+") Reset ALL stats (start over)"
	?   YELLOW + "  J"+WHITE+") Reset Jousting Wins/Loses" 
	?   YELLOW + "  F"+WHITE+") Reset Fencing Wins/Loses"
	?
	?   yellow + "  A"+WHITE+")ll, "+YELLOW+"J"+WHITE+")oust, "+YELLOW+"F"+WHITE+")ence, "+yellow+"Q"+white+")uit -)>"
	DO ONEKEY WITH "AJFQ","Q"
	DO CASE
		CASE ONECH="A"
			SELECT 1
			DO NEWUSER
			?
			?   "  Done!"
			DO PAUSE
		CASE ONECH="J"
			REPLACE PLYR->WIN_J WITH 0
			REPLACE PLYR->LOSES_J WITH 0
			REPLACE PLYR->SKILL_J WITH PLYR->AGILITY + PLYR->STRENGTH
			?
			?   "  Done!"
			DO PAUSE
		CASE ONECH="F"
			REPLACE PLYR->WIN_F WITH 0
			REPLACE PLYR->LOSES_F WITH 0
			REPLACE PLYR->SKILL_J WITH PLYR->AGILITY + PLYR->INTELIGENCE
			?
			?   "  Done!"
			DO PAUSE
		CASE ONECH="Q"
			RETURN
	ENDCASE
	RETURN
ENDDO
RETURN

PROCEDURE ANNOUNCE
?
? "  Are you sure you want to write this message for all to see?"
DO YESNO
IF YN="Y"
	TOWHO="today.txt"
	DO W2MAIL WITH LBLUE + TRIM(PLYR->MONIKER) + lcyan + " Announces:" TOWHO
	?
	? lcyan + "  Enter message now..Blank line quits!"
	DO WHILE .T.
		ACCEPT lblue + " > " + white TO STR
		IF LEN(STR)=0
			?   lgreen
			DO CENTLINE WITH "Announcement Made for all to see!"
			?
			DO W2MAIL WITH SPACE(34) + dgreen + "-=-=-=-" TOWHO
		  RETURN
		ELSE
			DO W2MAIL WITH ESC + "1;37m" + STR TOWHO
		ENDIF
	ENDDO
ENDIF
RETURN

PROCEDURE HAPPEN
?
?   yellow + "  The parchment reads..."

if file("today.txt")
	?   dgreen + "  These events did occur on this day."
	do typetext with "TODAY.TXT"
else
	?   lgreen + "  The realm was quiet"
endif
do pause
IF FILE("YESTERDY.TXT")
	?   lred + "  These events did occur on the previous day..."
	do typetext with "YESTERDY.TXT"
	do pause
ENDIF
RETURN

PROCEDURE IGMMENU
DO WHILE .T.
	CLEAR
	DO TYPETEXT WITH "IGMMENU.SCR"
	SELECT 7
	GO TOP
	I=1
	DO WHILE .NOT. EOF() .AND. .NOT. DELETED()
		if igm->ok2show
			?   WHITE + "  (" + YELLOW + RIGHT(STR(I),3) + WHITE + ") " + DGREEN + IGM->DISPLAY
		endif
		SKIP
		I=I+1
	ENDDO
	?
	ACCEPT "  [" + prognam + "]:" TO ISTR
	inum=upper(istr)
	if LEN(ISTR)>0
		INUM=VAL(ISTR)
		SELECT 7
		IF INUM>0 .AND. INUM<=RECCOUNT()
			GO TOP
			SKIP INUM-1
			IF .NOT. DELETED()
				IF .NOT. FILE(IGMTXT)
					DO W2MAIL WITH "", IGMTXT
				ENDIF
				DOTBBS TYPE 200 OPTDATA trim(IGM->ODATA)
			ENDIF
		ENDIF
	else
		return
	ENDIF
ENDDO
RETURN


PROCEDURE HLSO
THISDAY=0
THATDAY=0
THISDAY=YEAR(DATE())+365
THISDAY=THISDAY+MONTH(DATE())+28
MON1=MONTH(DATE())
IF MON1=1 .OR. MON1=3 .OR. MON1=5 .OR. MON1=7 .OR. MON1=8 .OR. MON1=10 .OR. MON1=12
	THISDAY=THISDAY+3
ELSE
	IF MON1=4 .OR. MON1=6 .OR. MON1=9 .OR. MON1=11
		THISDAY=2
	ENDIF
ENDIF
THISDAY=THISDAY+DAY(DATE())


THATDAY=YEAR(OTHR->LASTON)+365
THATDAY=THATDAY+MONTH(OTHR->LASTON)+28
MON1=MONTH(OTHR->LASTON)
IF MON1=1 .OR. MON1=3 .OR. MON1=5 .OR. MON1=7 .OR. MON1=8 .OR. MON1=10 .OR. MON1=12
	THATDAY=THATDAY+3
ELSE
	IF MON1=4 .OR. MON1=6 .OR. MON1=9 .OR. MON1=11
		THATDAY=2
	ENDIF
ENDIF
THATDAY=THATDAY+DAY(OTHR->LASTON)
RETURN

