<?php
/*
 * ----------------------------------------------------------------------------
 * Files-DispTopics.php                                              08/02/2006
 * This script will display the file forum topics to the user based on the
 * user's security level, access flags and age.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Listing Files';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once('layout_files.inc.php');               // Webpage header and footer.

FilesHeader();                              // Display the webpage header.
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="3" bgcolor="#416DBF" height="33" width="750">
            <span class="msgTitle">&nbsp;&nbsp;File Area Topics</span></td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="620" height="15" bgcolor="#000080" align="left">&nbsp;Topic&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Directories&nbsp;</td>
    </tr>

<?php
$topics = GetTopics('F');                   // Get the topic numbers.

// Set the file string variable.
$file = $VA_SYSPATHS['main'] . '/DBGROUP.CFG';
if (!is_file($file)) {
    die('<br /><h4>Requested configuration file is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

if ($topics[0] == 0) {
    print '<tr><td colspan="5"><p align="left"><br /><span class="heading">There are no available topics.</span><br /><br /></p></td></tr>' . "\n";
} else {
    for ($x = 1; $x <= $topics[0]; $x++) {
        $topic = GetTopicInfo($topics[$x], 'F', $fileString);   // Retrieve the topic information.
        if ($topic) {
            if ($topic['dbno'] != 0) {
                if (trim($topic['desc']) != '') {
                    $topicDesc = htmlspecialchars($topic['desc']);
                } else {
                    $topicDesc = '(No Topic Description)';
                }
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" src="<?php print $rootDir; ?>images/folder.gif" alt="Topic Folder" width="13" height="11"></td>
        <td width="620" height="30" align="left">
            <span class="heading">&nbsp;<a href="files-dispdb.php?t=<?php print $topics[$x] . '">' . HtmlSpace($topicDesc); ?></a>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="msgBody">&nbsp;<?php print $topic['dbno']; ?>&nbsp;</span></td>
    </tr>

<?php
            }
        }
    }
}
?>

    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="3" height="25" width="750">&nbsp;</td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php

FilesFooter();                              // Display the webpage footer.

?>