<?php
/*
 * ----------------------------------------------------------------------------
 * Files-ViewMsg.php                                                 08/02/2006
 * This script will display the selected message to the user.
 * The variable $t is passed to the script to set the topic number.
 * The variable $d is passed to the script to set the database number.
 * The variable $m is passed to the script to set the message number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Listing Files';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-userfile.inc.php');  // Include user functions.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once('layout_files.inc.php');               // Webpage header and footer.

$VA_NETWORKS = GetNetworkInfo();

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    $t = 10;
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = (integer) $_GET['d'];
} else {
    $d = 1;
}

if (isset($_GET['html'])) {                 // Set the passed variables.
    $html = (integer) $_GET['html'];
} else {
    $html = 0;
}

if ($t < 1) {
    $t = 1;
}
if ($d < 1) {
    $d = 1;
}

$topic = GetTopicInfo($t, 'F');             // Retrieve the topic information.
// If this is an invalid section, display an error message.
if ($topic == '') {
    die('<br /><h4>Invalid topic. Please press the BACK button on your browser.</h4>');
}

$db = GetDbInfo($t, $d);                    // Retrieve the database information.

$msgno = $db['msgno'];                      // Retrieve the number of messages.
if ($msgno == 0) {
    die('<br /><h4>Invalid file. Please press the BACK button on your browser.</h4>');
}

// Determine if the user has access to this section.
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if (trim($topic['desc']) != '') {
    $topicDesc = htmlspecialchars($topic['desc']);
} else {
    $topicDesc = '(No Topic Description)';
}

if (trim($db['desc']) != '') {
    $dbDesc = htmlspecialchars($db['desc']);
} else {
    $dbDesc = '(No Description)';
}

if (strlen($dbDesc) >= 31) {
    $dbDesc = $dbDesc . '...';
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    $m = $msgno;
}
if ($m > $msgno) {
    $m = $msgno;
}
if ($m <= 0) {
    $m = 1;
}

FilesHeader();                              // Display the webpage header.
?>

<script language="JavaScript" type="text/javascript">
<!--
    function MessageInfo(t, d, m) {
        var url = "msginfo.php?t=" + t + "&d=" + d + "&m=" + m;
        var newwindow = window.open(url, "messageinfo", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, width=620, height=210");
        newwindow.focus();
    }
//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--
    function ViewImage(t, d, m) {
        var url = "viewimage.php?t=" + t + "&d=" + d + "&m=" + m;
        var newwindow = window.open(url, "viewimage", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, width=340, height=270");
        newwindow.focus();
    }
//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--
    function EditDesc(t, d, m) {
        var url = "editdesc.php?t=" + t + "&d=" + d + "&m=" + m;
        var newwindow = window.open(url, "viewimage", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, width=620, height=160");
        newwindow.focus();
    }
//-->
</script>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous File</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 1;
    print '<a class="msgBack" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next File</a> |' . "\n";
}

if ($m >= $msgno - 25) {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=25">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
}

print '&nbsp;<a class="msgBack" title="Back to Directories" href="files-dispdb.php?t=' . $t . '">&lt;--</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="files-disptopics.php">&lt;---</a>' . "\n";
?>

        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td colspan="5" bgcolor="#416DBF" height="33" width="750">
                        <span class="msgTitle">&nbsp;&nbsp;<?php
                                                           if ($db['networked']) {
                                                               print '<img src="' . $rootDir . 'images/networked.gif" alt="Networked Database" width="12" height="11">&nbsp;';
                                                           } else {
                                                               print '<img src="' . $rootDir . 'images/local.gif" alt="Local Database" width="12" height="11">&nbsp;';
                                                           }
                                                           print HtmlSpace($dbDesc);
                                                           ?></span></td>
                    <?php
                    if (($USER['securitylevel'] >= 255) ||
                        (($CONFIG['fileupload'] == 1) &&
                         (($USER['userno'] > 0) &&
                          ($USER['userno'] != $CONFIG['guestacct']) &&
                          ($USER['securitylevel'] >= $CONFIG['fileuploadsl'])) &&
                         (($VA_MAIN['secuploads'] == 1) ||
                          ($USER['securitylevel'] >= $db['minwritesl'])))) {
                    ?>
                    <form action="<?php print $rootDir; ?>upload.php" name="post" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="t" value="<?php print $t; ?>">
                            <input type="hidden" name="d" value="<?php print $d; ?>">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/upload.gif" border="0" alt="Upload a File" width="60" height="25">
                        </td>
                    </form>
                    <?php } ?>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="385" height="15" bgcolor="#000080" align="left">&nbsp;Description&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Filename&nbsp;</td>
        <td class="msgHeader" width="60" height="15" bgcolor="#000080" align="center">&nbsp;Size&nbsp;</td>
        <td class="msgHeader" width="175" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time/Uploader&nbsp;</td>
    </tr>

<?php
$msgInfo = GetMessageInfo($db, $m);         // Get the message information.
$dateTime = ConvertDateTime($msgInfo['creation']);
// Check for any files.
if ($msgInfo['attfilename'] != '') {
    if ($db['filepath'] != '') {
        if ($CONFIG['filehost'] != '') {
            $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
        } else {
            $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
        }
    } else {
        $file = $VA_SYSPATHS['sysop'] . '/' . $msgInfo['attfilename'];
    }
} else {
    $file = '';
}

if ($file != '') {
    if (!is_file($file)) {
        $filesize = '0 bytes';
    } else {
        $filesize = filesize($file);
        if ($filesize >= 1073741824) {
            $filesize = round($filesize / 1073741824, 1) . 'GB';
        } else if ($filesize >= 1048576) {
            $filesize = round($filesize / 1048576, 1) . 'MB';
        } else if ($filesize >= 1024) {
            $filesize = intval($filesize / 1024) . 'KB';
        } else {
            $filesize = $filesize . ' bytes';
        }
    }
} else {
    $filesize = '0 bytes';
}

if ($filesize > 0) {
    $filemd5 = md5_file($file);
} else {
    $filemd5 = '';
}

$from = $msgInfo['fromhandle'];
$pos = strpos($from, '@');                      // Check for email address.
if (is_int($pos)) {
    $from = substr($from, 0, $pos);
}
$char = substr($from, 0, 1);
if ($char == '<') {
    $from = substr($from, 1);
}
if ($char == '"') {
    $pos = strpos($from, '"', 1);
    $from = substr($from, 1, $pos - 1);
}
$from = trim(htmlspecialchars($from));

if ($msgInfo['subject'] == '') {
    $subject = '(No Description)';
} else {
    $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
}
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 0) {
                                print 'src="' . $rootDir . 'images/message.gif" alt="File"';
                            } else {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="File Marked for Deletion"';
                            }
                            ?> width="11" height="11"><?php
                                                      if ($msgInfo['attfilename'] != '') {
                                                          print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                      }
                                                      ?></td>
        <td width="385" height="30" align="left">
            <span class="heading">&nbsp;<?php
                                        if ($USER['securitylevel'] >= 255) {
                                            print '<a class="heading" href="javascript: EditDesc(\'' . $t . '\', \'' . $d . '\', \'' . $m . '\');">' . HtmlSpace($subject) . '</a>';
                                        } else {
                                            print HtmlSpace($subject);
                                        }
                                        ?>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="boldBody">&nbsp;<?php print htmlspecialchars($msgInfo['attfilename']); ?>&nbsp;</span></td>
        <td width="60" height="30" align="center" nowrap>
            <span class="body">&nbsp;<?php print $filesize; ?>&nbsp;</span></td>
        <td width="175" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime">&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                          if (!$dateTime['tz']) {
                                                                                                                                              print '*';
                                                                                                                                          }
                                                                                                                                          ?></span><br /><span class="body">by </span><span class="boldBody"><?php
                                                                                                                                                                                                           if (($msgInfo['fromnetid'] == 1) &&
                                                                                                                                                                                                               ($msgInfo['fromnetnode'] == $VA_NETWORKS[1]['settings']['systemid']) &&
                                                                                                                                                                                                               ($msgInfo['fromuserno'] > 0) &&
                                                                                                                                                                                                               ($USER['securitylevel'] >= 255)) {
                                                                                                                                                                                                               $fromUser = GetUser($msgInfo['fromuserno']);
                                                                                                                                                                                                               if (strtolower($fromUser['handle']) == strtolower($msgInfo['fromhandle'])) {
                                                                                                                                                                                                                   print '<a href="' . $rootDir . 'misc/usereditor.php?u=' . $msgInfo['fromuserno'] . '">' . HtmlSpace($from) . '</a>';
                                                                                                                                                                                                               } else {
                                                                                                                                                                                                                   print HtmlSpace($from);
                                                                                                                                                                                                               }
                                                                                                                                                                                                           } else {
                                                                                                                                                                                                               print HtmlSpace($from);
                                                                                                                                                                                                           }
                                                                                                                                                                                                           ?>&nbsp;</span></td>
    </tr>

<?php
if ($html == 0) {
    $h = 0;
} else {
    $h = 1;
}
$message = StripANSICodes(StripBBSCodes(StripRouting(GetMessage($db, $m, $h, '', $msgInfo))));  // Get the message to display.
$message = HTMLEncode($message, $USER_SETTINGS['htmlencode']);

// If a supported image, then get its info.
if ((extension_loaded('gd')) &&
    ($msgInfo['offline'] == 0) &&
    ($msgInfo['deleted'] == 0) &&
    ($filesize > 0)) {
    $image = getimagesize($file);
    if ($image !== FALSE) {
        if ((extension_loaded('exif')) &&
            (($image[2] == 2) ||
             ($image[2] == 7))) {
            $extimage = exif_read_data($file, 0, TRUE);
            if ($extimage !== FALSE) {
                $message .= "\r\n\r\n---\r\n" . '<b>Image Information</b>';
                $message .= "\r\n" . 'Dimensions:    ' . $image[0] . ' x ' . $image[1];
                if (isset($extimage['EXIF']['DateTimeOriginal'])) {
                    $imagedate = str_replace(':', '/', substr($extimage['EXIF']['DateTimeOriginal'], 0, 10));
                    $imagetime = substr($extimage['EXIF']['DateTimeOriginal'], 11);
                    $timestamp = strtotime($imagedate . ' ' . $imagetime);
                    if ($timestamp > 0) {
                        $message .= "\r\n" . 'Date Created:  ' . date("l, F j, Y g:ia", $timestamp);
                    }
                }
                if (isset($extimage['FILE']['FileDateTime'])) {
                    $message .= "\r\n" . 'Date Modified: ' . date("l, F j, Y g:ia", $extimage['FILE']['FileDateTime']);
                }
                if ((isset($extimage['IFD0']['Make'])) && (isset($extimage['IFD0']['Model']))) {
                    $message .= "\r\n" . 'Camera Model:  ' . $extimage['IFD0']['Make'] . ' ' . $extimage['IFD0']['Model'];
                }
                if (isset($extimage['COMPUTED']['Copyright'])) {
                    $message .= "\r\n" . 'Copyright:     ' . $extimage['COMPUTED']['Copyright'];
                }
                $message .= "\r\n" . 'Filesize:      ' . $filesize;
            } else {
                $message = $message . "\r\n\r\n---\r\n" . 'Image Resolution: ' . $image[0] . ' x ' . $image[1];
            }
        } else {
            $message = $message . "\r\n\r\n---\r\n" . 'Image Resolution: ' . $image[0] . ' x ' . $image[1];
        }
    }
} else {
    $image = FALSE;
}

// If a MP3 file, then get its info.
if (($msgInfo['offline'] == 0) &&
    ($msgInfo['deleted'] == 0) &&
    ($filesize > 0) &&
    ($image == FALSE) &&
    (strtolower(substr($file, strlen($file) - 4)) == '.mp3')) {
    $id3 = ReadID3Info($file);
    if ($id3['tag'] == 'TAG') {
        $message .= "\r\n\r\n---\r\n" . '<b>MP3 Information</b>';
        $message .= "\r\n" . 'Song Name: ' . ucwords(strtolower($id3['songname']));
        $message .= "\r\n" . 'Artist: ' . ucwords(strtolower($id3['artist']));
        $message .= "\r\n" . 'Album: ' . ucwords(strtolower($id3['album']));
        $message .= "\r\n" . 'Year: ' . $id3['year'];
        $message .= "\r\n" . 'Genre: ' . $id3['genre'];
    }
}
?>

    <tr>
        <td width="750" align="left" colspan="5" valign="top">

<?php
if ($msgInfo['deleted'] == 1) {
    print '<span class="msgBack">(Message Marked for Deletion)</span>\n';
}
// If there is an attached file, then display its link.
if ($file != '') {
?>

    <form name="download" action="<?php print $rootDir; ?>download.php" method="POST">
        <input type="hidden" name="t" value="<?php print $t; ?>">
        <input type="hidden" name="d" value="<?php print $d; ?>">
        <input type="hidden" name="m" value="<?php print $m; ?>">
        <table cellpadding="0" cellspacing="0" width="100%" border="0">
            <tr>
                <td align="left">
                    <input type="image" value="Download" src="<?php print $rootDir; ?>images/download.gif" alt="Download <?php print $msgInfo['attfilename']; ?>" width="80" height="25" align="absmiddle">
                </td>
                <td align="left" valign="top" width="100%">
                    <span class="filename">&nbsp;File: <?php print $msgInfo['attfilename']; ?></span><span class="filesize">&nbsp;(<?php print $filesize; ?>)</span>
                    <span class="filename">&nbsp;&nbsp;Downloads:&nbsp;</span><span class="filesize"><?php print $msgInfo['downloadno']; ?></span>
                    <?php if (($msgInfo['offline'] == 0) && ($filesize > 0)) { ?>
                    <span class="fileonline">&nbsp;&nbsp;ONLINE</span>
                    <?php } else { ?>
                    <span class="fileoffline">&nbsp;&nbsp;OFFLINE</span>
                    <?php } ?><br />
                    <span class="md5">&nbsp;MD5: <?php print $filemd5; ?></span>
                </td>
            </tr>
        </table>
    </form>

<?php
} else {
    print '<br />';
}
?>

            <pre><?php print $message; ?></pre>
        </td>
    <tr>
        <td bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgHeader" align="left">&nbsp;

                        <?php
                        // Display image thumbnail if gd extension is loaded, and file is
                        // an image.
                        if ((extension_loaded('gd')) &&
                            ($image !== FALSE) &&
                            ($msgInfo['offline'] == 0) &&
                            ($msgInfo['deleted'] == 0) &&
                            ($filesize > 0)) {
                            if (($image !== FALSE) &&
                                (($image[2] == 1) ||
                                 ($image[2] == 2) ||
                                 ($image[2] == 3))) {
                        ?>

                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a class="msgHeader" href="Javascript:ViewImage(\'<?php print $t; ?>\', \'<?php print $d; ?>\', \'<?php print $m; ?>\');">View Image Thumbnail</a>&nbsp;|');
                        -->
                        </script>
                        <noscript>
                            <a class="msgHeader" href="viewimage.php?t=<?php print $t; ?>&d=<?php print $d; ?>&m=<?php print $m; ?>" target="viewimage">View Image Thumbnail</a>&nbsp;|
                        </noscript>

                        <?php
                            }
                        }

                        if (($html == '') || ($html == 0)) {
                            print '<a class="msgHeader" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&html=1' . '">Strip HTML Tags</a>';
                        } else {
                            print '<a class="msgHeader" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&html=0">Show HTML Tags</a>';
                        }
                        ?>

                    </td>
                    <td class="msgHeader" align="right">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a class="msgHeader" href="Javascript:MessageInfo(\'<?php print $t; ?>\', \'<?php print $d; ?>\', \'<?php print $m; ?>\');">File Info</a>&nbsp;');
                        -->
                        </script>
                        <noscript>
                            <a class="msgHeader" href="msginfo.php?t=<?php print $t; ?>&d=<?php print $d; ?>&m=<?php print $m; ?>" target="messageinfo">Message Info</a>&nbsp;
                        </noscript>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous File</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 1;
    print '<a class="msgBack" href="files-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next File</a> |' . "\n";
}

if ($m >= $msgno - 25) {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=25">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else {
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
}

print '&nbsp;<a class="msgBack" title="Back to Directories" href="files-dispdb.php?t=' . $t . '">&lt;--</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="files-disptopics.php">&lt;---</a>' . "\n";
?>

        </td>
        <td align="right">
            <span class="msgBack"><a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></span></td>
    </tr>
</table>

<?php

FilesFooter();                              // Display the webpage footer.

?>