<?php
/*
 * ----------------------------------------------------------------------------
 * Post-Email.php                                                    10/10/2006
 * This script displays the new message/reply form to the user.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Sending Email';
$TIMEOUT = 1800;                                    // Set timeout to 30 mins.

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once('layout_email.inc.php');               // Webpage header and footer.

if ((!isset($_POST['referer'])) && (!isset($_GET['referer']))) {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}
if (isset($_GET['referer'])) {
    $_POST['referer'] = urldecode($_GET['referer']);
}

$dbInfo = SetEmailInfo($USER['userno']);
$VA_NETWORKS = GetNetworkInfo();

// Check user's write security level.
if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct'])) {
    die('<br /><h4>You do not have access to email others. Please press the BACK button on your browser.</h4>');
}

if ($USER['securitylevel'] < $dbInfo['minwritesl']) {
    if ((!isset($_GET['u'])) || ($_GET['u'] != 1)) {
        die('<br /><h4>You do not have access to email others. Please press the BACK button on your browser.</h4>');
    }
}

if ((isset($_POST['reply'])) && ($_POST['reply'] != 0)) {   // Set the passed variables.
    $reply = (integer) $_POST['reply'];
    $u = 0;
    $msgInfo = GetMessageInfo($dbInfo, $reply);
} else {
    $reply = 0;
    $u = 0;
    if ((isset($_GET['u'])) && (intval($_GET['u']) > 0)) {
        $u = (integer) $_GET['u'];
    } else if ((isset($_POST['u'])) && (intval($_POST['u']) > 0)) {
        $u = (integer) $_POST['u'];
    }
}

if (isset($_POST['m'])) {
    $m = (integer) $_POST['m'];
} else {
    $m = $reply;
}

// Check to see if the message was already created and needs to be processed.
if ((isset($_POST['msgflag'])) && ($_POST['msgflag'] == 1)) {
    if ((!isset($_SERVER['HTTP_REFERER'])) ||
        (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
        die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
    }

    if (isset($_POST['startuser'])) {
        $startUser = (integer) $_POST['startuser'];
    } else {
        $startUser = 1;
    }
    if (isset($_POST['touser'])) {
        $toUser = substr(strtolower(trim($_POST['touser'])), 0, 80);
        $toUser = urldecode($toUser);
        $toUser = str_replace("\r\n", "\n", $toUser);
        $toUser = str_replace("\r", "\n", $toUser);
        $array = explode("\n", $toUser);
        $toUser = strip_tags($array[0]);

        $find = array("/bcc\:/i",
                      "/content\-type\:/i",
                      "/mime\-type\:/i",
                      "/cc\:/i",
                      "/to\:/i");
        $toUser = preg_replace($find, '', $toUser);
        $toUser = trim($toUser);

        if (($toUser != '') && (isset($_POST['tonetid']))) {
            $toNetId = (integer) $_POST['tonetid'];
            if ($toNetId == 0) {   // Determine if a local or network email.
                if (substr(strtolower($toUser), 0, 9) == 'all users') {   // If sending a message to all, it has to be local and by a sysop.
                    if ($USER['securitylevel'] < 255) {
                        die ('<br /><h4>You are trying to send a message to all users, but do not have security access.</h4>');
                    } else {
                        $toUserString = 'allusers';
                        $toUser = str_replace(' ', '', $toUser);    // Remove any spaces. ('all users' now is 'allusers' len(8))
                        $allSign = '';
                        $allValue = 0;
                        if (strlen($toUser) > 9) {
                            $allSign = substr($toUser, 8, 1);
                            switch ($allSign) {
                                case '>':
                                    $allSign = '>';
                                    $allValue = (integer) substr($toUser, 9);
                                    break;
                                case '<':
                                    $allSign = '<';
                                    $allValue = (integer) substr($toUser, 9);
                                    break;
                                case '=':
                                    $allSign = '=';
                                    $allValue = (integer) substr($toUser, 9);
                                    break;
                                case '!':
                                    $allSign = '!';
                                    $allValue = strtoupper(substr($toUser, 9, 1));
                                    break;
                                case '$':
                                    $allSign = '$';
                                    $allValue = strtoupper(substr($toUser, 9, 1));
                                    break;
                                default:
                                    die ('<br /><h4>Improper format to send to all users. Send to \'all users <>= securitylevel\' or \'all users !$ flag\'.</h4>');
                                    break;
                            }
                        } else {
                            die('<br /><h4>You are attempting to send a message to all users, but have not provided any parameters.</h4>');
                        }
                    }
                } else {
                    $toUserString = $toUser . '@0*' . $toNetId;
                }
            } else {
                if (substr(strtolower($toUser), 0, 9) == 'all users') {   // If trying to send to non-local, display error.
                    die('<br /><h4>You can send a message to all local users only. You are attempting to send to a network address.</h4>');
                } else {
                    $atpos = strpos($toUser, '@');
                    if ($atpos === FALSE) die('<br /><h4>Invalid recipient address. Please enter in the format of user@networkaddress. Please press the BACK button on your browser.</h4>');
                    $toUserString = $toUser . '*' . $toNetId;
                }
            }
        } else {
            die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
        }
    } else {
        die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
    }
    
    if (isset($_POST['subject'])) {
        $msgSubject = $_POST['subject'];
    } else {
        die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
    }

    if (isset($_POST['msgbody'])) {
        $msgBody = $_POST['msgbody'];
    } else {
        die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
    }

    $attFilename = '';
    if ((isset($_FILES['attfile'])) && ($_FILES['attfile']['size'] > 0)) {
        // Validate user access for upload files.
        if (($USER['securitylevel'] < $VA_MAIN['emlotherfile']) ||
            ((trim(ini_get('file_uploads')) == '')) ||
             (!is_dir(ini_get('upload_tmp_dir')))) {
            die('<br /><h4>There was an error with your attached file. Please press the BACK button on your browser.</h4>');
            // Erase the uploaded file.
            if (is_uploaded_file($_FILES['attfile']['tmp_name'])) {
                unlink($_FILES['attfile']['tmp_name']);
            }
        }

        // Access granted, continue...
        if ($_FILES['attfile']['error'] == 'UPLOAD_ERR_OK') {
            if (is_uploaded_file($_FILES['attfile']['tmp_name'])) {
                $userDirectory = $VA_SYSPATHS['sysop'] . '/' . $USER['userno'];
                $filename      = ConvertLongFilename($_FILES['attfile']['name'], $userDirectory);
                $attFilename   = str_replace('/', "\\", $userDirectory . '/' . $filename);
                if (!is_dir($userDirectory)) {
                    mkdir($userDirectory);
                }
                move_uploaded_file($_FILES['attfile']['tmp_name'], $attFilename);

                // Add any information to the message itself.
                $msgBody = rtrim($msgBody) . "\r\n\r\n\r\n--------------";
                $msgBody = $msgBody . "\r\nAttached file: " . $filename;
                if ($filename != $_FILES['attfile']['name']) {
                    $msgBody = $msgBody . "\r\nOriginal filename: " . $_FILES['attfile']['name'] . "\r\nThe filename was changed for compatibility reasons.";
                }
            }
        } else {
            switch ($_FILES['attfile']['error']) {
                case 'UPLOAD_ERR_FORM_SIZE':
                    unlink($_FILES['attfile']['tmp_name']);
                    die('<br /><h4>Attached file is too big (>5MB). Please press the BACK button on your browser.</h4>');
                    break;
                case 'UPLOAD_ERR_PARTIAL':
                    unlink($_FILES['attfile']['tmp_name']);
                    die('<br /><h4>Attached file upload was interrupted. Please press the BACK button on your browser.</h4>');
                    break;
                case 'UPLOAD_ERR_NO_FILE':
                    die('<br /><h4>Invalid attachment. Please press the BACK button on your browser.</h4>');
                    break;
                default:
                    die('<br /><h4>An error with the file attachment occurred. Please press the BACK button on your browser.</h4>');
                    break;
            }
        }
    }

    if (isset($_POST['attfilename'])) {
        $attFilename = trim($_POST['attfilename']);
    }

    $pos = strrpos($_POST['referer'], '/');
    $url = substr($_POST['referer'], 0, $pos);

    if ($toUserString != 'allusers') {           // If not sent to all, send it..
        $log = 'E-Mail Sent     "' . $USER['handle'] . '" --> "' . $toUserString . '" - ' . $msgSubject;
        WriteLog('VADV-PHP.LOG', $log);     // Log the email.
        WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename);
    } else {                                // ...otherwise, loop through all the users to send it.
        if ($startUser == 1) {
            $log = 'E-Mail Sent     "' . $USER['handle'] . '" --> "ALL USERS" - ' . $msgSubject;
            WriteLog('VADV-PHP.LOG', $log);     // Log the email.
        }
        
        include_once($includeDir . 'va-userfile.inc.php');  // Include the user functions.
        $userCount = GetUserCount();

        // Estimate the time it will take to process all of these emails. First,
        // it will calculate based on user count, then it will calculate based
        // on the time that has passed in relation to the number of users
        // processed.
        $exeTime = time();
        if (isset($_POST['exetime'])) {
            $estTime = ((($exeTime - $_POST['exetime']) / 100) * ($userCount - $startUser + 1) / 60);
        } else {
            $estTime = (1.1 * ($userCount - $startUser + 1)) / 60;
        }
        $estTime = round($estTime, 2);
        
        // Calculate percentage done.
        $pctDone = round(($startUser / $userCount) * 100, 0);

        require_once($includeDir. 'html_header.php');
?>

<html>
<head>
<title>Sending Messages...</title>
</head>
<body>
<div align="center">
    <table width="100%" height="75%">
        <tr>
            <td height="100%" width="100%" align="center">
                <table cellpadding="4" cellspacing="0" border="1" bordercolor="#000080">
                    <tr>
                        <td height="100%" width="100%">
                            <table cellpadding="4" cellspacing="0" width="100%" height="100%">
                                <tr>
                                    <td bgcolor="#000080" align="center" width="400" style="font-family: Verdana, Arial, Helvetica; color: #FFFF00">
                                        Sending Messages...</td>
                                </tr>
                                <tr>
                                    <td bgcolor="#E2E2E2" align="center" width="400" height="50" style="font-family: Verdana, Arial, Helvetica; color: #000000">
                                        This may take a few moments... <?php print $pctDone; ?>%<br />
                                        <small>Estimated time left: <?php print $estTime; ?> minutes</small></td>
                                </tr>
                                <tr>
                                    <td bgcolor="#E2E2E2" align="center" width="400" style="font-family: Verdana, Arial, Helvetica; color: #000000">
                                        <table cellpadding="0" cellspacing="0" width="100%" height="100%" border="1" bordercolor="#000000">
                                            <tr>
                                                <td height="20" width="<?php print $pctDone; ?>%" bgcolor="#FF0000">&nbsp;</td>
                                                <td height="20" bgcolor="#000000">&nbsp;</td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
</body>
</html>

<?php
        ob_flush();

        for ($x = $startUser; $x <= $userCount; $x++) {
            if ($x < ($startUser + 100)) {
                set_time_limit(120);                    // Reset the time counter for each user.
                $toUser = GetUser($x);
                if (($toUser['securitylevel'] > 0) &&   // If user is not deleted, or a guest...
                    ($x != $CONFIG['guestacct'])) {
                    $toUserString = $x . '@0*0';        // Set the to user string.
                    switch ($allSign) {
                        case '':
                            WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            break;
                        case '>':
                            if ($toUser['securitylevel'] > $allValue) {
                                WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            }
                            break;
                        case '<':
                            if ($toUser['securitylevel'] < $allValue) {
                                WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            }
                            break;
                        case '=':
                            if ($toUser['securitylevel'] == $allValue) {
                                WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            }
                            break;
                        case '!':
                            if (strpos($toUser['flags'], $allValue) !== FALSE) {
                                WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            }
                            break;
                        case '$':
                            if (strpos($toUser['accflags'], $allValue) !== FALSE) {
                                WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            }
                            break;
                        default:
                            WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply, $attFilename, 0);
                            break;
                    }
                }
            } else {                        // After 100 emails, reload the script to continue. This avoids server timeouts.
                print '<form name="reloadPost" method="POST" action="post-email.php" enctype="multipart/form-data">' . "\n";
                print '<input type="hidden" name="referer" value="' . $_POST['referer'] . '">' . "\n";
                print '<input type="hidden" name="reply" value="' . $_POST['reply'] . '">' . "\n";
                print '<input type="hidden" name="u" value="' . $_POST['u'] . '">' . "\n";
                print '<input type="hidden" name="msgflag" value="1">' . "\n";
                print '<input type="hidden" name="startuser" value="' . ($startUser + 100) . '">' . "\n";
                print '<input type="hidden" name="touser" value="' . $_POST['touser'] . '">' . "\n";
                print '<input type="hidden" name="tonetid" value="' . $_POST['tonetid'] . '">' . "\n";
                print '<input type="hidden" name="subject" value="' . $_POST['subject'] . '">' . "\n";
                print '<input type="hidden" name="msgbody" value="' . $_POST['msgbody'] . '">' . "\n";
                print '<input type="hidden" name="attfilename" value="' . $attFilename . '">' . "\n";
                print '<input type="hidden" name="exetime" value="' . $exeTime . '">' . "\n";
                print '<noscript>' . "\n";
                print '<b>Press submit to send to the next 100 users.</b><br />Enable JavaScript to not see this message.<br />';
                print '<input type="submit" name="submit">' . "\n";
                print '</noscript>' . "\n";
                print '</form>' . "\n";
                print '<script language="JavaScript" type="text/javascript">' . "\n";
                print '<!--' . "\n";
                print 'document.reloadPost.submit();' . "\n";
                print '//-->' . "\n";
                print '</script>' . "\n";
                die();
            }
        }
    }

    if ($reply > 0) {
        // Return to message.
        RedirectUser($url . '/email-viewmsg.php?m=' . $m);
    } else {
        // Return to message listing.
        if ($u > 0) {
            RedirectUser($_POST['referer']);
        } else {
            RedirectUser($url . '/email-dispmsg.php');
        }
    }
}

EmailHeader();
?>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            if ((form.touser.value.length == 0) ||
                (form.subject.value.length == 0)) {
                alert("Please enter a recipient address, and a subject.");
                <?php if ($reply == 0) { ?>
                form.touser.focus();
                <?php } else { ?>
                form.subject.focus();
                <?php } ?>
                return false;
            }
            submitted = 1;
            form.submit.disabled = true;
            form.reset.disabled = true;
            form.cancel.disabled = true;
            return true;
        } else {
            return false;
        }
    }

    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/post-email_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
<form name="postmsg" method="POST" action="post-email.php" enctype="multipart/form-data" onsubmit="return validate(postmsg)">
    <input type="hidden" name="referer" value="<?php print $_POST['referer']; ?>">
    <input type="hidden" name="reply" value="<?php print $reply; ?>">
    <input type="hidden" name="u" value="<?php print $u; ?>">
    <?php if (isset($reply) && ($reply > 0)) { ?>
        <input type="hidden" name="m" value="<?php print $m; ?>">
        <input type="hidden" name="touser" value="<?php print $msgInfo['fromhandle'] . '@' . $msgInfo['fromnetnode']; ?>">
        <input type="hidden" name="tonetid" value="<?php print $msgInfo['fromnetid']; ?>">
    <?php } ?>
    <input type="hidden" name="msgflag" value="1">
    <div align="center">
        <center>
        <table border="1" cellpadding="2" cellspacing="0" style="border-collapse: collapse" width="750" bordercolor="#666666" bgcolor="#E2E2E2">
            <tr>
                <td class="msgTitle" height="25" colspan="2" bgcolor="#416DBF" align="left">
                    &nbsp;&nbsp;<?php print HtmlSpace($dbInfo['desc']); ?> - New Message</td>
            </tr>
            <tr>
                <td class="msgHeader" height="15" colspan="2" bgcolor="#000080" align="left">
                    &nbsp;</td>
            </tr>
            <tr>
                <td align="center" valign="top">
                    <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="639">
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                To:</td>
                            <td height="25" align="left">
                                <?php
                                if ($reply > 0) {
                                    print '<span class="boldBody">' . HtmlSpace($msgInfo['fromhandle']) . '</span><span class="body">@' . $msgInfo['fromnetnode'] . ' ' . $VA_NETWORKS[$msgInfo['fromnetid']]['desc'] . '</span>';
                                } else {
                                ?>
                                 <input name="touser" type="text" size="40" maxlength="40" <?php
                                                                                           if ($u > 0) {
                                                                                               print 'value="' . $u . '"';
                                                                                           }
                                                                                           ?> tabindex="1">
                                 <select name="tonetid" size="1" tabindex="2">
                                     <option selected value="0">Local</option>
                                     <?php
                                     $cnt = 0;
                                     $net = array();
                                     foreach($VA_NETWORKS as $netInfo) {
                                         if ((isset($netInfo['nettype'])) &&
                                             ($netInfo['nettype'] != 2) &&   // If not a VLive network
                                             ($netInfo['nettype'] != 5)) {   // If not a QWK network
                                             if ((isset($netInfo['settings']['systemid'])) &&
                                                 ($netInfo['settings']['systemid'] != '0')) {
                                                 if (($USER['securitylevel'] >= 255) ||
                                                     ($netInfo['accflag'] == '') ||                                  // If a access flag is set..
                                                     (strpos($USER['flags'], $netInfo['accflag']) !== FALSE)) {      // If the user has the flag
                                                     switch ($netInfo['nettype']) {
                                                         case 1:
                                                             $type = 'VirtualNET';
                                                             break;
                                                         case 3:
                                                             $type = 'Internet';
                                                             break;
                                                         case 4:
                                                             $type = 'FIDOnet';
                                                             break;
                                                         case 9:
                                                             $type = 'WWIVnet';
                                                             break;
                                                         default:
                                                             $type = 'Unknown';
                                                             break;
                                                     }
                                                     $net[$cnt]['netno']    = $netInfo['netno'];
                                                     $net[$cnt]['desc']     = $netInfo['desc'];
                                                     $net[$cnt]['sortdesc'] = strtolower($netInfo['desc']);
                                                     $net[$cnt]['type']     = $type;
                                                     $cnt++;
                                                 }
                                             }
                                         }
                                     }
                                     // Organize the array alphabetically by description.
                                     $sortarr = array();
                                     foreach ($net as $row) {
                                         $sortarr[] = $row['sortdesc'];
                                     }
                                     array_multisort($sortarr, $net);

                                     // Display the listing.
                                     for ($x = 0; $x < count($net); $x++) {
                                         print '<option value="' . $net[$x]['netno'] . '">' . HtmlSpace($net[$x]['desc']) . ' (' . $net[$x]['type'] . ")</option>\n";
                                     }
                                     ?>
                                 </select>
                                 <?php
                                 }
                                 ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                Subject:</td>
                            <td height="25" align="left">
                                <input name="subject" type="text" size="64" maxlength="64" value="<?php if ($reply > 0) print $msgInfo['subject']; ?>" tabindex="3">
                                <script language="JavaScript" type="text/javascript">
                                <!--
                                    <?php
                                     if ($USER['securitylevel'] < 255) {
                                         print 'document.write(\'<a href="Javascript:HelpWindow()"><img border="0" src="' . $rootDir . 'images/help.gif" alt="Email Help" width="15" height="15" align="middle"></a>\');' . "\n";
                                     } else {
                                         print 'document.write(\'<a href="Javascript:HelpWindow(\\\'all\\\')"><img border="0" src="' . $rootDir . 'images/help.gif" alt="Email Help" width="15" height="15" align="middle"></a>\');' . "\n";
                                     }
                                    ?>
                                -->
                                </script>
                                <noscript>
                                    <a href="<?php print $rootDir; ?>help/post-email_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Email Help" width="15" height="15" align="middle"></a>
                                </noscript>
                            </td>
                        </tr>
                        <?php
                            if (($USER['securitylevel'] >= $VA_MAIN['emlotherfile']) &&
                                ((trim(ini_get('file_uploads')) != '')) &&
                                 (is_dir(ini_get('upload_tmp_dir')))) {
                        ?>
                        <tr>
                            <td class="body" width="90" height="25" align="left" valign="top">
                                Att File:</td>
                            <td height="25" align="left">
                                <?php
                                $maxsize = ini_get('upload_max_filesize');
                                $megpos  = strpos(strtoupper($maxsize), 'M');
                                if ($megpos !== FALSE) {
                                    $maxsize = substr($maxsize, 0, $megpos);
                                    $maxsize = 1024 * 1024 * $maxsize;
                                }
                                ?>
                                <input type="hidden" name="MAX_FILE_SIZE" value="<?php print $maxsize; ?>">
                                <input name="attfile" type="file" size="64" tabindex="8"></td>
                        </tr>
                        <?php
                            }
                        ?>
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                Message:</td>
                            <td align="left">
                                <textarea name="msgbody" rows="15" cols="80" wrap="soft" tabindex="4"><?php
                                                                                                      if ($reply > 0) {
                                                                                                          print 'Re: ' . $msgInfo['subject'] . QuoteMessage(StripRouting(GetMessage($dbInfo, $reply, 0, '', $msgInfo))) . "\r\n";
                                                                                                      }
                                                                                                      ?></textarea>
                                <table border="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="100%" cellpadding="2">
                                    <tr>
                                        <td align="right" width="340">
                                            <input type="submit" value="Submit" name="submit" tabindex="5">
                                            <input type="reset" value="Reset" name="reset" tabindex="6">
                                        </td>
                                        <td align="left">
                                            <input type="button" value="Cancel" name="cancel" tabindex="7" onclick="javascript:document.location.href='<?php print $_POST['referer']; ?>'">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" bgcolor="#416DBF" align="left">&nbsp;</td>
            </tr>
        </table>
        </center>
    </div>
</form>
 <script language="JavaScript" type="text/javascript">
<!--
    if (document.postmsg.touser.value.length > 0) {
        document.postmsg.subject.focus();
    } else {
        document.postmsg.touser.focus();
    }
//-->
</script>
<?php

EmailFooter();

?>