<?php
/*
 * ----------------------------------------------------------------------------
 * ViewImage.php                                                     12/18/2004
 * This script will display a thumbnail of an attached image in a database.
 * The variable $t is passed to the script to set the topic number.
 * The variable $d is passed to the script to set the database number.
 * The variable $m is passed to the script to set the message number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */
 
$VA_ACTION = 'Viewing a Thumbnail';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = $_GET['t'];
} else {
    die('<br /><h4>Invalid message parameters.</h4>');
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = $_GET['d'];
} else {
    die('<br /><h4>Invalid message parameters.</h4>');
}

if (isset($_GET['m'])) {
    $m = (integer) $_GET['m'];
} else {
    die('<br /><h4>Invalid message parameters.</h4>');
}

$networks = GetNetworkInfo();               // Get the local network info.

if (($t == 'e') || ($d == 'e')) {           // Get the database information.
    $t = 'e';
    $d = 'e';
    $db = SetEmailInfo($userno);
    $msgInfo = GetMessageInfo($db, $m);     // Get the message information.
    if ($msgInfo['touserno'] != $userno) {  // Check to see if the user has access to this email message.
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
} else if (($t == 's') || ($d == 's')) {
    $t = 's';
    $d = 's';
    $db = SetSentEmailInfo($userno);       
    $msgInfo = GetMessageInfo($db, $m);         // Get the message information.
    if ($msgInfo['fromuserno'] != $userno) {    // Check to see if the user has access to this email message.
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
} else {
    $t = (integer) $t;
    $d = (integer) $d;
    $db = GetDbInfo($t, $d);
    if (!DbAccess($db)) {
        die('<br /><h4>You do not have access to this section.</h4>');
    }
    $msgInfo = GetMessageInfo($db, $m);     // Get the message information.
    if ($USER['securitylevel'] < $db['minreadsl']) {
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
}

if (trim($msgInfo['attfilename']) == '') {
    die('<br /><h4>No image to view.</h4>');
}

if (extension_loaded('gd')) {
    if ($msgInfo['attfilepath'] != '') {    // If a local attachment.
        $filepath = str_replace('/', "\\", $msgInfo['attfilepath']);
        $pos = strrpos($filepath, "\\");
        $filepath = substr($filepath, 0, $pos);
    } else {
        $filepath = $db['filepath'];
    }
    if ($filepath != '') {
        if ($CONFIG['filehost']) {
            $file = ConvertDir($CONFIG['filehost'], $filepath) . '/' . $msgInfo['attfilename'];
        } else {
            $file = $filepath . '/' . $msgInfo['attfilename'];
        }
    } else {
        $file = $VA_SYSPATHS['sysop'] . '/' . $msgInfo['attfilename'];
    }
    $image = getimagesize($file);
    if (($image !== FALSE) &&
        (($image[2] == 1) ||
         ($image[2] == 2) ||
         ($image[2] == 3))) {
        if (($image[0] <= 320) && ($image[1] <= 240)) {
            $width  = $image[0];
            $height = $image[1];
        } else {
            if ($image[0] > $image[1]) {
                $ratio = 320 / $image[0];
                $width = 320;
                $height = round($image[1] * $ratio, 0);
                if ($height > 240) {
                    $ratio = 240 / $height;
                    $width = round($width * $ratio, 0);
                    $height = 240;
                }
            } else {
                $ratio = 240 / $image[1];
                $width = round($image[0] * $ratio, 0);
                $height = 240;
                if ($width > 320) {
                    $ratio = 320 / $width;
                    $width = 320;
                    $height = round($height * $ratio, 0);
                }
            }
        }

        if ($image[2] == 1) {
            $source_image = imagecreatefromgif($file);
        } else if ($image[2] == 2) {
            $source_image = imagecreatefromjpeg($file);
        } else if ($image[2] == 3) {
            $source_image = imagecreatefrompng($file);
        } else {
            die('<br /><h4>Not a supported image file.</h4>');
        }

        $resize_image = imagecreatetruecolor($width, $height);
        imagecopyresampled($resize_image, $source_image, 0, 0, 0, 0, $width, $height, $image[0], $image[1]);

        // Let the browser know that it is an image..
        header("Content-Type: image/jpeg");

        // Display the image.
        imagejpeg($resize_image);

        imagedestroy($source_image);
        imagedestroy($resize_image);
    } else {
        die('<br /><h4>Not a supported image file.</h4>');
    }
} else {
    die('<br /><h4>This server does not have GD2 installed.</h4>');
}

?>