<?php
/*
 * ----------------------------------------------------------------------------
 * Forms.inc.php                                                     07/30/2006
 * This script contains various forms that are used to login, register, etc.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Common.inc.php :: LoginBox()
*
* This function will display the login box. If the user is not logged in, then
* he will be presented with a form to login. If the user is currently logged in,
* then he will be presented with a logoff button. The function will return a
* boolean value. TRUE means that the user is already logged in and FALSE means
* that the user is not logged in.
*
* @return boolean
*/
function LoginBox() {
    global $rootDir;
    global $includeDir;
    global $CONFIG;
    global $USER;
    global $VA_USERS;

    $status = FALSE;
?>
<style type="text/css">
<!--
a.loginbox:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.loginbox:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.loginbox          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.loginboxmsg       { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFF00; font-weight:bold }
span.loginboxBold  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
-->
</style>
<?php
    if ((isset($_SESSION['auth'])) && (!$_SESSION['auth'])) {
        if ((isset($_SESSION['error'])) && ($_SESSION['error'])) {
            if (isset($_SESSION['login'])) {
                // Destroy the session information.
                setcookie('vadvphp', '', time() - 86400, '/', '', 0);
                $_SESSION = array('');
                session_destroy();
                session_start();
            }
?>
<p align="center"><span class="loginboxBold">Invalid username or password!</span></p>
<?php
        }
        // User is NOT logged in...
        $status = FALSE;

        // Get login id for this session...
        $loginId = '';
        for ($x = 1; $x <= $VA_USERS[0]; $x++) {
            if ($VA_USERS[$x]['session'] == session_id()) {
                $loginId = $VA_USERS[$x]['id'];
                break;
            }
        }
?>
<script language="JavaScript" type="text/javascript" src="md5.js"></script>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            if ((form.username.value.length == 0) ||
                (form.password.value.length == 0)) {
                alert("Please enter a username and password.");
                form.username.focus();
                return false;
            } else if (form.username.value.length > 40) {
                alert("The username cannot be longer than 40 characters.");
                form.username.focus();
                return false;
            } else if (form.password.value.length > 32) {
                alert("The password cannot be longer than 32 characters.");
                form.password.focus();
                return false;
            }
            form.md5.value = form.password.value.toUpperCase();
            form.md5.value = hex_md5(form.md5.value);
            form.md5.value = "|md5|" + hex_hmac_md5(form.id.value, form.md5.value);
            form.password.value = "";
            form.id.value = "";
            submitted = 1;
            return true;
        } else {
            return false;
        }
    }
//-->
</script>
<div align="center">
    <center>
        <table width="100" cellspacing="0" border="0" cellpadding="2">
            <form name="login" method="POST" action="login.php" onsubmit="return validate(login)">
                <input type="hidden" name="referer" value="<?php print GetCurrentURL(0); ?>">
                <script language="JavaScript" type="text/javascript">
                <!--
                    document.write('<input type="hidden" name="id" value="<?php print $loginId; ?>">');
                    document.write('<input type="hidden" name="md5" value="">');
                -->
                </script>
                <?php
                if (isset($_GET['url'])) {
                    print '<input type="hidden" name="url" value="' . $_GET['url'] . '">';
                }
                ?>
                <noscript>
                    <tr>
                        <td class="loginboxmsg" align="center" colspan="2">
                            Enable JavaScript for a more secure login!
                        </td>
                    </tr>
                </noscript>
                <tr>
                    <td class="loginbox" align="left" width="50%">
                        Username:
                    </td>
                    <td align="left" width="50%">
                        <input type="text" name="username" size="12" maxlength="40" tabindex="1">
                    </td>
                </tr>
                <tr>
                    <td class="loginbox" align="left" width="50%">
                        Password:
                    </td>
                    <td align="left" width="50%">
                        <input type="password" name="password" size="12" maxlength="32" tabindex="2">
                    </td>
                </tr>
                <tr>
                    <td class="loginbox" align="center" colspan="2" width="100%">
                        <?php
                        if ($CONFIG['cookielife'] > 0) {
                        ?>
                        <p><input type="checkbox" name="remember" value="1" tabindex="3"> Remember Me<br />(expires in <?php
                                                                                                                       if ($CONFIG['cookielife'] == 1) {
                                                                                                                           print $CONFIG['cookielife'] . ' day';
                                                                                                                       } else {
                                                                                                                           print $CONFIG['cookielife'] . ' days';
                                                                                                                       } ?>)</p>
                        <?php
                        }
                        ?>
                        <p><input type="image" name="submit" src="images/login.gif" border="0" alt="Login!" width="54" height="25" tabindex="4"></p>
                    </td>
                </tr>
            </form>
        </table>
    </center>
</div>
<?php
    } else {
        // User IS logged in...
        $status = TRUE;
?>
<table width="100%" cellspacing="0" border="0" cellpadding="2">
    <form method="POST" action="login.php">
        <input type="hidden" name="logoff" value="logoff">
        <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
        <tr>
            <td class="loginbox" align="center">
                <p><span class="loginboxBold">You are logged in as: <?php print HtmlSpace($USER['handle']); ?></span> (#<?php print $USER['userno']; ?>)</p>
                <p><input type="image" name="submit" src="images/logoff.gif" border="0" alt="Logoff!" width="62" height="25"></p>
            </td>
        </tr>
    </form>
</table>
<?php
    }

    return $status;                         // Return the status.
}


/**
* Common.inc.php :: RegistrationBox()
*
* This function will display a new user registration form.
*
*/
function RegistrationBox() {
    global $CONFIG;
    global $rootDir;
    global $includeDir;
    
    $required = GetAccFlags($CONFIG['newuserreq']);   // Convert into a string.
?>
<style type="text/css">
<!--
a.regbox:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.regbox:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.regbox          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.regboxNotify               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFF00; font-weight:bold }
-->
</style>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            if (<?php if (is_int(strpos($required, 'A'))) print "\n(form.realname.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'B'))) print "\n(form.address.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'C'))) print "\n(form.city.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'D'))) print "\n(form.state.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'E'))) print "\n(form.zipcode.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'F'))) print "\n(form.voice.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'G'))) print "\n(form.data.value.length == 0) ||"; ?>
                <?php if (is_int(strpos($required, 'H'))) print "\n(form.bdaymonth.value.length == 0) || \n(form.bdayday.value.length == 0) || \n(form.bdayyear.value.length == 0) ||\n"; ?>
                (form.username.value.length == 0) ||
                (form.password.value.length == 0) ||
                (form.verify.value.length == 0)) {
                alert("Please fill out all required fields.");
                form.username.focus();
                return false;
            }
            submitted = 1;
            form.submit.disabled = true;
            form.reset.disabled = true;
            return true;
        } else {
            return false;
        }
    }

    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/registrationbox_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
-->
</script>

<form name="registration" method="post" action="register.php" onsubmit="return validate(registration)">
    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
    <div align="center">
        <center>
            <table cellspacing="0" border="0" cellpadding="2">
                <tr>
                    <td class="regbox" align="center" colspan="2">
                        Fields marked with "<span style="color: #FF0000">*</span>" are required.
                    </td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'username\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#username" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Username/Handle:<span style="color: #FF0000">*</span></td>
                    <td><input type="text" name="username" size="40" maxlength="40" tabindex="1"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'password\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#password" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Password:<span style="color: #FF0000">*</span></td>
                    <td><input type="password" name="password" size="8" maxlength="8" tabindex="2"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'password\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#password" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Verify Password:<span style="color: #FF0000">*</span></td>
                    <td><input type="password" name="verify" size="8" maxlength="8" tabindex="3"></td>
                </tr>
                <tr>
                    <td colspan="2" height="25"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'realname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#realname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Real Name:<?php
                                  if (is_int(strpos($required, 'A'))) {
                                      print '<span style="color: #FF0000">*</span>';
                                  }
                                  ?></td>
                    <td><input type="text" name="realname" size="40" maxlength="40" tabindex="4"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'address\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#address" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Address:<?php
                                if (is_int(strpos($required, 'B'))) {
                                    print '<span style="color: #FF0000">*</span>';
                                }
                                ?></td>
                    <td><input type="text" name="address" size="40" maxlength="40" tabindex="5"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'city\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#city" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        City:<?php
                             if (is_int(strpos($required, 'C'))) {
                                 print '<span style="color: #FF0000">*</span>';
                             }
                             ?></td>
                    <td><input type="text" name="city" size="32" maxlength="32" tabindex="6"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'state\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#state" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        State:<?php
                              if (is_int(strpos($required, 'D'))) {
                                  print '<span style="color: #FF0000">*</span>';
                              }
                              ?></td>
                    <td><input type="text" name="state" size="3" maxlength="3" tabindex="7"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'zipcode\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#zipcode" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Zip Code:<?php
                                 if (is_int(strpos($required, 'E'))) {
                                     print '<span style="color: #FF0000">*</span>';
                                 }
                                 ?></td>
                    <td><input type="text" name="zipcode" size="10" maxlength="10" tabindex="8"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'voice\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#voice" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Phone Number:<?php
                                     if (is_int(strpos($required, 'F'))) {
                                         print '<span style="color: #FF0000">*</span>';
                                     }
                                     ?></td>
                    <td><input type="text" name="voice" size="12" maxlength="12" tabindex="9"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'data\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#data" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Fax/Data Number:<?php
                                        if (is_int(strpos($required, 'G'))) {
                                            print '<span style="color: #FF0000">*</span>';
                                        }
                                        ?></td>
                    <td><input type="text" name="data" size="12" maxlength="12" tabindex="10"></td>
                </tr>
                <tr>
                    <td class="regbox" align="left">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a href="Javascript:HelpWindow(\'bday\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                        -->
                        </script>
                        <noscript>
                            <a href="<?php print $rootDir; ?>help/registrationbox_help.php#bday" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                        </noscript>
                        Birthday: (MM/DD/YYYY)<?php
                                 if (is_int(strpos($required, 'H'))) {
                                     print '<span style="color: #FF0000">*</span>';
                                 }
                                 ?></td>
                    <td class="regbox" align="left">
                        <input type="text" name="bdaymonth" size="2" maxlength="2" tabindex="11">/
                        <input type="text" name="bdayday" size="2" maxlength="2" tabindex="12">/
                        <input type="text" name="bdayyear" size="4" maxlength="4" tabindex="13">
                    </td>
                </tr>
                <tr>
                    <td colspan="2" height="25"></td>
                </tr>
                <tr>
                    <td class="pre" align="center" colspan="2">
                        <p class="regboxNotify">
                            Please click "submit" only once.<br />
                            It may take up to a few minutes to process.
                        </p>
                        <p>
                            <input type="submit" value="Submit" name="submit" tabindex="14">
                            <input type="reset" value="Reset" name="submit" tabindex="15">
                        </p>
                    </td>
                </tr>
            </table>
        </center>
    </div>
</form>
<?php
}

?>