<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Arcs.inc.php                                                   09/01/2004
 * This script will retrieve all of the informaton related to the configured
 * archiving programs.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Arcs.inc.php :: GetArcs()
*
* Retrieve all of the archive program information and store it into a
* multidimensional array.
*
* Array format: $arcs[1]['setting']
*               $arcs[0] = Total number of configured archive programs.
*
* @return array
*/
function GetArcs() {
    $fileArray = ReadArcs();
    if ($fileArray === FALSE) {
        trigger_error(VA_Error(3));
    }

    $arcs = array();                      // Create the array.
    $pos  = 0;                            // Positional counter.

    for ($x = 1; $pos < count($fileArray); $x++) {
        // Extract the ascii version of the hex key. Spaces are represented by
        // underscores.
        $line = trim($fileArray[0 + $pos]);
        $slength = strspn($line, '0');
        $line = substr($line, $slength);
        $length = strlen($line);
        $key = '';
        for ($y = 0; $y < $length; $y = $y + 2) {
            $val = substr($line, $y, 2);
            $key = $key . chr(hexdec($val));
        }
        $key = str_pad($key, strlen($key) + $slength, '_', STR_PAD_LEFT);

        $arcs[$x]['key']        = trim($key);
        $arcs[$x]['hexkey']     = trim($fileArray[0 + $pos]);
        $arcs[$x]['addcmd']     = trim($fileArray[1 + $pos]);
        $arcs[$x]['movecmd']    = trim($fileArray[2 + $pos]);
        $arcs[$x]['extractcmd'] = trim($fileArray[3 + $pos]);
        $arcs[$x]['viewcmd']    = trim($fileArray[4 + $pos]);
        $arcs[$x]['testcmd']    = trim($fileArray[5 + $pos]);
        $arcs[$x]['commentcmd'] = trim($fileArray[6 + $pos]);
        $pos = $pos + 7;
    }

    $arcs[0] = $x - 1;                    // Put the number of programs in position 0.

    return $arcs;                         // Return the archiving programs.

}


/**
* Va-Arcs.inc.php :: ReadArcs()
*
* This function will read the arcs.cfg file.
*
* @return array
*/
function ReadArcs() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/ARCS.CFG';
    $fileArray = file($file);               // Read the file.

    return $fileArray;                      // Return the file string.
}


/**
* Va-Arcs.inc.php :: WriteArcs()
*
* This function will write a new arcs.cfg file based on the file array
* passed to it. The file array must be in the same format as GetArcs(). It is
* a good idea to load the arcs array before creating any entries to be sure
* all the keys will be written.
*
* @param array $fileArray
* @return mixed
*/
function WriteArcs($fileArray) {
    if (!is_array($fileArray)) {
        trigger_error(VA_Error(1));
    }

    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/ARCS.CFG';

    $fp = fopen($file, 'wb');               // Open the file.
    flock($fp, LOCK_EX);                    // Lock the file.
    
    for ($x = 1; $x < count($fileArray); $x++) {
        fwrite($fp, $fileArray[$x]['hexkey'] . "\r\n",     strlen($fileArray[$x]['hexkey']) + 2);
        fwrite($fp, $fileArray[$x]['addcmd'] . "\r\n",     strlen($fileArray[$x]['addcmd']) + 2);
        fwrite($fp, $fileArray[$x]['movecmd'] . "\r\n",    strlen($fileArray[$x]['movecmd']) + 2);
        fwrite($fp, $fileArray[$x]['extractcmd'] . "\r\n", strlen($fileArray[$x]['extractcmd']) + 2);
        fwrite($fp, $fileArray[$x]['viewcmd'] . "\r\n",    strlen($fileArray[$x]['viewcmd']) + 2);
        fwrite($fp, $fileArray[$x]['testcmd'] . "\r\n",    strlen($fileArray[$x]['testcmd']) + 2);
        fwrite($fp, $fileArray[$x]['commentcmd'] . "\r\n", strlen($fileArray[$x]['commentcmd']) + 2);
    }
    
    flock($fp, LOCK_UN);                    // Unlock the file.
    fclose($fp);

    return;
}


// Retrieve the upload protocols automatically.
$VA_ARCS = GetArcs();

?>