<?php
/*
 * ----------------------------------------------------------------------------
 * EditUser.php                                                      10/14/2006
 * This script will allow users to edit thier personal information and
 * preferences.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Editing User Profile';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Include user settings.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}

$VA_NETWORKS = GetNetworkInfo();
$required = GetAccFlags($CONFIG['newuserreq']);   // Convert into a string.

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Edit User] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
a:active              { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
a:link                { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
a:visited             { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
a:hover               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
a.footer:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.footer:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.pre:link            { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
a.pre:visted          { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
a.pre2:link           { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
a.pre2:visited        { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.subHeading:link     { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
a.subHeading:visited  { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
.body                 { font-family: Courier New;               font-size: 10pt; color: #C0C0C0; }
.footer               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.pre                  { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
.pre2                 { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
.pre3                 { font-family: Courier New;               font-size: 12pt; color: #E2E2E2; }
.heading              { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.subHeading           { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
-->
</style>
<script language="JavaScript" type="text/javascript">
<!--
    function validate(form) {
        if (<?php if (is_int(strpos($required, 'A'))) print "\n(form.realname.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'B'))) print "\n(form.address.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'C'))) print "\n(form.city.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'D'))) print "\n(form.state.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'E'))) print "\n(form.zipcode.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'F'))) print "\n(form.voice.value.length == 0) ||"; ?>
            <?php if (is_int(strpos($required, 'G'))) print "\n(form.data.value.length == 0) ||"; ?>
            (0 == 1)) {
            alert("Please fill out all required fields.");
            form.realname.focus();
            return false;
        }
    }

    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/edituser_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40" colspan="2">
                                        Edit User: <?php print HtmlSpace($USER['handle']); ?>
                                    </td>
                                </tr>
                            </table>
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <?php
                                        if (isset($_GET['error'])) {
                                            switch ($_GET['error']) {
                                                case 'realname':
                                                    $error = 'You must enter your real name.';
                                                    break;
                                                case 'address':
                                                    $error = 'You must enter your address.';
                                                    break;
                                                case 'city':
                                                    $error = 'You must enter your city.';
                                                    break;
                                                case 'state':
                                                    $error = 'You must enter your state.';
                                                    break;
                                                case 'zipcode':
                                                    $error = 'You must enter your zip code.';
                                                    break;
                                                case 'voice':
                                                    $error = 'You must enter your phone number.';
                                                    break;
                                                case 'data':
                                                    $error = 'You must enter your fax/data number.';
                                                    break;
                                            }
                                            print '<span class="footer">--' . $error . '--</span><br />';
                                        }
                                        ?>
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a><br />
                                        <a class="footer" href="userinfo.php?u=<?php print $USER['userno']; ?>">Return to user information.</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" colspan="2" height="25">
                                        Fields marked with "<span style="color: #FF0000">*</span>" are required.
                                    </td>
                                </tr>
                                <form name="edituser" method="post" action="edituser_process.php" onsubmit="return validate(edituser)">
                                    <input type="hidden" name="process" value="1">
                                    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                                    <input type="hidden" name="userno" value="<?php print $USER['userno']; ?>">
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Personal Information
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'userno\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#userno" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            User Number:</td>
                                        <td class="pre" align="left"><?php print $USER['userno']; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'handle\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#handle" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Handle:</td>
                                        <td class="pre" align="left"><?php print HtmlSpace($USER['handle']); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'realname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#realname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Real Name:<?php
                                                      if (is_int(strpos($required, 'A'))) {
                                                          print '<span style="color: #FF0000">*</span>';
                                                      }
                                                      ?></td>
                                        <td align="left"><input type="text" name="realname" size="40" maxlength="40" value="<?php print $USER['realname']; ?>" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'address\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#address" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Address:<?php
                                                    if (is_int(strpos($required, 'B'))) {
                                                        print '<span style="color: #FF0000">*</span>';
                                                    }
                                                    ?></td>
                                        <td align="left"><input type="text" name="address" size="40" maxlength="40" value="<?php print $USER['address']; ?>" tabindex="2"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'city\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#city" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            City:<?php
                                                 if (is_int(strpos($required, 'C'))) {
                                                     print '<span style="color: #FF0000">*</span>';
                                                 }
                                                 ?></td>
                                        <td align="left"><input type="text" name="city" size="32" maxlength="32" value="<?php print $USER['city']; ?>" tabindex="3"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'state\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#state" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            State:<?php
                                                  if (is_int(strpos($required, 'D'))) {
                                                      print '<span style="color: #FF0000">*</span>';
                                                  }
                                                  ?></td>
                                        <td align="left"><input type="text" name="state" size="3" maxlength="3" value="<?php print $USER['state']; ?>" tabindex="4"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'zipcode\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#zipcode" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Zip Code:<?php
                                                     if (is_int(strpos($required, 'E'))) {
                                                         print '<span style="color: #FF0000">*</span>';
                                                     }
                                                     ?></td>
                                        <td align="left"><input type="text" name="zipcode" size="10" maxlength="10" value="<?php print $USER['zipcode']; ?>" tabindex="5"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'phone1\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#phone1" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Phone Number:<?php
                                                         if (is_int(strpos($required, 'F'))) {
                                                             print '<span style="color: #FF0000">*</span>';
                                                         }
                                                         ?></td>
                                        <td align="left"><input type="text" name="phone1" size="12" maxlength="12" value="<?php print $USER['phone1']; ?>" tabindex="6"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'phone2\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#phone2" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Data/Fax Number:<?php
                                                            if (is_int(strpos($required, 'G'))) {
                                                                print '<span style="color: #FF0000">*</span>';
                                                            }
                                                            ?></td>
                                        <td align="left"><input type="text" name="phone2" size="12" maxlength="12" value="<?php print $USER['phone2']; ?>" tabindex="7"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Change BBS Password
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbspassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#bbspassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            New BBS Password:</td>
                                        <td><input type="password" name="bbspassword" size="8" maxlength="8" tabindex="8"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbspassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#bbspassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Verify Password:</td>
                                        <td><input type="password" name="bbsverify" size="8" maxlength="8" tabindex="9"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Change VADV-PHP Password
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'webpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#bbspassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            New VADV-PHP Password:</td>
                                        <td><input type="password" name="webpassword" size="32" maxlength="32" tabindex="10"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'webpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#webpassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Verify Password:</td>
                                        <td><input type="password" name="webverify" size="32" maxlength="32" tabindex="11"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'resetwebpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#resetwebpassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Use BBS Password for VADV-PHP:</td>
                                        <td><input type="checkbox" name="resetwebpassword" value="1" tabindex="12"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Other Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'timezone\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#timezone" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            User Time Zone:</td>
                                        <td align="left">
                                            <select size="1" name="timezone" tabindex="13">
                                                <option value="0">Reset to BBS Time</option>
                                                <option value="-1200" <?php if ($USER_SETTINGS['timezone'] == -1200) print "selected"; ?>>GMT -12 Hours</option>
                                                <option value="-1100" <?php if ($USER_SETTINGS['timezone'] == -1100) print "selected"; ?>>GMT -11 Hours</option>
                                                <option value="-1000" <?php if ($USER_SETTINGS['timezone'] == -1000) print "selected"; ?>>GMT -10 Hours</option>
                                                <option value="-950" <?php if ($USER_SETTINGS['timezone'] == -950) print "selected"; ?>>GMT -9:30 Hours</option>
                                                <option value="-900" <?php if ($USER_SETTINGS['timezone'] == -900) print "selected"; ?>>GMT -9 Hours</option>
                                                <option value="-800" <?php if ($USER_SETTINGS['timezone'] == -800) print "selected"; ?>>GMT -8 Hours</option>
                                                <option value="-700" <?php if ($USER_SETTINGS['timezone'] == -700) print "selected"; ?>>GMT -7 Hours</option>
                                                <option value="-600" <?php if ($USER_SETTINGS['timezone'] == -600) print "selected"; ?>>GMT -6 Hours</option>
                                                <option value="-500" <?php if ($USER_SETTINGS['timezone'] == -500) print "selected"; ?>>GMT -5 Hours</option>
                                                <option value="-400" <?php if ($USER_SETTINGS['timezone'] == -400) print "selected"; ?>>GMT -4 Hours</option>
                                                <option value="-350" <?php if ($USER_SETTINGS['timezone'] == -350) print "selected"; ?>>GMT -3:30 Hours</option>
                                                <option value="-300" <?php if ($USER_SETTINGS['timezone'] == -300) print "selected"; ?>>GMT -3 Hours</option>
                                                <option value="-200" <?php if ($USER_SETTINGS['timezone'] == -200) print "selected"; ?>>GMT -2 Hours</option>
                                                <option value="-100" <?php if ($USER_SETTINGS['timezone'] == -100) print "selected"; ?>>GMT -1 Hour</option>
                                                <option value="1" <?php if ($USER_SETTINGS['timezone'] == 0) print "selected"; ?>>GMT</option>
                                                <option value="100" <?php if ($USER_SETTINGS['timezone'] == 100) print "selected"; ?>>GMT +1 Hour</option>
                                                <option value="200" <?php if ($USER_SETTINGS['timezone'] == 200) print "selected"; ?>>GMT +2 Hours</option>
                                                <option value="300" <?php if ($USER_SETTINGS['timezone'] == 300) print "selected"; ?>>GMT +3 Hours</option>
                                                <option value="350" <?php if ($USER_SETTINGS['timezone'] == 350) print "selected"; ?>>GMT +3:30 Hours</option>
                                                <option value="400" <?php if ($USER_SETTINGS['timezone'] == 400) print "selected"; ?>>GMT +4 Hours</option>
                                                <option value="450" <?php if ($USER_SETTINGS['timezone'] == 450) print "selected"; ?>>GMT +4:30 Hours</option>
                                                <option value="500" <?php if ($USER_SETTINGS['timezone'] == 500) print "selected"; ?>>GMT +5 Hours</option>
                                                <option value="550" <?php if ($USER_SETTINGS['timezone'] == 550) print "selected"; ?>>GMT +5:30 Hours</option>
                                                <option value="575" <?php if ($USER_SETTINGS['timezone'] == 575) print "selected"; ?>>GMT +5:45 Hours</option>
                                                <option value="600" <?php if ($USER_SETTINGS['timezone'] == 600) print "selected"; ?>>GMT +6 Hours</option>
                                                <option value="650" <?php if ($USER_SETTINGS['timezone'] == 650) print "selected"; ?>>GMT +6:30 Hours</option>
                                                <option value="700" <?php if ($USER_SETTINGS['timezone'] == 700) print "selected"; ?>>GMT +7 Hours</option>
                                                <option value="800" <?php if ($USER_SETTINGS['timezone'] == 800) print "selected"; ?>>GMT +8 Hours</option>
                                                <option value="875" <?php if ($USER_SETTINGS['timezone'] == 875) print "selected"; ?>>GMT +8:45 Hours</option>
                                                <option value="900" <?php if ($USER_SETTINGS['timezone'] == 900) print "selected"; ?>>GMT +9 Hours</option>
                                                <option value="950" <?php if ($USER_SETTINGS['timezone'] == 950) print "selected"; ?>>GMT +9:30 Hours</option>
                                                <option value="1000" <?php if ($USER_SETTINGS['timezone'] == 1000) print "selected"; ?>>GMT +10 Hours</option>
                                                <option value="1050" <?php if ($USER_SETTINGS['timezone'] == 1050) print "selected"; ?>>GMT +10:30 Hours</option>
                                                <option value="1100" <?php if ($USER_SETTINGS['timezone'] == 1100) print "selected"; ?>>GMT +11 Hours</option>
                                                <option value="1150" <?php if ($USER_SETTINGS['timezone'] == 1150) print "selected"; ?>>GMT +11:30 Hours</option>
                                                <option value="1200" <?php if ($USER_SETTINGS['timezone'] == 1200) print "selected"; ?>>GMT +12 Hours</option>
                                                <option value="1275" <?php if ($USER_SETTINGS['timezone'] == 1275) print "selected"; ?>>GMT +12:45 Hours</option>
                                                <option value="1300" <?php if ($USER_SETTINGS['timezone'] == 1300) print "selected"; ?>>GMT +13 Hours</option>
                                                <option value="1400" <?php if ($USER_SETTINGS['timezone'] == 1400) print "selected"; ?>>GMT +14 Hours</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'htmlencode\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#htmlencode" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            HTML Encoding:</td>
                                        <td align="left">
                                            <select size="1" name="htmlencode" tabindex="14">
                                                <option value="0" <?php if ($USER_SETTINGS['htmlencode'] == 0) print 'selected'; ?>>Basic Encoding</option>
                                                <option value="1" <?php if ($USER_SETTINGS['htmlencode'] == 1) print 'selected'; ?>>Enhanced Encoding</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'tagline\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#tagline" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Auto-Signature:</td>
                                        <td align="left">
                                            <select size="1" name="tagline" tabindex="15">
                                                <option value="0" <?php if ($USER_SETTINGS['tagline'] == 0) print 'selected'; ?>>None</option>
                                                <option value="1" <?php if ($USER_SETTINGS['tagline'] == 1) print 'selected'; ?>>User Macro A</option>
                                                <option value="2" <?php if ($USER_SETTINGS['tagline'] == 2) print 'selected'; ?>>User Macro B</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'mailfwd\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/edituser_help.php#mailfwd" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Forward Email Address:</td>
                                        <td>
                                            <input type="text" name="mailfwd" size="12" value="<?php if (($USER['mailfwdflag'] == 1) && ($USER['mailfwduserno'] != '')) {print $USER['mailfwduserno'] . '@' . $USER['mailfwdnode'];} else if (($USER['mailfwdflag'] == 1) && ($USER['mailfwdhandle'] != '')) {print $USER['mailfwdhandle'] . '@' . $USER['mailfwdnode'];} ?>" tabindex="16">
                                            <select name="mailfwdnetno" size="1" tabindex="17">
                                                <option <?php
                                                        if (($USER['mailfwdflag'] == 1) &&
                                                            ($USER['mailfwdnetno'] == 1) &&
                                                            ($USER['mailfwdnetnode'] == $VA_NEWORKS[1]['settings']['systemid'])) {
                                                            print 'selected ';
                                                        }
                                                        ?> value="0">Local</option>
                                                <?php
                                                $cnt = 0;
                                                $net = array();
                                                foreach($VA_NETWORKS as $netInfo) {
                                                    if ((isset($netInfo['nettype'])) &&
                                                        ($netInfo['nettype'] != 2) &&   // If not a VLive network
                                                        ($netInfo['nettype'] != 5)) {   // If not a QWK network
                                                        if ((isset($netInfo['settings']['systemid'])) &&
                                                            ($netInfo['settings']['systemid'] != '0')) {
                                                            if (($USER['securitylevel'] >= 255) ||
                                                                ($netInfo['accflag'] == '') ||                                  // If a access flag is set..
                                                                (strpos($USER['flags'], $netInfo['accflag']) !== FALSE)) {      // If the user has the flag
                                                                switch ($netInfo['nettype']) {
                                                                    case 1:
                                                                        $type = 'VirtualNET';
                                                                        break;
                                                                    case 3:
                                                                        $type = 'Internet';
                                                                        break;
                                                                    case 4:
                                                                        $type = 'FIDOnet';
                                                                        break;
                                                                    case 9:
                                                                        $type = 'WWIVnet';
                                                                        break;
                                                                    default:
                                                                        $type = 'Unknown';
                                                                        break;
                                                                }
                                                                $net[$cnt]['netno']    = $netInfo['netno'];
                                                                $net[$cnt]['desc']     = $netInfo['desc'];
                                                                $net[$cnt]['sortdesc'] = strtolower($netInfo['desc']);
                                                                $net[$cnt]['type']     = $type;
                                                                $cnt++;
                                                            }
                                                        }
                                                    }
                                                }
                                                // Organize the array alphabetically by description.
                                                $sortarr = array();
                                                foreach ($net as $row) {
                                                    $sortarr[] = $row['sortdesc'];
                                                }
                                                array_multisort($sortarr, $net);

                                                // Display the listing.
                                                for ($x = 0; $x < count($net); $x++) {
                                                    if (($USER['mailfwdflag'] == 1) && ($USER['mailfwdnetno'] == $net[$x]['netno'])) {
                                                        print '<option selected value="' . $net[$x]['netno'] . '">' . $net[$x]['desc'] . ' (' . $net[$x]['type'] . ")</option>\n";
                                                    } else {
                                                        print '<option value="' . $net[$x]['netno'] . '">' . $net[$x]['desc'] . ' (' . $net[$x]['type'] . ")</option>\n";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="center" colspan="2">
                                            <input type="submit" value="Apply" name="submit" tabindex="18">
                                            <input type="reset" value="Reset" name="submit" tabindex="19">
                                        </td>
                                    </tr>
                                </form>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="footer" height="40" align="center" colspan="2">
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a><br />
                                        <a class="footer" href="userinfo.php?u=<?php print $USER['userno']; ?>">Return to user information.</a>
                                    </td>
                                </tr>

                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>