<?php
/*
 * ----------------------------------------------------------------------------
 * UserInfo.php                                                      10/14/2006
 * This script will display information about selected users.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing User Profile';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Main configuration.

if (isset($_GET['u'])) {                    // Set the passed variables.
    $userno = (integer) $_GET['u'];
} else {
    RedirectUser($rootDir . 'index.php');
}

$user = GetUser($userno);                   // Get the user's information.

if (intval($user['laston']) == 0) {
    $user['laston'] = '000000';
}
$laston = substr($user['laston'], 2, 2) . '/' . substr($user['laston'], 4, 2) . '/' . substr($user['laston'], 0, 2);

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[User Information] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="<?php print $rootDir; ?>vconfig/VCONFIG.css" />
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40">
                                        <?php print 'Profile of: ' . HtmlSpace($user['handle']); ?>
                                    </td>
                                </tr>
                            </table>
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="footer" align="center" height="40">
                                        <?php
                                        if (($USER['userno'] == $userno) &&
                                            ($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                            print '<a class="footer" href="edituser.php">Edit your account.</a><br />';
                                        }

                                        if (($USER['securitylevel'] >= 255) &&
                                            ($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                            print '<a class="footer" href="usereditor.php?u=' . $user['userno'] . '">Edit this account (SysOp Editor).</a><br />';
                                        }

                                        if (($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct']) &&
                                            ($USER['userno'] != $userno) &&
                                            ($USER['securitylevel'] >= $VA_MAIN['emlothers'])) {
                                            print '<a class="footer" href="' . $rootDir . 'forums/post-email.php?u=' . $userno . '&referer=' . urlencode(GetCurrentURL()) . '">Email this user.</a><br />';
                                        }
                                        ?>
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="pre" align="left" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                        User #...: <span class="pre2"><?php print $user['userno']; ?></span><br />
                                        Handle...: <span class="pre2"><?php print HtmlSpace($user['handle']); ?></span><br />
                                        Real Name: <span class="pre2"><?php print HtmlSpace($user['realname']); ?></span><br />
                                        City.....: <span class="pre2"><?php print HtmlSpace($user['city']); ?></span><br />
                                        State....: <span class="pre2"><?php print $user['state']; ?></span><br />
                                        <?php
                                        if ($USER['userno'] == $userno) {
                                        ?>
                                        <br />
                                        Time Per Day...: <span class="pre2"><?php print $user['maxtime']; ?> minutes</span><br />
                                        Time Left Today: <span class="pre2"><?php print $user['maxtime'] - $user['timecounter']; ?> minutes</span><br />
                                        Time Bank Time.: <span class="pre2"><?php print $user['timebank']; ?> minutes</span><br />
                                        Credits........: <span class="pre2"><?php print $user['credits']; ?></span><br />
                                        <?php
                                        }
                                        ?>
                                        <br />
                                        Total Calls: <span class="pre2"><?php print $user['totalcalls']; ?></span><br />
                                        Total Time.: <span class="pre2"><?php print round($user['totaltime'] / 60, 2); ?> hours</span><br />
                                        Last Online: <span class="pre2"><?php print $laston; ?></span><br />
                                        <br />
                                        Uploaded Files..: <span class="pre2"><?php print $user['uplfiles']; ?></span><br />
                                        Uploaded KB.....: <span class="pre2"><?php print $user['uplkb']; ?> KB</span><br />
                                        Downloaded Files: <span class="pre2"><?php print $user['dlfiles']; ?></span><br />
                                        Downloaded KB...: <span class="pre2"><?php print $user['dlkb']; ?> KB</span><br />
                                        Total Posts.....: <span class="pre2"><?php print $user['totalposts']; ?></span><br />
                                        Total Emails....: <span class="pre2"><?php print $user['totalemail']; ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40">
                                        <?php
                                        if (($USER['userno'] == $userno) &&
                                            ($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                            print '<a class="footer" href="edituser.php">Edit your account.</a><br />';
                                        }

                                        if (($USER['securitylevel'] >= 255) &&
                                            ($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                            print '<a class="footer" href="usereditor.php?u=' . $user['userno'] . '">Edit this account (SysOp Editor).</a><br />';
                                        }

                                        if (($USER['userno'] > 0) &&
                                            ($USER['userno'] != $CONFIG['guestacct']) &&
                                            ($USER['userno'] != $userno) &&
                                            ($USER['securitylevel'] >= $VA_MAIN['emlothers'])) {
                                            print '<a class="footer" href="' . $rootDir . 'forums/post-email.php?u=' . $userno . '&referer=' . urlencode(GetCurrentURL()) . '">Email this user.</a><br />';
                                        }
                                        ?>
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>