<?php
/*
 * ----------------------------------------------------------------------------
 * Who.php                                                           10/14/2006
 * This script will display the who's online screen for all configured nodes of
 * your BBS.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Who\'s Online';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Main configuration.
require_once($includeDir . 'va-control.inc.php');   // Control.dat functions.

$who = GetControl();
$maxChannel = 10;   // Display only first 10 channels.
if ($VA_MAIN['maxchannelno'] < 10) {
    $maxChannel = $VA_MAIN['maxchannelno'];
}
if ($who['nodetotal'] < $maxChannel) {
    $maxChannel = $who['nodetotal'];
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Who's Online] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<?php
if ($CONFIG['refresh'] > 0) {
    print '<meta http-equiv="refresh" content="' . $CONFIG['refresh'] . '" />' . "\n";
}
?>
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .footer            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
    .header            { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000">
<p class="title" align="right">Virtual Advanced Who's Online
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <center>
    <table border="0" cellspacing="10" cellpadding="0">
        <tr>
            <td align="right" valign="top" width="40" style="border-bottom: 1px solid #525552">
                <span class="header">Ch #</span></td>
            <td align="right" valign="top" width="60" style="border-bottom: 1px solid #525552">
                <span class="header">User #</span></td>
            <td align="left" valign="top" width="230" style="border-bottom: 1px solid #525552">
                <span class="header">Handle</span></td>
            <td align="left" valign="top" width="230" style="border-bottom: 1px solid #525552">
                <span class="header">Action</span></td>
            <td align="left" valign="top" width="60" style="border-bottom: 1px solid #525552">
                <span class="header">Baud</span></td>
        </tr>
        <tr>
            <td class="body" align="right" valign="top">
<?php
for ($x = 0; $x <= $maxChannel; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td class="body" align="right" valign="top">
<?php
for ($x = 0; $x <= $maxChannel; $x++) {
    print '<span style="color: #5255FF">' . $who[$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 0; $x <= $maxChannel; $x++) {
    print '<a href="userinfo.php?u=' . $who[$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($who[$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 0; $x <= $maxChannel; $x++) {
    print '<span style="color: #FFFF52">' . HtmlSpace($who[$x]['action']) . '</span><br />' . "\n";
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 0; $x <= $maxChannel; $x++) {
    if ($who[$x]['baudrate'] == 0) {
        print '<span style="color: #52FF52">Local<br />' . "\n";
    } else if ($who[$x]['baudrate'] == 11520) {
        print '<span style="color: #52FF52">115200<br />' . "\n";
    } else if ($who[$x]['baudrate'] == 4294967295) {
        print '<span style="color: #52FF52"><br />' . "\n";
    } else {
        print '<span style="color: #52FF52">' . $who[$x]['baudrate'] . '</span><br />' . "\n";
    }
}
?>
            </td>
        </tr>
        <tr>
<?php
// Get number of guests...
$totalGuests = 0;
for ($x = 1; $x <= $VA_USERS[0]; $x++) {
    if (($VA_USERS[$x]['userno'] == 0) ||
        ($VA_USERS[$x]['userno'] == $CONFIG['guestacct'])) {
        $totalGuests++;
    }
}
if ($totalGuests > 0) {
    $totalUsers = $VA_USERS[0] - $totalGuests + 1;
} else {
    $totalUsers = $VA_USERS[0];
}
?>
            <td class="body" align="right" valign="top">
<?php
for ($x = 1; $x <= $totalUsers; $x++) {
    print '<span style="color: #FF5552">Web</span><br />' . "\n";
}
?>
            </td>
            <td class="body" align="right" valign="top">
<?php
for ($x = 0; $x <= $VA_USERS[0]; $x++) {
    if (($x == 0) && ($totalGuests > 0)) {
        print '<span style="color: #5255FF">0</span><br />' . "\n";
    } else {
        if (($VA_USERS[$x]['userno'] > 0) &&
            ($VA_USERS[$x]['userno'] != $CONFIG['guestacct'])) {
            print '<span style="color: #5255FF">' . $VA_USERS[$x]['userno'] . '</span><br />' . "\n";
        }
    }
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 0; $x <= $VA_USERS[0]; $x++) {
    if (($x == 0) && ($totalGuests > 0)) {
        if ($totalGuests == 1) {
            print '<span style="color: #FFFFFF">Guest</span><br />' . "\n";
        } else {
            print '<span style="color: #FFFFFF">Guests (' . $totalGuests . ')</span><br />' . "\n";
        }
    } else {
        if (($VA_USERS[$x]['userno'] > 0) &&
            ($VA_USERS[$x]['userno'] != $CONFIG['guestacct'])) {
            print '<a href="userinfo.php?u=' . $VA_USERS[$x]['userno'] . '"><span style="color: #FFFFFF">' . $VA_USERS[$x]['handle'] . '</span></a><br />' . "\n";
        }
    }
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 0; $x <= $VA_USERS[0]; $x++) {
    if (($x == 0) && ($totalGuests > 0)) {
        print '<span style="color: #FFFF52">Browsing</span><br />' . "\n";
    } else {
        if (($VA_USERS[$x]['userno'] > 0) &&
            ($VA_USERS[$x]['userno'] != $CONFIG['guestacct'])) {
            print '<span style="color: #FFFF52">' . $VA_USERS[$x]['action'] . '</span><br />' . "\n";
        }
    }
}
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
for ($x = 1; $x <= $totalUsers; $x++) {
    print '<span style="color: #52FF52">VADV-PHP</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
    </center>
</div>

<?php
GlobalFooter(1);
?>

</body>

</html>