// Tooltip javascript. Use with <span></span> tags.

var _tooltipPauseBeforeShow = 200; // miliseconds to pause before showing the tooltip.
var _tooltipDelay = 0;             // seconds before auto hiding. set 0 to make it permanent.
var _tooltipBgColor = "yellow";    // background color of tooltip box
var _tooltipTextColor = "black";   // color of tooltip text.
var _tooltipFontFamily = "Tahoma"; // font family of tooltip text.
var _tooltipFontSize = 12;         // font size of tooltip text.
var _tooltipFontBold = true;       // whether the tooltip text will be bold or not

var _tooltipContainerName = "TooltipContainer_V1";

window.onload = function WindowLoad(event) {
    var arrSpans = document.getElementsByTagName("span");
    var tooltipCount = 0;
    for (var i = 0; i < arrSpans.length; i++) {
        var objSpan = arrSpans[i];
        if ((objSpan.attributes["tooltip_v1"]) && (objSpan.attributes["tooltip_v1"].value.length > 0)) {
            objSpan.onmouseover = ShowToolTip;
            objSpan.onmouseout = HideToolTip;
            tooltipCount++;
        }
    }
    if (tooltipCount > 0) {
        document.onclick = HideToolTip;
    }
}


function ShowToolTip(event) {
    if ((typeof event == "undefined") || (!event)) {
        event = window.event;
    }

    var objContainer = document.getElementById(_tooltipContainerName);
    var objSource = event.srcElement || event.target;

    if ((typeof objSource == "undefined") || (!objSource)) {
        return false;
    }

    if (!objContainer) {
        objContainer = document.createElement("div");
        objContainer.id = _tooltipContainerName;
        objContainer.style.backgroundColor = _tooltipBgColor;
        objContainer.style.color = _tooltipTextColor;
        objContainer.style.fontFamily = _tooltipFontFamily;
        objContainer.style.fontSize = _tooltipFontSize;
        if (_tooltipFontBold) {
            objContainer.style.fontWeight = "bold";
        }
        objContainer.style.position = "absolute";
        objContainer.style.display = "none";
        objContainer.style.padding = "1px 4px 1xp 4px";
        document.body.appendChild(objContainer);
    }

    var mouseX = event.x || event.pageX;
    var mouseY = event.y || event.pageY;

    var scrollX = document.body.scrollLeft;
    var scrollY = document.body.scrollTop;

    objContainer.style.left = (mouseX + scrollX + 15) + "px";
    objContainer.style.top = (mouseY + scrollY) + "px";

    var strText = (objSource.attributes["tooltip_v1"])?objSource.attributes["tooltip_v1"].value:"";

    if (strText.length == 0) {
        return false;
    }

    objContainer.innerHTML = strText;
    setTimeout("_ShowTooltipContainer();", _tooltipPauseBeforeShow);

    if (_tooltipDelay > 0) {
        setTimeout("HideToolTip();", _tooltipDelay * 1000);
    }

    return true;
}


function HideToolTip(event) {
    var objContainer = document.getElementById(_tooltipContainerName);
    if (objContainer) {
        objContainer.style.display = "none";
    }
}


function _ShowTooltipContainer() {
    var objContainer = document.getElementById(_tooltipContainerName);

    if (objContainer) {
        objContainer.style.display = "block";
    }
}
