<?php
/*
 * ----------------------------------------------------------------------------
 * Upload.php                                                        10/14/2006
 * This script will allow a web user to upload a file from their computer to
 * the BBS. Depending on the BBS configuration, the file is either placed in
 * a holding directory or is immediately added to the current database.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Uploading a File';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

ob_end_clean();                             // Turn off buffering.

if ((!isset($_POST['referer'])) && (!isset($_GET['referer']))) {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}
if (isset($_GET['referer'])) {
    $_POST['referer'] = urldecode($_GET['referer']);
}

// Check the passed parameters. This script will look directly at the database
// to determine the filename instead of passing the filename and path directly.
if (isset($_POST['t'])) {                   // Set the passed variables.
    $t = htmlspecialchars($_POST['t']);
} else {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_POST['d'])) {                   // Set the passed variables.
    $d = (integer) $_POST['d'];
} else {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

// Check to see if this page was referred by another page, and check to see where
// that page was at.
if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

// Check user security levels, secure upload, and if uploads are even enabled.
if ((($USER['securitylevel'] < 255) &&
     ($CONFIG['fileupload'] != 1)) ||
    (trim(ini_get('file_uploads')) == '')) {
    die('<br /><h4>This server does not allow uploads. Please press the BACK button on your browser.</h4>');
} else if (!is_dir(ini_get('upload_tmp_dir'))) {
    die('<br /><h4>This server supports uploads, but there is a configuration error. Please press the BACK button on your browser.</h4>');
} else if (($USER['securitylevel'] < 255) &&
           ((($USER['userno'] == 0) ||
             ($USER['userno'] == $CONFIG['guestacct']) ||
             ($USER['securitylevel'] < $CONFIG['fileuploadsl'])) ||
            (($VA_MAIN['secuploads'] == 0) &&
             ($USER['securitylevel'] < $db['minwritesl'])))) {
    die('<br /><h4>You do not have access to upload files. Please press the BACK button on your browser.</h4>');
}

$db = GetDBInfo($t, $d);                    // Retrieve database information.

// Check to see if the file was already uploaded, if so then process it.
if ((isset($_POST['uploadflag'])) && ($_POST['uploadflag'] == 1)) {
    if (isset($_POST['desc'])) {
        $description = trim($_POST['desc']);
    } else {
        $description = 'NO DESCRIPTION';
    }
    
    if (isset($_POST['longdesc'])) {
        $longDescription = trim($_POST['longdesc']);
    } else {
        $longDescription = '';
    }

    $filename = '';
    if ((isset($_FILES['file'])) && ($_FILES['file']['size'] > 0)) {
        if ($_FILES['file']['error'] == 'UPLOAD_ERR_OK') {
            if (is_uploaded_file($_FILES['file']['tmp_name'])) {
                if ($VA_MAIN['secuploads'] == 1) {  // If secure upload, put file in sysop dir and add to upload database.
                    $dbInfo = SetUploadInfo();      // Get database information.
                } else {                            // If not secure upload, put file in actual dir and database.
                    $dbInfo = $db;                  // Get database information.
                }
                if ($CONFIG['filehost'] == '') {
                    $fileDirectory = $dbInfo['filepath'];
                } else {
                    $fileDirectory = ConvertDir($CONFIG['filehost'], $dbInfo['filepath']);
                }

                $filename     = ConvertLongFilename($_FILES['file']['name'], $fileDirectory);
                $fullFilename = $fileDirectory . '/' . $filename;
                $fullFilename = str_replace('/', "\\", $fullFilename);
                if (!is_dir($fileDirectory)) {
                    mkdir($fileDirectory);
                }
                move_uploaded_file($_FILES['file']['tmp_name'], $fullFilename);

                // Add any information to the message itself.
                if ($filename != $_FILES['file']['name']) {
                    $longDescription = rtrim($longDescription) . "\r\n\r\n\r\n--------------";
                    $longDescription = $longDescription . "\r\nOriginal filename: " . $_FILES['file']['name'] . "\r\nThe filename was changed for compatibility reasons.";
                }
                
                $log = 'File Upload     "' . $USER['handle'] . '" --> "' . $filename . '" - ' . $description;
                WriteLog('VADV-PHP.LOG', $log);         // Log the email.

                // Add new record to the database.
                WriteFile($dbInfo, $USER['userno'], $description, $longDescription, $fullFilename);

                // Redirect the user.
                RedirectUser($_POST['referer']);
            }
        } else {
            switch ($_FILES['file']['error']) {
                case 'UPLOAD_ERR_FORM_SIZE':
                    unlink($_FILES['file']['tmp_name']);
                    die('<br /><h4>Attached file is too big (>' . ini_get('upload_max_filesize') . '). Please press the BACK button on your browser.</h4>');
                    break;
                case 'UPLOAD_ERR_PARTIAL':
                    unlink($_FILES['file']['tmp_name']);
                    die('<br /><h4>Attached file upload was interrupted. Please press the BACK button on your browser.</h4>');
                    break;
                case 'UPLOAD_ERR_NO_FILE':
                    die('<br /><h4>Invalid attachment. Please press the BACK button on your browser.</h4>');
                    break;
                default:
                    die('<br /><h4>An error with the file attachment occurred. Please press the BACK button on your browser.</h4>');
                    break;
            }
        }
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>
<head>
<title>[File Upload] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow">
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn">
<style type="text/css">
<!--
    a:active            { color: #FF0000 }
    a:link              { color: #0000D0 }
    a:visited           { color: #0000D0 }
    a:hover             { color: #FF0000 }
    .body               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #000000; }
    .title              { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #000000; font-weight: bold }
-->
</style>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            if ((form.file.value.length == 0) ||
                (form.desc.value.length == 0)) {
                alert("Please enter a valid filename and description.");
                form.file.focus();
                return false;
            }
            submitted = 1;
            form.submit.disabled = true;
            form.reset.disabled = true;
            form.cancel.disabled = true;
            return true;
        }
    }

    function HelpWindow(bmark) {
        var url = "./help/upload_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body bgcolor="#FFFFFF" onload="document.upload.file.focus();">
<form name="upload" method="POST" action="upload.php" enctype="multipart/form-data" onsubmit="return validate(upload)">
    <input type="hidden" name="referer" value="<?php print $_POST['referer']; ?>">
    <input type="hidden" name="t" value="<?php print $t; ?>">
    <input type="hidden" name="d" value="<?php print $d; ?>">
    <input type="hidden" name="uploadflag" value="1">
    <div align="center">
    <center>

    <table cellspacing="0" cellpadding="0" width="750" border="0" style="border-collapse: collapse" bordercolor="#111111">
        <tr>
            <td class="body" align="left">
                <span class="title"><a href="http://www.vadvphp.com"><img border="0" src="./images/vadv-php.gif" alt="VADV-PHP" width="50" height="30" align="absbottom"></a>&nbsp;&nbsp;&nbsp;<?php print HtmlSpace($VA_MAIN['bbsname']); ?> File Area</span>
                <hr color="#525552">
                <p>
                Enter a valid filename and give it a description. Please upload files in the appropriate category.<br />
                You can currently only upload one file at a time.
                <?php
                    if ($VA_MAIN['secuploads'] == 1) {
                        print "<br /><b>Secure uploads is on. Your upload will be validated by the SysOp.</b>\n";
                    }
                ?>
                </p>
                <table border="1" cellpadding="2" cellspacing="0" style="border-collapse: collapse" width="750" bordercolor="#666666" bgcolor="#E2E2E2">
                    <tr>
                        <td>
                            <table>
                                <tr>
                                    <td class="body" align="left" width="90" height="25" valign="top">
                                        <b>Filename:</b>
                                    </td>
                                    <td align="left" height="25">
                                        <?php
                                        $maxsize = ini_get('upload_max_filesize');
                                        $megpos  = strpos(strtoupper($maxsize), 'M');
                                        if ($megpos !== FALSE) {
                                            $maxsize = (integer) $maxsize;
                                            $maxsize = 1024 * 1024 * $maxsize;
                                        }
                                        ?>
                                        <input type="hidden" name="MAX_FILE_SIZE" value="<?php print $maxsize; ?>">
                                        <input name="file" type="file" size="64" tabindex="1">
                                    </td>
                                </tr>
                                <tr>
                                    <td class="body" align="left"width="90" height="25" valign="top">
                                        <b>Description:</b>
                                    </td>
                                    <td align="left" height="25">
                                        <input name="desc" type="text" size="64" maxlength="64" tabindex="2">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="./images/help.gif" alt="Upload Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="./help/upload_help.php" target="helpwindow"><img border="0" src="./images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="body" align="left" width="90" height="50" valign="top">
                                        Long Description:
                                    </td>
                                    <td align="left" height="50">
                                        <textarea name="longdesc" rows="10" cols="81" wrap="soft" tabindex="3"></textarea>
                                    </td>
                                </tr>
                            </table>
                            <table border="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="100%" cellpadding="2">
                                <tr>
                                    <td align="right" width="400">
                                        <input type="submit" value="Submit" name="submit" tabindex="4">
                                        <input type="reset" value="Reset" name="reset" tabindex="5">
                                    </td>
                                    <td align="left">
                                            <input type="button" value="Cancel" name="cancel" tabindex="5" onclick="javascript:document.location.href='<?php print $_POST['referer']; ?>'">
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
    </div>
</form>
</body>
</html>

<?php
GlobalFooter(0, 1);
?>