<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig.php                                                       10/14/2006
 * This is the web-based version of the vconfig configuration utility.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) || ($USER['userno'] == $CONFIG['guestacct']) || ($USER['securitylevel'] == 0)) die(VA_LoginError());
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser('systemlogin.php?url=' . urlencode(GetCurrentURL()));
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>VADV-PHP VConfig</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="VCONFIG.css" />
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
            <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                <tr>
                    <td align="center">
                        <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                            <tr>
                                <td class="heading" align="center" height="40">
                                VADV-PHP VConfig Menu
                                </td>
                            </tr>
                            <tr>
                                <td class="body" align="center" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                <a class="pre2" href="vconfig_vadv-php.php">VADV-PHP Configuration</a><br />
                                <a class="pre2" href="vconfig_main.php">Main Configuration</a><br />
                                Channel Configuration<br />
                                Database Configuration<br />
                                <a class="pre2" href="vconfig_paths.php">Paths Configuration</a><br />
                                Download Protocols<br />
                                Upload Protocols<br />
                                Network Configuration<br />
                                Events Configuration<br />
                                Control Panel Configuration<br />
                                Doors Configuration<br />
                                Voting Booth<br />
                                Random Messages<br />
                                Text Sections Configuration<br />
                                Multi-Feedback Configuration<br />
                                User Quick Validation
                                </td>
                            </tr>
                            <tr>
                                <td class="footer" align="center" height="40">
                                <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>