<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_Paths.php                                                 10/14/2006
 * VConfig's path configuration.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser('systemlogin.php?url=' . urlencode(GetCurrentURL()));
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>VADV-PHP VConfig (Paths Configuration)</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="VCONFIG.css">
<script language="JavaScript" type="text/javascript">
<!--
    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/vconfig_paths_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40" colspan="2">
                                        Paths Configuration
                                    </td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <form name="pathscfg" method="post" action="vconfig_paths_process.php">
                                    <input type="hidden" name="process" value="1">
                                    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            System Paths<br />
                                            <span class="footer">Note: If you make a mistake on this page, it is a good<br />chance that all VADV-PHP pages will stop functioning!</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Main Directory:</td>
                                        <td align="left"><input type="text" name="main" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['main']);} else {print $VA_SYSPATHS['main'];} ?>" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Scripts Directory:</td>
                                        <td align="left"><input type="text" name="script" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['script']);} else {print $VA_SYSPATHS['script'];} ?>" tabindex="2"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Data Directory:</td>
                                        <td align="left"><input type="text" name="data" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['data']);} else {print $VA_SYSPATHS['data'];} ?>" tabindex="3"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            System Text Directory:</td>
                                        <td align="left"><input type="text" name="text" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['text']);} else {print $VA_SYSPATHS['text'];} ?>" tabindex="4"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            CONTROL.DAT Directory:</td>
                                        <td align="left"><input type="text" name="control" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['control']);} else {print $VA_SYSPATHS['control'];} ?>" tabindex="5"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Temporary Directory:</td>
                                        <td align="left"><input type="text" name="temp" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['temp']);} else {print $VA_SYSPATHS['temp'];} ?>" tabindex="6"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Database Directory:</td>
                                        <td align="left"><input type="text" name="db" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['db']);} else {print $VA_SYSPATHS['db'];} ?>" tabindex="7"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Upload/Email Directory:</td>
                                        <td align="left"><input type="text" name="sysop" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['sysop']);} else {print $VA_SYSPATHS['sysop'];} ?>" tabindex="8"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_paths_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            FDX Database Directory:</td>
                                        <td align="left"><input type="text" name="fdx" size="40" maxlength="40" value="<?php if ($CONFIG['hostname'] != '') {print ConvertUnc($VA_SYSPATHS['fdx']);} else {print $VA_SYSPATHS['fdx'];} ?>" tabindex="9"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="center" colspan="2">
                                            <input type="submit" value="Apply" name="submit" tabindex="10">
                                            <input type="reset" value="Reset" name="submit" tabindex="11">
                                            <input type="submit" value="Cancel" name="submit" tabindex="12">
                                        </td>
                                    </tr>
                                </form>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>